<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Form\FormError;
use Doctrine\Common\Collections\Criteria;
use Doctrine\Persistence\ManagerRegistry;

use App\Entity\Notice;
use App\Form\NoticeType;

class NoticeController extends AbstractController
{
    private $nameentity  = 'Notice';
    private $labelentity = 'App\Entity\Notice';
    private $labelroute  = 'app_portal_config_notice';
    private $labeldata   = 'notice';
    private $labeldatas  = 'notices';

    public function list(ManagerRegistry $em)
    {
        $notices = $em->getRepository($this->labelentity)->findAll();        
        $groups = $em->getRepository('App\Entity\Group')->findBy([], ['label' => 'asc']);

        return $this->render($this->nameentity.'\list.html.twig', [
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => true,            
            'notices'           => $notices,
            'groups'            => $groups
        ]);
    }

    public function ajaxseleclist(Request $request,ManagerRegistry $em)
    {
        // S'assurer que c'est un appel ajax
        if (!$request->isXmlHttpRequest()) {
            return new JsonResponse(array('message' => 'Interdit'), 400);
        }

        $output=array();
        $page_limit=$request->query->get('page_limit');
        $q=$request->query->get('q');
        
        $qb = $em->getManager()->createQueryBuilder();
        $qb->select('table')->from("App\Entity\Notice",'table')
           ->where('table.title LIKE :value')
           ->setParameter("value", "%".$q."%")
           ->orderBy('table.title');
        
        $datas=$qb->setFirstResult(0)->setMaxResults($page_limit)->getQuery()->getResult();
        foreach($datas as $data) {
            array_push($output,array("id"=>$data->getId(),"text"=>$data->getTitle()));
        }

        $response = new Response(json_encode($output));    
        $response->headers->set('Content-Type', 'application/json');      
        return $response;
    } 

    public function submit(Request $request,ManagerRegistry $em)
    {
        // Initialisation de l'enregistrement
        $data = new Notice();
        
        // Création du formulaire
        $form = $this->createForm(NoticeType::class,$data,array("mode"=>"submit"));

        // Récupération des data du formulaire
        $form->handleRequest($request);
        
        // Sur erreur
        $this->getErrorForm(null,$form,$request,$data,"submit");
        
        // Sur validation
        if ($form->get('submit')->isClicked() && $form->isValid()) {  
            $data = $form->getData();  

            // Sauvegarde
            $em->getManager()->persist($data);
            $em->getManager()->flush();

            // Retour à la liste
            return $this->redirectToRoute($this->labelroute);
        }
        
        // Affichage du formulaire
        return $this->render($this->nameentity.'\edit.html.twig', [
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => true,            
            $this->labeldata    => $data,
            'mode'              => 'submit',
            'icons'             => $em->getRepository("App\Entity\Icon")->findAll(),
            'form'              => $form->createView()
        ]);
    }  

    public function update($id,Request $request,ManagerRegistry $em)
    {
        // Récupération de l'enregistrement courant 
        $data=$this->getData($em,$id);
        
        // Vérifier que cet enregistrement est modifiable
                                    
        // Création du formulaire
        $form = $this->createForm(NoticeType::class,$data,array(
            "mode"      => "update"
        ));

        // Récupération des data du formulaire
        $form->handleRequest($request);
    
        // Sur erreur
        $this->getErrorForm($id,$form,$request,$data,"update");
        
        // Sur validation
        if ($form->get('submit')->isClicked() && $form->isValid()) {
            $data = $form->getData();

            // Sauvegarde
            $em->getManager()->flush();

            // Retour à la liste
            return $this->redirectToRoute($this->labelroute);
        }
        
       
        // Affichage du formulaire
        return $this->render($this->nameentity.'\edit.html.twig', [
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => true,            
            $this->labeldata    => $data,
            'mode'              => 'update',
            'form'              => $form->createView()
        ]);
    }

    public function delete($id,Request $request,ManagerRegistry $em)
    {
        // Récupération de l'enregistrement courant 
        $data=$this->getData($em,$id);

        // Vérifier que cet enregistrement est supprimable

        // Supprimer la donnée
        $em->getManager()->remove($data);
        $em->getManager()->flush();
        
        return $this->redirectToRoute($this->labelroute);
    }

    public function users($id,ManagerRegistry $em)
    {
        $notice = $this->getData($em,$id);        
        
        return $this->render($this->nameentity.'\users.html.twig', [
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => true,            
            'notice'            => $notice,
        ]);
    }    

    public function usersdelete($id,$userid,ManagerRegistry $em)
    {
        $notice = $this->getData($em,$id);      
        
        $user = $em->getRepository("App\Entity\User")->find($userid);
        $notice->removeUser($user);
        $em->getManager()->flush();

        return $this->render($this->nameentity.'\users.html.twig', [
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => true,            
            'notice'            => $notice,
        ]);
    } 

    public function usersdeleteall($id,ManagerRegistry $em)
    {
        $notice = $this->getData($em,$id);  

        foreach($notice->getUsers() as $user) {
            $notice->removeUser($user);
        }
        $em->getManager()->flush();

        return $this->render($this->nameentity.'\users.html.twig', [
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => true,            
            'notice'            => $notice,
        ]);
    }

    public function haveread(Request $request,ManagerRegistry $em)
    {
        $user=$this->getUser();
        $notices=$em->getRepository("App\Entity\Notice")->getNoticeToRead($user);
            
        // Récupération redirection potentielle
        $id = $request->get('id');

        foreach($notices as $notice) {
            $users=$notice->getUsers();

            $userCriteria = Criteria::create()->where(Criteria::expr()->eq('id', $user->getId())); 
            $userCollection = $notice->getUsers()->matching($userCriteria);

            if($userCollection->isEmpty()) {
                $notice->addUser($user);
                $em->getManager()->flush();
            }
        }

        return $this->redirectToRoute("app_core_home",["id"=>$id]);
    }

    public function view(Request $request,ManagerRegistry $em) {
        $user=$this->getUser();
        $notices=$em->getRepository("App\Entity\Notice")->getNoticeUser($user,false);

        return $this->render($this->nameentity.'\view.html.twig',[
            'useheader'     => true,
            'usemenu'       => false,
            'usesidebar'    => false,  
            'maxwidth'      => true,
            'notices'       => $notices,
        ]);
    }

    protected function getDatas($em)
    {
        $datas = $em->getRepository($this->labelentity)->findAll();
        return $datas;
    } 
            
    protected function getData($em,$id)
    {
        $data = $em->getRepository($this->labelentity)->find($id);

        if (!$data) {
            throw $this->createNotFoundException('Unable to find '.$this->labeldata);
        }

        return $data;
    } 

    protected function getErrorForm($id,$form,$request,$data,$mode) {
        if ($form->get('submit')->isClicked()&&$mode=="delete") {
        }

        if ($form->get('submit')->isClicked() && $mode!="delete") {
            if(is_null($data->getDescription())) {
                $form->addError(new FormError('Description obligatoire'));
            }
        }

        if ($form->get('submit')->isClicked() && !$form->isValid()) {
            $errors = $form->getErrors();
            foreach( $errors as $error ) {
                $request->getSession()->getFlashBag()->add("error", $error->getMessage());
            }
        }
    }    
}
