<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Project
 *
 * @ORM\Entity
 * @ORM\Table(name="project")
 * @ORM\Entity(repositoryClass="App\Repository\ProjectRepository")
 * @ORM\HasLifecycleCallbacks
 */
class Project
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="name", type="string", length=100)
     */
    private $name;

    /**
     * @var string
     *
     * @ORM\Column(name="roles", type="array", nullable=true)
     */
    private $roles;

    /**
     * @ORM\ManyToMany(targetEntity="Group", inversedBy="projects", cascade={"persist"})
     * @ORM\JoinTable(name="projectgroupe",
     *   joinColumns={@ORM\JoinColumn(name="project", referencedColumnName="id")},
     *   inverseJoinColumns={@ORM\JoinColumn(name="groupe", referencedColumnName="id")}
     * )
     */
    protected $groups;

    /**
     * @ORM\ManyToOne(targetEntity="User", inversedBy="projects")
     * @ORM\JoinColumn(nullable=true)
     */
    private $user;

    /**
     * @ORM\ManyToMany(targetEntity="User", inversedBy="projectwriters", cascade={"persist"})
     * @ORM\JoinTable(name="projectwriter",
     *   joinColumns={@ORM\JoinColumn(name="project", referencedColumnName="id")},
     *   inverseJoinColumns={@ORM\JoinColumn(name="user", referencedColumnName="id")}
     * )
     */
    protected $writers;

    /**
     * @var ArrayCollection $projecttask
     * @var Blogarticle
     *
     * @ORM\OneToMany(targetEntity="Projecttask", mappedBy="project", cascade={"persist"}, orphanRemoval=true)
     */
    private $projecttasks;


    /* champs calculé non stocké en base */
    private $canupdate;
    public function getCanupdate()
    {
        return $this->canupdate;
    }    
    public function setCanupdate($canupdate)
    {
        $this->canupdate = $canupdate;
        return $this;
    }

    /* champs calculé non stocké en base */
    private $canadd;
    public function getCanadd()
    {
        return $this->canadd;
    }    
    public function setCanadd($canadd)
    {
        $this->canadd = $canadd;
        return $this;
    }

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->groups = new \Doctrine\Common\Collections\ArrayCollection();
        $this->writers = new \Doctrine\Common\Collections\ArrayCollection();
        $this->projecttasks = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set name
     *
     * @param string $name
     *
     * @return Project
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set roles
     *
     * @param array $roles
     *
     * @return Project
     */
    public function setRoles($roles)
    {
        $this->roles = $roles;

        return $this;
    }

    /**
     * Get roles
     *
     * @return array
     */
    public function getRoles()
    {
        return $this->roles;
    }

    /**
     * Add group
     *
     * @param Group $group
     *
     * @return Project
     */
    public function addGroup(Group $group)
    {
        $this->groups[] = $group;

        return $this;
    }

    /**
     * Remove group
     *
     * @param Group $group
     */
    public function removeGroup(Group $group)
    {
        $this->groups->removeElement($group);
    }

    /**
     * Get groups
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getGroups()
    {
        return $this->groups;
    }

    /**
     * Set user
     *
     * @param User $user
     *
     * @return Project
     */
    public function setUser(User $user = null)
    {
        $this->user = $user;

        return $this;
    }

    /**
     * Get user
     *
     * @return User
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * Add writer
     *
     * @param User $writer
     *
     * @return Project
     */
    public function addWriter(User $writer)
    {
        $this->writers[] = $writer;

        return $this;
    }

    /**
     * Remove writer
     *
     * @param User $writer
     */
    public function removeWriter(User $writer)
    {
        $this->writers->removeElement($writer);
    }

    /**
     * Get writers
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getWriters()
    {
        return $this->writers;
    }

    /**
     * Add projecttask
     *
     * @param Projecttask $projecttask
     *
     * @return Project
     */
    public function addProjecttask(Projecttask $projecttask)
    {
        $this->projecttasks[] = $projecttask;

        return $this;
    }

    /**
     * Remove projecttask
     *
     * @param Projecttask $projecttask
     */
    public function removeProjecttask(Projecttask $projecttask)
    {
        $this->projecttasks->removeElement($projecttask);
    }

    /**
     * Get projecttasks
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getProjecttasks()
    {
        return $this->projecttasks;
    }
}
