<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Projecttask
 *
 * @ORM\Entity
 * @ORM\Table(name="projecttask")
 * @ORM\Entity(repositoryClass="App\Repository\ProjecttaskRepository")
 * @ORM\HasLifecycleCallbacks
 */
class Projecttask
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="name", type="string", length=100)
     */
    private $name;

    /**
    * @var string
    *
    * @ORM\Column(name="description", type="text", nullable=true)
    */
    private $description;

    /**
     * @ORM\Column(name="submit", type="datetime")
     */
    private $submit;   

    /**
     * @ORM\Column(name="priority", type="integer")
     */
    private $priority;   

    /**
     * @ORM\Column(name="end", type="datetime", nullable=true)
     */
    private $end;   

        /**
     * @ORM\Column(name="percentage", type="integer")
     */
    private $percentage;

    /**
     * @ORM\ManyToOne(targetEntity="User", inversedBy="projecttasks")
     * @ORM\JoinColumn(nullable=true)
     */
    private $user;

    /**
     * @ORM\ManyToOne(targetEntity="User", inversedBy="projectownertasks")
     * @ORM\JoinColumn(nullable=false)
     */
    private $owner;

    /**
     * @ORM\ManyToOne(targetEntity="Project", inversedBy="projecttasks")
     * @ORM\JoinColumn(nullable=false)
     */
    private $project;

    /**
     * @ORM\ManyToOne(targetEntity="Projecttasktag", inversedBy="projecttasks")
     * @ORM\JoinColumn(nullable=true)
     */
    private $projecttasktag;

    /**
     * @ORM\ManyToOne(targetEntity="Projecttaskstatus", inversedBy="projecttasks")
     * @ORM\JoinColumn(nullable=true)
     */
    private $projecttaskstatus;


    /**
     * @var ArrayCollection $projectcomment
     * @var Projectcomment
     *
     * @ORM\OneToMany(targetEntity="Projectcomment", mappedBy="projecttask", cascade={"persist"}, orphanRemoval=true)
     */
    private $projectcomments;

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set name
     *
     * @param string $name
     *
     * @return Projecttask
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set description
     *
     * @param string $description
     *
     * @return Projecttask
     */
    public function setDescription($description)
    {
        $this->description = $description;

        return $this;
    }

    /**
     * Get description
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Set submit
     *
     * @param \DateTime $submit
     *
     * @return Projecttask
     */
    public function setSubmit($submit)
    {
        $this->submit = $submit;

        return $this;
    }

    /**
     * Get submit
     *
     * @return \DateTime
     */
    public function getSubmit()
    {
        return $this->submit;
    }

    /**
     * Set user
     *
     * @param User $user
     *
     * @return Projecttask
     */
    public function setUser(User $user = null)
    {
        $this->user = $user;

        return $this;
    }

    /**
     * Get user
     *
     * @return User
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * Set project
     *
     * @param Project $project
     *
     * @return Projecttask
     */
    public function setProject(Project $project)
    {
        $this->project = $project;

        return $this;
    }

    /**
     * Get project
     *
     * @return Project
     */
    public function getProject()
    {
        return $this->project;
    }

    /**
     * Set owner
     *
     * @param User $owner
     *
     * @return Projecttask
     */
    public function setOwner(User $owner)
    {
        $this->owner = $owner;

        return $this;
    }

    /**
     * Get owner
     *
     * @return User
     */
    public function getOwner()
    {
        return $this->owner;
    }


    /**
     * Set projecttasktag
     *
     * @param Projecttasktag $projecttasktag
     *
     * @return Projecttask
     */
    public function setProjecttasktag(Projecttasktag $projecttasktag = null)
    {
        $this->projecttasktag = $projecttasktag;

        return $this;
    }

    /**
     * Get projecttasktag
     *
     * @return Projecttasktag
     */
    public function getProjecttasktag()
    {
        return $this->projecttasktag;
    }

    /**
     * Set projecttaskstatus
     *
     * @param Projecttaskstatus $projecttaskstatus
     *
     * @return Projecttask
     */
    public function setProjecttaskstatus(Projecttaskstatus $projecttaskstatus = null)
    {
        $this->projecttaskstatus = $projecttaskstatus;

        return $this;
    }

    /**
     * Get projecttaskstatus
     *
     * @return Projecttaskstatus
     */
    public function getProjecttaskstatus()
    {
        return $this->projecttaskstatus;
    }

    /**
     * Set priority
     *
     * @param integer $priority
     *
     * @return Projecttask
     */
    public function setPriority($priority)
    {
        $this->priority = $priority;

        return $this;
    }

    /**
     * Get priority
     *
     * @return integer
     */
    public function getPriority()
    {
        return $this->priority;
    }

    /**
     * Set end
     *
     * @param \DateTime $end
     *
     * @return Projecttask
     */
    public function setEnd($end)
    {
        $this->end = $end;

        return $this;
    }

    /**
     * Get end
     *
     * @return \DateTime
     */
    public function getEnd()
    {
        return $this->end;
    }

    /**
     * Set percentage
     *
     * @param integer $percentage
     *
     * @return Projecttask
     */
    public function setPercentage($percentage)
    {
        $this->percentage = $percentage;

        return $this;
    }

    /**
     * Get percentage
     *
     * @return integer
     */
    public function getPercentage()
    {
        return $this->percentage;
    }
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->projectcomments = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Add projectcomment
     *
     * @param Projectcomment $projectcomment
     *
     * @return Projecttask
     */
    public function addProjectcomment(Projectcomment $projectcomment)
    {
        $this->projectcomments[] = $projectcomment;

        return $this;
    }

    /**
     * Remove projectcomment
     *
     * @param Projectcomment $projectcomment
     */
    public function removeProjectcomment(Projectcomment $projectcomment)
    {
        $this->projectcomments->removeElement($projectcomment);
    }

    /**
     * Get projectcomments
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getProjectcomments()
    {
        return $this->projectcomments;
    }
}
