<?php

namespace Cadoles\CoreBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Form\FormError;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;


use Cadoles\CoreBundle\Entity\Mail;
use Cadoles\CoreBundle\Form\MailType;

class MailController extends Controller
{
    public function invitationgroupAction($id,Request $request)
    {
        // Recherche du groupe
        $em = $this->getDoctrine()->getManager();
        $group = $em->getRepository("CadolesCoreBundle:Group")->find($id);
        if (!$group) {
            throw $this->createNotFoundException('Unable to find '.$this->labeldata);
        }

        // On récupère la liste des email invités
        $invitations=$group->getInvitations();
        if(!is_array($invitations)) $invitations=[];

        // Création du formulaire
        $form = $this->createForm(MailType::class);

        // Récupération des data du formulaire
        $form->handleRequest($request);

        // Sujet
        $subject = $this->get('session')->get('appname')." : Invitation au groupe de travail ".$group->getLabel();

        // Sujet
        $url     = $this->generateUrl('cadoles_core_registration',[], UrlGeneratorInterface::ABSOLUTE_URL)."?group=".$group->getId();
        $message = "Bonjour,<br><br>En tant que responsable du groupe <b>'".$group->getLabel()."'</b>, je vous ai invité à rejoindre cette communauté de travail<br><br>";
        $message.= "Merci de bien vouloir tout d’abord vous inscrire sur <b>".$this->get('session')->get('appname')."</b> en suivant le lien suivant<br>";
        $message.= "<a href='$url'>$url</a><br><br>";
        $message.= "Une fois le processus d'inscription complété, vous serez automatiquement rattaché à notre groupe de travail<br><br>";
        $message.= "Cordialement<br>";
        $message.= $this->getUser()->getFirstname()." ".$this->getUser()->getLastname();

        // To close ?
        $closed = false;

        // Sur validation
        if ($form->get('submit')->isClicked() && $form->isValid()) {  
            $closed = true;    
            

            $destinataires=$form->get("destinataire")->getData();
            $to=explode(";",$destinataires);
            
            // On s'assure que les destinataires ne sont pas déjà inscrit dans le portail
            $usersnotin=[];
            $usersin=[];
            foreach($to as $key => $mail) {
                // Si le mail existe on l'enlève de la liste des utilisateurs à inviter
                $user=$em->getRepository("CadolesCoreBundle:User")->findOneBy(["email"=>$mail]);
                if($user) {
                    unset($to[$key]);
                    $usergroup=$em->getRepository("CadolesCoreBundle:UserGroup")->findOneBy(["user"=>$user,"group"=>$group]);
                    if($usergroup) array_push($usersin,$user);
                    else array_push($usersnotin,$user);
                }
                else {
                    // On enregistre l'invitation si elle n'existe pas déjà
                    if(!in_array($mail,$invitations)) {
                        array_push($invitations,$mail);
                    }                    
                }
            }


            $text=$form->get("message")->getData();
            $subject=$form->get("subject")->getData();
            $template="template";
            $mail_params=array(
                "subject" => $subject,
                "body_html"=>nl2br($text),
                "body_text"=>$text
            );
            $from =  $this->getParameter('noreply');
            $fromName = $this->getUser()->getFirstname()." ".$this->getUser()->getLastname();
            $message = $this->container->get('cadoles.core.service.mail');
            $message->sendEmail($template, $mail_params, $to, $from, $fromName);

            // Sauvegarde des invitation
            $group->setInvitations($invitations);
            $em->persist($group);
            $em->flush();             
        }
        else {
            $email=$request->get("email");
            if($email) {
                $form->get('destinataire')->setData($email);
            }
        }

        if($closed && (!empty($usersin)||!empty($usersnotin))) {
            return $this->render('CadolesCoreBundle:Mail:users.html.twig',[
                'useheader'     => false,
                'usemenu'       => false,
                'usesidebar'    => false,
                'usersin'       => $usersin,
                'usersnotin'    => $usersnotin,
                'group'         => $group
            ]);           
        }
        else {
            return $this->render('CadolesCoreBundle:Mail:mail.html.twig',[
                'useheader'     => false,
                'usemenu'       => false,
                'usesidebar'    => false,
                'closed'        => $closed,
                'subject'       => $subject,
                'message'       => $message,
                'form'          => $form->createView()
            ]);
        }
    }

}
