<?php
namespace Cadoles\CoreBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;

use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @ORM\Entity
 * @ORM\Table(name="niveau01")
 * @ORM\HasLifecycleCallbacks()
 * @ORM\Entity(repositoryClass="Cadoles\CoreBundle\Repository\Niveau01Repository")
 * 
 * @UniqueEntity(fields="label", message="Un Niveau de rang 1 existe déjà avec ce label")
 */
class Niveau01
{
    /**
     * @ORM\Column(type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=250, unique=true)
     */
    private $label;

    /**
     * @ORM\Column(type="string", length=9, nullable=true)
     */
    private $siren;

    /**
     * @ORM\Column(type="boolean")
     */
    private $showsubappname;

    /**
     * @ORM\Column(type="text", nullable=true)
     */
    private $logo;

    /**
     * @ORM\Column(type="text", nullable=true)
     */
    private $header;

    /**
     * @ORM\Column(type="text", nullable=true)
     */
    private $colormain;

    /**
     * @ORM\Column(type="text", nullable=true)
     */
    private $fontcolorhover;

    /**
     * @ORM\Column(type="text", nullable=true)
     */
    private $colorbody;
    
    /**
     * @ORM\Column(type="text", nullable=true)
     */
    private $fontfacetitle;
    
    /**
     * @ORM\Column(type="text", nullable=true)
     */
    private $fontfacebody;
    
    /**
     * @ORM\Column(type="text", nullable=true)
     */
    private $ldapfilter;

    /**
     * @ORM\Column(type="text", nullable=true)
     */
    private $attributes;

    /**
     * @var ArrayCollection $niveau02s
     * @var Registration
     *
     * @ORM\OneToMany(targetEntity="Niveau02", mappedBy="niveau01", cascade={"persist"}, orphanRemoval=false)
     */
    private $niveau02s;

    /**
     * @var ArrayCollection $registrations
     * @var Registration
     *
     * @ORM\OneToMany(targetEntity="Registration", mappedBy="niveau01", cascade={"persist"}, orphanRemoval=false)
     */
    private $registrations;

        /**
     * @var ArrayCollection $users
     * @var User
     *
     * @ORM\OneToMany(targetEntity="User", mappedBy="niveau01", cascade={"persist"}, orphanRemoval=false)
     */
    private $users;

        /**
     * @var ArrayCollection $modos
     * @var User
     *
     * @ORM\OneToMany(targetEntity="UserModo", mappedBy="niveau01", cascade={"persist"}, orphanRemoval=false)
     */
    private $modos;

    /**
    * @ORM\ManyToMany(targetEntity="Cadoles\PortalBundle\Entity\Item", mappedBy="niveau01s")
    */    
    protected $items;

    /**
    * @ORM\ManyToMany(targetEntity="Cadoles\PortalBundle\Entity\Alert", mappedBy="niveau01s")
    */    
    protected $alerts;    

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->niveau02s = new \Doctrine\Common\Collections\ArrayCollection();
        $this->registrations = new \Doctrine\Common\Collections\ArrayCollection();
        $this->users = new \Doctrine\Common\Collections\ArrayCollection();
        $this->modos = new \Doctrine\Common\Collections\ArrayCollection();
        $this->items = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set label
     *
     * @param string $label
     *
     * @return Niveau01
     */
    public function setLabel($label)
    {
        $this->label = $label;

        return $this;
    }

    /**
     * Get label
     *
     * @return string
     */
    public function getLabel()
    {
        return $this->label;
    }

    /**
     * Set siren
     *
     * @param string $siren
     *
     * @return Niveau01
     */
    public function setSiren($siren)
    {
        $this->siren = $siren;

        return $this;
    }

    /**
     * Get siren
     *
     * @return string
     */
    public function getSiren()
    {
        return $this->siren;
    }

    /**
     * Set showsubappname
     *
     * @param boolean $showsubappname
     *
     * @return Niveau01
     */
    public function setShowsubappname($showsubappname)
    {
        $this->showsubappname = $showsubappname;

        return $this;
    }

    /**
     * Get showsubappname
     *
     * @return boolean
     */
    public function getShowsubappname()
    {
        return $this->showsubappname;
    }

    /**
     * Set logo
     *
     * @param string $logo
     *
     * @return Niveau01
     */
    public function setLogo($logo)
    {
        $this->logo = $logo;

        return $this;
    }

    /**
     * Get logo
     *
     * @return string
     */
    public function getLogo()
    {
        return $this->logo;
    }

    /**
     * Set ldapfilter
     *
     * @param string $ldapfilter
     *
     * @return Niveau01
     */
    public function setLdapfilter($ldapfilter)
    {
        $this->ldapfilter = $ldapfilter;

        return $this;
    }

    /**
     * Get ldapfilter
     *
     * @return string
     */
    public function getLdapfilter()
    {
        return $this->ldapfilter;
    }

    /**
     * Set attributes
     *
     * @param string $attributes
     *
     * @return Niveau01
     */
    public function setAttributes($attributes)
    {
        $this->attributes = $attributes;

        return $this;
    }

    /**
     * Get attributes
     *
     * @return string
     */
    public function getAttributes()
    {
        return $this->attributes;
    }

    /**
     * Add niveau02
     *
     * @param \Cadoles\CoreBundle\Entity\Niveau02 $niveau02
     *
     * @return Niveau01
     */
    public function addNiveau02(\Cadoles\CoreBundle\Entity\Niveau02 $niveau02)
    {
        $this->niveau02s[] = $niveau02;

        return $this;
    }

    /**
     * Remove niveau02
     *
     * @param \Cadoles\CoreBundle\Entity\Niveau02 $niveau02
     */
    public function removeNiveau02(\Cadoles\CoreBundle\Entity\Niveau02 $niveau02)
    {
        $this->niveau02s->removeElement($niveau02);
    }

    /**
     * Get niveau02s
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getNiveau02s()
    {
        return $this->niveau02s;
    }

    /**
     * Add registration
     *
     * @param \Cadoles\CoreBundle\Entity\Registration $registration
     *
     * @return Niveau01
     */
    public function addRegistration(\Cadoles\CoreBundle\Entity\Registration $registration)
    {
        $this->registrations[] = $registration;

        return $this;
    }

    /**
     * Remove registration
     *
     * @param \Cadoles\CoreBundle\Entity\Registration $registration
     */
    public function removeRegistration(\Cadoles\CoreBundle\Entity\Registration $registration)
    {
        $this->registrations->removeElement($registration);
    }

    /**
     * Get registrations
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getRegistrations()
    {
        return $this->registrations;
    }

    /**
     * Add user
     *
     * @param \Cadoles\CoreBundle\Entity\User $user
     *
     * @return Niveau01
     */
    public function addUser(\Cadoles\CoreBundle\Entity\User $user)
    {
        $this->users[] = $user;

        return $this;
    }

    /**
     * Remove user
     *
     * @param \Cadoles\CoreBundle\Entity\User $user
     */
    public function removeUser(\Cadoles\CoreBundle\Entity\User $user)
    {
        $this->users->removeElement($user);
    }

    /**
     * Get users
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getUsers()
    {
        return $this->users;
    }

    /**
     * Add modo
     *
     * @param \Cadoles\CoreBundle\Entity\UserModo $modo
     *
     * @return Niveau01
     */
    public function addModo(\Cadoles\CoreBundle\Entity\UserModo $modo)
    {
        $this->modos[] = $modo;

        return $this;
    }

    /**
     * Remove modo
     *
     * @param \Cadoles\CoreBundle\Entity\UserModo $modo
     */
    public function removeModo(\Cadoles\CoreBundle\Entity\UserModo $modo)
    {
        $this->modos->removeElement($modo);
    }

    /**
     * Get modos
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getModos()
    {
        return $this->modos;
    }

    /**
     * Add item
     *
     * @param \Cadoles\PortalBundle\Entity\Item $item
     *
     * @return Niveau01
     */
    public function addItem(\Cadoles\PortalBundle\Entity\Item $item)
    {
        $this->items[] = $item;

        return $this;
    }

    /**
     * Remove item
     *
     * @param \Cadoles\PortalBundle\Entity\Item $item
     */
    public function removeItem(\Cadoles\PortalBundle\Entity\Item $item)
    {
        $this->items->removeElement($item);
    }

    /**
     * Get items
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getItems()
    {
        return $this->items;
    }

    /**
     * Add alert
     *
     * @param \Cadoles\PortalBundle\Entity\Alert $alert
     *
     * @return Niveau01
     */
    public function addAlert(\Cadoles\PortalBundle\Entity\Alert $alert)
    {
        $this->alerts[] = $alert;

        return $this;
    }

    /**
     * Remove alert
     *
     * @param \Cadoles\PortalBundle\Entity\Alert $alert
     */
    public function removeAlert(\Cadoles\PortalBundle\Entity\Alert $alert)
    {
        $this->alerts->removeElement($alert);
    }

    /**
     * Get alerts
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getAlerts()
    {
        return $this->alerts;
    }

    /**
     * Set header
     *
     * @param string $header
     *
     * @return Niveau01
     */
    public function setHeader($header)
    {
        $this->header = $header;

        return $this;
    }

    /**
     * Get header
     *
     * @return string
     */
    public function getHeader()
    {
        return $this->header;
    }

    /**
     * Set colormain
     *
     * @param string $colormain
     *
     * @return Niveau01
     */
    public function setColormain($colormain)
    {
        $this->colormain = $colormain;

        return $this;
    }

    /**
     * Get colormain
     *
     * @return string
     */
    public function getColormain()
    {
        return $this->colormain;
    }

    /**
     * Set fontcolorhover
     *
     * @param string $fontcolorhover
     *
     * @return Niveau01
     */
    public function setFontcolorhover($fontcolorhover)
    {
        $this->fontcolorhover = $fontcolorhover;

        return $this;
    }

    /**
     * Get fontcolorhover
     *
     * @return string
     */
    public function getFontcolorhover()
    {
        return $this->fontcolorhover;
    }

    /**
     * Set colorbody
     *
     * @param string $colorbody
     *
     * @return Niveau01
     */
    public function setColorbody($colorbody)
    {
        $this->colorbody = $colorbody;

        return $this;
    }

    /**
     * Get colorbody
     *
     * @return string
     */
    public function getColorbody()
    {
        return $this->colorbody;
    }

    /**
     * Set fontfacetitle
     *
     * @param string $fontfacetitle
     *
     * @return Niveau01
     */
    public function setFontfacetitle($fontfacetitle)
    {
        $this->fontfacetitle = $fontfacetitle;

        return $this;
    }

    /**
     * Get fontfacetitle
     *
     * @return string
     */
    public function getFontfacetitle()
    {
        return $this->fontfacetitle;
    }

    /**
     * Set fontfacebody
     *
     * @param string $fontfacebody
     *
     * @return Niveau01
     */
    public function setFontfacebody($fontfacebody)
    {
        $this->fontfacebody = $fontfacebody;

        return $this;
    }

    /**
     * Get fontfacebody
     *
     * @return string
     */
    public function getFontfacebody()
    {
        return $this->fontfacebody;
    }
}
