<?php
namespace Cadoles\CoreBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;

use Symfony\Component\Security\Core\User\UserInterface;
use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;
use Cadoles\CoreBundle\Validator as CadolesCoreAssert;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @ORM\Entity
 * @ORM\Table(name="registration")
 * @ORM\HasLifecycleCallbacks()
 *
 * @UniqueEntity(fields="username", message="Un utilisateur existe déjà avec ce login.")
 * @UniqueEntity(fields="email", message="Un utilisateur existe déjà avec ce mail.")
 */
class Registration implements UserInterface, \Serializable
{
    /**
     * @ORM\Column(type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=128, unique=true)
     * @Assert\Length(
     *      min = "5",
     *      max = "128",
     *      minMessage = "Votre nom doit faire au moins {{ limit }} caractères",
     *      maxMessage = "Votre nom ne peut pas être plus long que {{ limit }} caractères"
     * )
     */
    private $username;

    /**
     * @ORM\Column(type="string", length=250, nullable=true)
     */
    private $firstname;

    /**
     * @ORM\Column(type="string", length=250, nullable=true)
     */
    private $lastname;

    /**
     * @ORM\Column(type="string", length=250)
     */
    private $password;
    
    /**
     * @CadolesCoreAssert\Password()
     */
    private $passwordplain;

    /**
     * @ORM\Column(type="string", length=250)
     */
    private $salt;

    /**
     * @ORM\Column(type="string", length=250, nullable=true)
     */
    private $passwordad;

    /**
     * @ORM\Column(type="string", length=128, unique=true)
     */
    private $email;

    /**
     * @ORM\Column(name="visible", type="boolean")
     */
    protected $visible;

    /**
     * @ORM\Column(type="datetime", nullable=true)
     */
    private $keyexpire;    

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     */
    private $keyvalue;    

    /**
     * @ORM\ManyToOne(targetEntity="Statut", inversedBy="registrations")
     * @ORM\JoinColumn(nullable=false)
     */
    private $statut;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     */
    private $usualname;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     */
    private $telephonenumber;

    /**
     * @ORM\Column(type="string", length=250, nullable=true)
     */
    private $postaladress;

    /**
     * @ORM\Column(type="string", length=250, nullable=true)
     */
    private $givensname;

    /**
     * @ORM\Column(type="date", nullable=true)
     */
    private $birthdate;

    /**
     * @ORM\Column(type="string", length=20, nullable=true)
     */
    private $gender;

    /**
     * @ORM\Column(type="string", length=250, nullable=true)
     */
    private $job;
    
    /**
     * @ORM\Column(type="string", length=250, nullable=true)
     */
    private $position;    

    /**
     * @ORM\Column(type="string", length=150, nullable=true)
     */
    private $niveau01other;
       
    /**
     * @ORM\Column(name="motivation", type="text", nullable=true)
     */
    private $motivation;

    /**
     * @ORM\Column(name="note", type="text", nullable=true)
     */
    private $note;

    /**
     * @ORM\Column(type="integer", length=60, nullable=true)
     */
    private $groupid;  

    /**
     * @ORM\ManyToOne(targetEntity="Country", inversedBy="registrations")
     * @ORM\JoinColumn(nullable=true)
     * @ORM\OrderBy({"label" = "ASC"})
     */
    private $birthcountry;

    /**
     * @ORM\ManyToOne(targetEntity="City", inversedBy="registrations")
     * @ORM\JoinColumn(nullable=true)
     */
    private $birthplace;    

    /**
     * @ORM\ManyToOne(targetEntity="Niveau01", inversedBy="registrations")
     * @ORM\JoinColumn(nullable=false)
     */
    private $niveau01;

    /**
     * @ORM\ManyToOne(targetEntity="Niveau02", inversedBy="registrations")
     * @ORM\JoinColumn(nullable=true)
     */
    private $niveau02;    



//== CODE A NE PAS REGENERER
     
    public function getUserName()
    {
        return $this->username;
    }

    public function getSalt()
    {
        return $this->salt;
    }

    public function setPassword($password)
    {
        if($password!=$this->password&&$password!=""){      
            // Placer le password non encodé dans une variable tempo sur laquel on va appliquer la contraite
            $this->passwordplain = $password;

            // Password encrypté format openldap           
            mt_srand((double)microtime()*1000000);
            $this->salt = pack("CCCC", mt_rand(), mt_rand(), mt_rand(), mt_rand());
            $hash = "{SSHA}" . base64_encode(pack("H*", sha1($password . $this->salt)) . $this->salt);
            $this->password = $hash;

            // Password encrypté AD
            $newPassword = "\"" . $password . "\"";
            $len = strlen($newPassword);
            $newPassw = "";
            for($i=0;$i<$len;$i++) {
                $newPassw .= "{$newPassword{$i}}\000";
            }   
            $this->passwordad = $newPassw;
        }
        
        return $this;
    }

    public function getPassword()
    {
        return $this->password;
    }  

    public function getRoles()
    {
    }

    public function eraseCredentials()
    {
    }
    
    /** @see \Serializable::serialize() */
    public function serialize()
    {
        return serialize(array(
            $this->id,
            $this->username,
            $this->password,
            $this->salt,
        ));
    }

    /** @see \Serializable::unserialize() */
    public function unserialize($serialized)
    {
        list (
            $this->id,
            $this->login,
            $this->password,
            $this->salt
        ) = unserialize($serialized);
    }


//== FIN DU CODE A NE PAS REGENERER  


    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set username
     *
     * @param string $username
     *
     * @return Registration
     */
    public function setUsername($username)
    {
        $this->username = $username;

        return $this;
    }

    /**
     * Set firstname
     *
     * @param string $firstname
     *
     * @return Registration
     */
    public function setFirstname($firstname)
    {
        $this->firstname = $firstname;

        return $this;
    }

    /**
     * Get firstname
     *
     * @return string
     */
    public function getFirstname()
    {
        return $this->firstname;
    }

    /**
     * Set lastname
     *
     * @param string $lastname
     *
     * @return Registration
     */
    public function setLastname($lastname)
    {
        $this->lastname = $lastname;

        return $this;
    }

    /**
     * Get lastname
     *
     * @return string
     */
    public function getLastname()
    {
        return $this->lastname;
    }

    /**
     * Set salt
     *
     * @param string $salt
     *
     * @return Registration
     */
    public function setSalt($salt)
    {
        $this->salt = $salt;

        return $this;
    }

    /**
     * Set email
     *
     * @param string $email
     *
     * @return Registration
     */
    public function setEmail($email)
    {
        $this->email = $email;

        return $this;
    }

    /**
     * Get email
     *
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * Set visible
     *
     * @param boolean $visible
     *
     * @return Registration
     */
    public function setVisible($visible)
    {
        $this->visible = $visible;

        return $this;
    }

    /**
     * Get visible
     *
     * @return boolean
     */
    public function getVisible()
    {
        return $this->visible;
    }

    /**
     * Set keyexpire
     *
     * @param \DateTime $keyexpire
     *
     * @return Registration
     */
    public function setKeyexpire($keyexpire)
    {
        $this->keyexpire = $keyexpire;

        return $this;
    }

    /**
     * Get keyexpire
     *
     * @return \DateTime
     */
    public function getKeyexpire()
    {
        return $this->keyexpire;
    }

    /**
     * Set keyvalue
     *
     * @param string $keyvalue
     *
     * @return Registration
     */
    public function setKeyvalue($keyvalue)
    {
        $this->keyvalue = $keyvalue;

        return $this;
    }

    /**
     * Get keyvalue
     *
     * @return string
     */
    public function getKeyvalue()
    {
        return $this->keyvalue;
    }

    /**
     * Set usualname
     *
     * @param string $usualname
     *
     * @return Registration
     */
    public function setUsualname($usualname)
    {
        $this->usualname = $usualname;

        return $this;
    }

    /**
     * Get usualname
     *
     * @return string
     */
    public function getUsualname()
    {
        return $this->usualname;
    }

    /**
     * Set telephonenumber
     *
     * @param string $telephonenumber
     *
     * @return Registration
     */
    public function setTelephonenumber($telephonenumber)
    {
        $this->telephonenumber = $telephonenumber;

        return $this;
    }

    /**
     * Get telephonenumber
     *
     * @return string
     */
    public function getTelephonenumber()
    {
        return $this->telephonenumber;
    }

    /**
     * Set postaladress
     *
     * @param string $postaladress
     *
     * @return Registration
     */
    public function setPostaladress($postaladress)
    {
        $this->postaladress = $postaladress;

        return $this;
    }

    /**
     * Get postaladress
     *
     * @return string
     */
    public function getPostaladress()
    {
        return $this->postaladress;
    }

    /**
     * Set givensname
     *
     * @param string $givensname
     *
     * @return Registration
     */
    public function setGivensname($givensname)
    {
        $this->givensname = $givensname;

        return $this;
    }

    /**
     * Get givensname
     *
     * @return string
     */
    public function getGivensname()
    {
        return $this->givensname;
    }

    /**
     * Set birthdate
     *
     * @param \DateTime $birthdate
     *
     * @return Registration
     */
    public function setBirthdate($birthdate)
    {
        $this->birthdate = $birthdate;

        return $this;
    }

    /**
     * Get birthdate
     *
     * @return \DateTime
     */
    public function getBirthdate()
    {
        return $this->birthdate;
    }

    /**
     * Set gender
     *
     * @param string $gender
     *
     * @return Registration
     */
    public function setGender($gender)
    {
        $this->gender = $gender;

        return $this;
    }

    /**
     * Get gender
     *
     * @return string
     */
    public function getGender()
    {
        return $this->gender;
    }

    /**
     * Set job
     *
     * @param string $job
     *
     * @return Registration
     */
    public function setJob($job)
    {
        $this->job = $job;

        return $this;
    }

    /**
     * Get job
     *
     * @return string
     */
    public function getJob()
    {
        return $this->job;
    }

    /**
     * Set position
     *
     * @param string $position
     *
     * @return Registration
     */
    public function setPosition($position)
    {
        $this->position = $position;

        return $this;
    }

    /**
     * Get position
     *
     * @return string
     */
    public function getPosition()
    {
        return $this->position;
    }

    /**
     * Set statut
     *
     * @param \Cadoles\CoreBundle\Entity\Statut $statut
     *
     * @return Registration
     */
    public function setStatut(\Cadoles\CoreBundle\Entity\Statut $statut)
    {
        $this->statut = $statut;

        return $this;
    }

    /**
     * Get statut
     *
     * @return \Cadoles\CoreBundle\Entity\Statut
     */
    public function getStatut()
    {
        return $this->statut;
    }

    /**
     * Set birthcountry
     *
     * @param \Cadoles\CoreBundle\Entity\Country $birthcountry
     *
     * @return Registration
     */
    public function setBirthcountry(\Cadoles\CoreBundle\Entity\Country $birthcountry = null)
    {
        $this->birthcountry = $birthcountry;

        return $this;
    }

    /**
     * Get birthcountry
     *
     * @return \Cadoles\CoreBundle\Entity\Country
     */
    public function getBirthcountry()
    {
        return $this->birthcountry;
    }

    /**
     * Set birthplace
     *
     * @param \Cadoles\CoreBundle\Entity\City $birthplace
     *
     * @return Registration
     */
    public function setBirthplace(\Cadoles\CoreBundle\Entity\City $birthplace = null)
    {
        $this->birthplace = $birthplace;

        return $this;
    }

    /**
     * Get birthplace
     *
     * @return \Cadoles\CoreBundle\Entity\City
     */
    public function getBirthplace()
    {
        return $this->birthplace;
    }

    /**
     * Set niveau01
     *
     * @param \Cadoles\CoreBundle\Entity\Niveau01 $niveau01
     *
     * @return Registration
     */
    public function setNiveau01(\Cadoles\CoreBundle\Entity\Niveau01 $niveau01)
    {
        $this->niveau01 = $niveau01;

        return $this;
    }

    /**
     * Get niveau01
     *
     * @return \Cadoles\CoreBundle\Entity\Niveau01
     */
    public function getNiveau01()
    {
        return $this->niveau01;
    }

    /**
     * Set niveau02
     *
     * @param \Cadoles\CoreBundle\Entity\Niveau02 $niveau02
     *
     * @return Registration
     */
    public function setNiveau02(\Cadoles\CoreBundle\Entity\Niveau02 $niveau02 = null)
    {
        $this->niveau02 = $niveau02;

        return $this;
    }

    /**
     * Get niveau02
     *
     * @return \Cadoles\CoreBundle\Entity\Niveau02
     */
    public function getNiveau02()
    {
        return $this->niveau02;
    }

    /**
     * Set groupid
     *
     * @param integer $groupid
     *
     * @return Registration
     */
    public function setGroupid($groupid)
    {
        $this->groupid = $groupid;

        return $this;
    }

    /**
     * Get groupid
     *
     * @return integer
     */
    public function getGroupid()
    {
        return $this->groupid;
    }

    /**
     * Set niveau01other
     *
     * @param string $niveau01other
     *
     * @return Registration
     */
    public function setNiveau01other($niveau01other)
    {
        $this->niveau01other = $niveau01other;

        return $this;
    }

    /**
     * Get niveau01other
     *
     * @return string
     */
    public function getNiveau01other()
    {
        return $this->niveau01other;
    }

    /**
     * Set motivation
     *
     * @param string $motivation
     *
     * @return Registration
     */
    public function setMotivation($motivation)
    {
        $this->motivation = $motivation;

        return $this;
    }

    /**
     * Get motivation
     *
     * @return string
     */
    public function getMotivation()
    {
        return $this->motivation;
    }

    /**
     * Set passwordad.
     *
     * @param string|null $passwordad
     *
     * @return Registration
     */
    public function setPasswordad($passwordad = null)
    {
        $this->passwordad = $passwordad;

        return $this;
    }

    /**
     * Get passwordad.
     *
     * @return string|null
     */
    public function getPasswordad()
    {
        return $this->passwordad;
    }

    /**
     * Set note
     *
     * @param string $note
     *
     * @return Registration
     */
    public function setNote($note)
    {
        $this->note = $note;

        return $this;
    }

    /**
     * Get note
     *
     * @return string
     */
    public function getNote()
    {
        return $this->note;
    }
}
