<?php

namespace Cadoles\PortalBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Form\FormError;

use Cadoles\PortalBundle\Entity\Item;
use Cadoles\PortalBundle\Form\ItemType;

class ItemController extends Controller
{
    private $labelroute  = 'cadoles_portal_config_item';
    private $labelentity = 'CadolesPortalBundle:Item';
    private $labeldata   = 'item';
    private $labeldatas  = 'items';

    public function listAction()
    {
        $itemcategorys = $this->getDoctrine()->getRepository('CadolesPortalBundle:Itemcategory')->findBy([], ['rowOrder' => 'asc']);
        $groups = $this->getDoctrine()->getRepository('CadolesCoreBundle:Group')->findBy([], ['label' => 'asc']);

        return $this->render($this->labelentity.':list.html.twig', [
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => true,              
            'itemcategorys'     => $itemcategorys,
            'groups'            => $groups
        ]);
    }

    public function ajaxseleclistAction(Request $request)
    {
        // S'assurer que c'est un appel ajax
        if (!$request->isXmlHttpRequest()) {
            return new JsonResponse(array('message' => 'Interdit'), 400);
        }

        $output=array();
        $em = $this->getDoctrine()->getManager();
        $page_limit=$request->query->get('page_limit');
        $q=$request->query->get('q');
        
        $qb = $em->createQueryBuilder();
        $qb->select('table')->from("CadolesPortalBundle:Item",'table')
           ->where('table.title LIKE :value')
           ->setParameter("value", "%".$q."%")
           ->orderBy('table.title');
        
        $datas=$qb->setFirstResult(0)->setMaxResults($page_limit)->getQuery()->getResult();
        foreach($datas as $data) {
            array_push($output,array("id"=>$data->getId(),"text"=>$data->getTitle()));
        }

        $response = new Response(json_encode($output));    
        $response->headers->set('Content-Type', 'application/json');      
        return $response;
    } 

    public function submitAction(Request $request)
    {
        // Initialisation de l'enregistrement
        $data = new Item();
        if($this->GetParameter("activate_widsonde")) {
            $data->setClicksonde(true);
            $data->setClicksondeservice("PAGE_ENT");
        }

        // Création du formulaire
        $form = $this->createForm(ItemType::class,$data,array(
            "mode"                  => "submit",
            "labelniveau01"         => $this->GetParameter("labelsniveau01"),
            "ssosynchroitem"        => $this->GetParameter("ssosynchroitem"),
            "user_attr_cas_item"    => $this->GetParameter("user_attr_cas_item"),
            "activate_widsonde"     => $this->GetParameter("activate_widsonde"),
        ));

        // Récupération des data du formulaire
        $form->handleRequest($request);
        
        // Sur erreur
        $this->getErrorForm(null,$form,$request,$data,"submit");
        
        // Sur validation
        if ($form->get('submit')->isClicked() && $form->isValid()) {  
            $data = $form->getData();  
            $em = $this->getDoctrine()->getManager();

            $idicon = $form->get('idicon')->getData();
            $icon=$this->getDoctrine()->getRepository("CadolesPortalBundle:Icon")->findoneby(["id"=>$idicon]);
            $data->setIcon($icon);

            // Sauvegarde
            $em->persist($data);
            $em->flush();

            // Retour à la liste
            return $this->redirectToRoute($this->labelroute);
        }
        
        // Affichage du formulaire
        return $this->render($this->labelentity.':edit.html.twig', [
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => true,              
            $this->labeldata    => $data,
            'mode'              => 'submit',
            'icons'             => $this->getDoctrine()->getRepository("CadolesPortalBundle:Icon")->findAll(),
            'form'              => $form->createView()
        ]);
    }  

    public function updateAction($id,Request $request)
    {
        // Récupération de l'enregistrement courant 
        $data=$this->getData($id);
        
        // Vérifier que cet enregistrement est modifiable
                                    
        // Création du formulaire
        $form = $this->createForm(ItemType::class,$data,array(
            "mode"                  => "update",
            "idicon"                => ($data->getIcon()?$data->getIcon()->getId():null),
            "labelniveau01"         => $this->GetParameter("labelsniveau01"),
            "ssosynchroitem"        => $this->GetParameter("ssosynchroitem"),
            "user_attr_cas_item"    => $this->GetParameter("user_attr_cas_item"),
            "activate_widsonde"     => ($this->GetParameter("activate_widsonde")&&$data->getId()>0),
        ));

        // Récupération des data du formulaire
        $form->handleRequest($request);
    
        // Sur erreur
        $this->getErrorForm($id,$form,$request,$data,"update");
        
        // Sur validation
        if ($form->get('submit')->isClicked() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $data = $form->getData();

            $idicon = $form->get('idicon')->getData();
            $icon=$this->getDoctrine()->getRepository("CadolesPortalBundle:Icon")->findoneby(["id"=>$idicon]);
            $data->setIcon($icon);
            
            // Sauvegarde
            $em->persist($data);
            $em->flush();

            // Retour à la liste
            return $this->redirectToRoute($this->labelroute);
        }
        
       
        // Affichage du formulaire
        return $this->render($this->labelentity.':edit.html.twig', [
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => true,              
            $this->labeldata    => $data,
            'mode'              => 'update',
            'icons'             => $this->getDoctrine()->getRepository("CadolesPortalBundle:Icon")->findAll(),
            'form'              => $form->createView()
        ]);
    }

    public function deleteAction($id,Request $request)
    {
        // Récupération de l'enregistrement courant 
        $data=$this->getData($id);

        // Vérifier que cet enregistrement est supprimable

        // Supprimer la donnée
        $em = $this->getDoctrine()->getManager();
        $em->remove($data);
        $em->flush();
        
        return $this->redirectToRoute($this->labelroute);
    }

    public function orderAction(Request $request)
    {
        // S'assurer que c'est un appel ajax
        if (!$request->isXmlHttpRequest()) {
            return new JsonResponse(array('message' => 'Interdit'), 400);
        }

        $output=array();
        $id=$request->request->get('id');
        $categoryid=$request->request->get('categoryid');
        $order=$request->request->get('order');
        
        $em = $this->getDoctrine()->getManager();
        $entity = $em->getRepository($this->labelentity)->find($id);
        if (!$entity) {
            throw $this->createNotFoundException('Unable to find entity.');
        }

        $entity->setRoworder($order);
        $entity->setItemcategory($em->getRepository("CadolesPortalBundle:Itemcategory")->find($categoryid));
        $em->persist($entity);
        $em->flush();

        $response = new Response(json_encode($output));    
        $response->headers->set('Content-Type', 'application/json');        
        return $response;        
    }


    public function forceorderAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager();
        $categorys=$em->getRepository("CadolesPortalBundle:Itemcategory")->findAll();
        
        foreach($categorys as $category) {
            $i=0;
            $items=$em->getRepository("CadolesPortalBundle:Item")->findBy(["itemcategory"=>$category],["title"=>"ASC"]);
            foreach($items as $item) {
                $i++;
                $item->setRowOrder($i);
                $em->flush();
            }
        }

        // Retour à la liste
        return $this->redirectToRoute($this->labelroute);
    }

    protected function getDatas()
    {
        $em = $this->getDoctrine()->getManager();
        $datas = $em->getRepository($this->labelentity)->findAll();
        return $datas;
    } 
            
    protected function getData($id)
    {
        $em = $this->getDoctrine()->getManager();
        $data = $em->getRepository($this->labelentity)->find($id);

        if (!$data) {
            throw $this->createNotFoundException('Unable to find '.$this->labeldata);
        }

        return $data;
    } 

    protected function getErrorForm($id,$form,$request,$data,$mode) {
        if ($form->get('submit')->isClicked()&&$mode=="delete") {
        }

        if ($form->get('submit')->isClicked() && $mode=="submit") {
        }

        if ($form->get('submit')->isClicked() && ($mode=="submit" || $mode=="update")) {
            // si clicksonde alors clicksondeservice obligatoire
            if ($data->getClicksonde() && !$data->getClicksondeservice()) {
                $form->addError(new FormError('Type de service sur le click sonde est obligatoire'));
            }
        }

        if ($form->get('submit')->isClicked() && !$form->isValid()) {
            $this->get('session')->getFlashBag()->clear();
            $validator = $this->get('validator');
            $errors = $validator->validate($data);
            foreach( $errors as $error ) {
                $request->getSession()->getFlashBag()->add("error", $error->getMessage());
            }

            $errors = $form->getErrors();
            foreach( $errors as $error ) {
                $request->getSession()->getFlashBag()->add("error", $error->getMessage());
            }
        }
    }    
}
