<?php
namespace Cadoles\WebsocketBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\RepeatedType;
use Symfony\Component\Form\Extension\Core\Type\PasswordType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\ButtonType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\ColorType;
use Cadoles\CoreBundle\Form\IconChoiceType;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Ivory\CKEditorBundle\Form\Type\CKEditorType;

use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\EntityManager;

class ChatType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
        ->add("message",CKEditorType::class,[
            'config_name' => 'small_config',    
            'label' => "Message",
            'mapped'=> false,
            'required' => false,
            'attr' => array("class" => "form-control", "style" => "margin-bottom:15px"),
            'config' => ["height" => "100px"],
        ]);
        
        $builder
        ->add("messagemail",CKEditorType::class,[
            'config_name' => 'small_config',
            'label' => "Message",
            'mapped'=> false,
            'required' => false,
            'attr' => array("class" => "form-control", "style" => "margin-bottom:15px"),
            'config' => ["height" => "150px"]
        ]);
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([]);
    }
}
