<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Form\FormError;
use Ramsey\Uuid\Uuid;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;
use Symfony\Component\HttpFoundation\BinaryFileResponse;
use Symfony\Component\Filesystem\Filesystem;
use Symfony\Component\HttpFoundation\ResponseHeaderBag;
use Doctrine\Persistence\ManagerRegistry;
use Symfony\Component\HttpKernel\KernelInterface;
use App\Service\MessageService;
use App\Service\MailService;

use App\Entity\Group;
use App\Entity\Usergroup;
use App\Entity\Calendar;
use App\Entity\Blog;
use App\Entity\Project;

use App\Form\GroupType;

class GroupController extends AbstractController
{
    private $nameentity  = 'Group'; 
    private $labelroute  = 'app_core_config_group';
    private $labelentity = 'App\Entity\Group';
    private $labeldata   = 'group';
    private $labeldatas  = 'groups';
    private $idpage;

    private $appKernel;
    private $wss;
    private $mail;
    
    public function __construct(KernelInterface $appKernel,messageService $wss,mailService $mail)
    {
        $this->appKernel = $appKernel;
        $this->wss = $wss;
        $this->mail = $mail;
    }

    public function list($access,ManagerRegistry $em)
    {
        $grouporgas=null;
        if($access=="user") {
            $grouporgas=$em->getRepository("App\Entity\Group")->findBy(["fgcanshare"=>false,"fgall"=>false]);
        }

        return $this->render($this->nameentity.'\list.html.twig',[
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => ($access=="config"),
            'access'            => $access,
            'grouporgas'        => $grouporgas,
        ]);
    }

    public function ajaxlist($access,Request $request, ManagerRegistry $em)
    {
        // S'assurer que c'est un appel ajax
        if (!$request->isXmlHttpRequest()) {
            return new JsonResponse(array('message' => 'Interdit'), 400);
        }
        
        $user=$this->getUser();
        $portal_activate=$this->getParameter("portal_activate");

        $start=$request->query->get('start');
        $length= $request->query->get('length');
        $search= $request->query->get('search');
        $draw= $request->query->get('draw');
        $order= $request->query->get('order');
      
        // Nombre total d'enregistrement
        $qb=$em->getManager()->createQueryBuilder();
        $qb->select('COUNT(table)')->from($this->labelentity,'table');
        if($access=="user") {
            $qb->from("App\Entity\UserGroup","ug")
               ->andWhere("table.fgcanshare=:flag")
               ->andWhere("table.id=ug.group")
               ->andWhere(":user=ug.user")
               ->setParameter("flag", true)
               ->setParameter("user", $user);
            
        }
        $total = $qb->getQuery()->getSingleScalarResult();

        // Nombre d'enregistrement filtré
        if($search["value"]=="")
            $totalf = $total;
        else {
            $qb=$em->getManager()->createQueryBuilder();
            $qb->select('COUNT(table)')
               ->from($this->labelentity,'table')
               ->leftJoin('App\Entity\User', 'u',  'WITH',  'table.owner = u.id')
               ->where('table.label LIKE :value')
               ->orWhere('u.username LIKE :value')
               ->setParameter("value", "%".$search["value"]."%");
            if($access=="user") {
                $qb->from("App\Entity\UserGroup","ug")
                   ->andWhere(("table.fgcanshare=:flag"))
                   ->andWhere("table.id=ug.group")
                   ->andWhere(":user=ug.user")
                   ->setParameter("flag", true)
                   ->setParameter("user", $user);
                
            }

            $totalf= $qb->getQuery()->getSingleScalarResult();
        }

        // Construction du tableau de retour
        $output = array(
            'draw' => $draw,
            'recordsFiltered' => $totalf,
            'recordsTotal' => $total,
            'data' => array(),
        );

        // Parcours des Enregistrement
        $qb = $em->getManager()->createQueryBuilder();
        $qb ->select('table')
            ->from($this->labelentity,'table')
            ->leftJoin('App\Entity\User', 'u',  'WITH',  'table.owner = u.id');
        if($access=="user") {
            $qb->from("App\Entity\UserGroup","ug")
               ->andWhere(("table.fgcanshare=:flag"))
               ->andWhere("table.id=ug.group")
               ->andWhere(":user=ug.user")
               ->setParameter("flag", true)
               ->setParameter("user", $this->getUser());
            
        }        
        if($search["value"]!="") {
            $qb ->andwhere('table.label LIKE :value')
                ->orWhere('u.username LIKE :value')
                ->setParameter("value", "%".$search["value"]."%");
        }
        switch($order[0]["column"]) {
            case 2 : 
            $qb->orderBy('table.label',$order[0]["dir"]);
            break;
            case 3 : 
            $qb->orderBy('table.fgopen',$order[0]["dir"]);
            break;     
            case 5 : 
            $qb->orderBy('table.fgcanshare',$order[0]["dir"]);
            break;             
            case 6 : 
            $qb->orderBy('table.owner',$order[0]["dir"]);
            break;              
            case 8 : 
            $qb->orderBy('table.fgcancreatepage',$order[0]["dir"]);
            break;                                  
            case 9 : 
            $qb->orderBy('table.fgcancreatecalendar',$order[0]["dir"]);
            break;                                  
            case 10 : 
            $qb->orderBy('table.fgcancreateblog',$order[0]["dir"]);
            break;                                  
            case 11 : 
            $qb->orderBy('table.fgcancreateproject',$order[0]["dir"]);
            break;                                  
        }

        $datas=$qb->setFirstResult($start)->setMaxResults($length)->getQuery()->getResult();

        foreach($datas as $data) {
            $action = "";
            
            if($access=="config") {
                // Modification possible si groupe non template et non tout le monde
                if(!$data->getFgTemplate() && !$data->getFgall())
                    $action .="<a href='".$this->generateUrl('app_core_config_group_update', array('id'=>$data->getId()))."' title='Modifier'><i class='fa fa-file fa-2x fa-fw'></i></a>";
                
                // Modification possible si groupe template mais avec module portail activé
                elseif($data->getFgTemplate()&&$portal_activate)
                    $action .="<a href='".$this->generateUrl('app_core_config_group_update', array('id'=>$data->getId()))."' title='Modifier'><i class='fa fa-file fa-2x fa-fw'></i></a>";
                
                // Modification possible si groupe tout le monde mais avec module portail activé
                elseif($data->getFgall()&&$portal_activate)
                    $action .="<a href='".$this->generateUrl('app_core_config_group_update', array('id'=>$data->getId()))."' title='Modifier'><i class='fa fa-file fa-2x fa-fw'></i></a>";

                if($data->getId()>0&&!$data->getFgall()&&!$data->getFgTemplate()&&$this->isGranted('ROLE_ADMIN')) $action.="<a href='".$this->generateUrl('app_core_config_group_delete', array('id'=>$data->getId()))."' title='Supprimer'><i class='fa fa-trash fa-fw fa-2x'></i></a>";
                if(!$data->getFgall()) $action .="<a href='".$this->generateUrl('app_core_config_group_users', array('id'=>$data->getId()))."' title='Utilisateurs du Groupe'><i class='fa fa-users fa-2x fa-fw'></i></a>";
                
                if($data->getFgcanshare())
                    $action.="<a href='".$this->generateUrl('app_core_'.$access.'_group_statistic', array('id'=>$data->getId()))."' title='Statistique'><i class='fa fa-chart-area fa-fw fa-2x'></i></a>";
            }
            else {
                $fgcanupdate=($user==$data->getOwner());
                $fgcanmanage=false;
                $usergroup=$em->getRepository("App\Entity\UserGroup")->findOneBy(["user"=>$this->getUser(),"group"=>$data]);
                if($usergroup) $fgcanmanage=($usergroup->getRolegroup()>=90);

                // Modification possible uniquement si l'utilisateur est propriétaire du groupe
                if($fgcanupdate) {
                    $action .="<a href='".$this->generateUrl('app_core_'.$access.'_group_update', array('id'=>$data->getId()))."' title='Modifier'><i class='fa fa-file fa-2x fa-fw'></i></a>";
                    $action .="<a href='".$this->generateUrl('app_core_'.$access.'_group_delete', array('id'=>$data->getId()))."' title='Supprimer'><i class='fa fa-trash fa-2x fa-fw'></i></a>";
                }

                // Gestion des utilisateurs du groupe uniquement pour le proprio ou les managers
                if($fgcanupdate||$fgcanmanage) {
                    $action .="<a href='".$this->generateUrl('app_core_'.$access.'_group_users', array('id'=>$data->getId()))."' title='Utilisateurs du Groupe'><i class='fa fa-users fa-2x fa-fw'></i></a>";
                }
                else {
                    // Vue membres
                    $viewinfo=true;
                    $permannu=$request->getSession()->get('permannu');
                    if($permannu=="NO_BODY") $viewinfo=false;
                    if($permannu=="ROLE_ANIM" && $this->isGranted('ROLE_USER'))  $viewinfo=false;
                    if($permannu=="ROLE_MODO" && ($this->isGranted('ROLE_ANIM') || $this->isGranted('ROLE_USER')))  $viewinfo=false;
                    if($viewinfo) $action .="<a href='".$this->generateUrl('app_core_'.$access.'_group_info', array('id'=>$data->getId()))."' title='Utilisateurs du Groupe'><i class='fa fa-users fa-2x fa-fw'></i></a>";

                    // On ne peut se désinscrire que si le groupe est ouvert et qu'il n'est pas lié à un groupe ldap ou sso
                    $fgcanleave=true;
                    if($data->getFgtemplate() or $data->getFgall()) $fgcanleave=false;
                    elseif(!$data->getFgcanshare() && !$data->getFgopen()) $fgcanleave=false;
                    elseif($data->getFgcanshare() && !$request->getSession()->get('permunsubscribe') && !$data->getFgopen()) $fgcanleave=false;
                    if($fgcanleave) $action.="<a href='".$this->generateUrl('app_core_'.$access.'_group_out', array('id'=>$data->getId()))."' title='Sortir du Groupe'><i class='fa fa-sign-out-alt fa-fw fa-2x'></i></a>";
                }

                if($data->getFgcanshare())
                    $action.="<a href='".$this->generateUrl('app_core_'.$access.'_group_statistic', array('id'=>$data->getId()))."' title='Statistique'><i class='fa fa-chart-area fa-fw fa-2x'></i></a>";
            }
            

            $filtre="";
            if($this->GetParameter("masteridentity")=="LDAP") $filtre=$data->getLdapfilter();
            if($this->GetParameter("masteridentity")=="SSO") $filtre=$data->getAttributes();

            if ($data->getIcon())
                $groupinfo = "<img src='/".$this->getParameter('alias').$data->getIcon()->getLabel()."' class='avatar' style='background-color:transparent'; width:30px;/>";
            else
                $groupinfo = "<img src='/".$this->getParameter('alias')."uploads/icon/icon_pin.png' class='avatar' style='background-color:transparent; width:30px;'/>";

            $userinfo="";
            if($data->getOwner()) {
                $userinfo.="<img style='cursor:pointer' onClick='seeUser(".$data->getOwner()->getId().")' src='/".$this->getParameter('alias')."uploads/avatar/".$data->getOwner()->getAvatar()."' class='avatar' style='margin:0px 5px 0px 0px;display:inline-block;'>";
                $userinfo.="<br>".$data->getOwner()->getUsername();
            }

            $visitecpt=0;
            $visitelast=null;
            foreach($data->getUsers() as $usergroup) {
                $visitecpt+=$usergroup->getVisitecpt();
                $visitelast=($usergroup->getVisitedate()>$visitelast?$usergroup->getVisitedate():$visitelast);
            }


            array_push($output["data"],array(
                $action,
                $groupinfo,
                $data->getLabel(),
                ($data->getFgopen()?"oui":"non"),
                $filtre,
                ($data->getFgcanshare()?"oui":"non"),
                $userinfo,
                ($visitelast?$visitelast->format("d/m/Y H:i")."<br>":"")."nb = ".$visitecpt,
                ($data->getFgcancreatepage()?"oui":"non"),
                ($data->getFgcancreatecalendar()?"oui":"non"),
                ($data->getFgcancreateblog()?"oui":"non"),
                ($data->getFgcancreateproject()?"oui":"non"),
                )
            );
        }

        // Retour
        return new Response(json_encode($output), 200);
    }    


    public function ajaxusersnotin($id,$access="config",Request $request, ManagerRegistry $em)
    {
        // S'assurer que c'est un appel ajax
        if (!$request->isXmlHttpRequest()) {
            return new JsonResponse(array('message' => 'Interdit'), 400);
        }
        
        $group=$this->getData($em,$id);
        $this->canManager($em,$group,$access);

        $sub = $em->getManager()->createQueryBuilder();
        $sub->select("usergroup");
        $sub->from("App\Entity\UserGroup","usergroup");
        $sub->andWhere('usergroup.user = user.id');
        $sub->andWhere('usergroup.group = :groupid');    

        $start=$request->query->get('start');
        $length= $request->query->get('length');
        $search= $request->query->get('search');
        $draw= $request->query->get('draw');
        $order= $request->query->get('order');
      
        // Nombre total d'enregistrement
        $qb = $em->getManager()->createQueryBuilder();
        if($this->isGranted('ROLE_ADMIN')||$access=="user")
            $qb->select('COUNT(user)')
               ->from('App\Entity\User','user')
               ->where($qb->expr()->not($qb->expr()->exists($sub->getDQL())))
               ->setParameter("groupid",$id);
        else {
            $usermodo=$this->getUser()->getId();
            $qb->select('COUNT(user)')
               ->from('App\Entity\User','user')
               ->from('App\Entity\UserModo','usermodo')
               ->where($qb->expr()->not($qb->expr()->exists($sub->getDQL())))
               ->andWhere("usermodo.niveau01 = user.niveau01")
               ->andWhere("usermodo.user = :userid")
               ->setParameter("userid", $usermodo)
               ->setParameter("groupid",$id);        
        }
        $total=$qb->getQuery()->getSingleScalarResult();

        // Nombre d'enregistrement filtré
        if($search["value"]=="")
            $totalf = $total;
        else {
            if($this->isGranted('ROLE_ADMIN')||$access=="user")
                $totalf= $em->getManager()->createQueryBuilder()
                            ->select('COUNT(user)')
                            ->from('App\Entity\User','user')
                            ->where('user.username LIKE :value OR user.email LIKE :value')
                            ->andWhere($qb->expr()->not($qb->expr()->exists($sub->getDQL())))
                            ->setParameter("value", "%".$search["value"]."%")
                            ->setParameter("groupid",$id)
                            ->getQuery()
                            ->getSingleScalarResult();
            else
                $totalf= $em->getManager()->createQueryBuilder()
                            ->select('COUNT(user)')
                            ->from('App\Entity\User','user')
                            ->from('App\Entity\UserModo','usermodo')
                            ->where('user.username LIKE :value OR user.email LIKE :value')
                            ->andWhere($qb->expr()->not($qb->expr()->exists($sub->getDQL())))
                            ->andWhere("usermodo.niveau01 = user.niveau01")
                            ->andWhere("usermodo.user = :userid")
                            ->setParameter("userid", $usermodo)                            
                            ->setParameter("value", "%".$search["value"]."%")
                            ->setParameter("groupid",$id)
                            ->getQuery()
                            ->getSingleScalarResult();
    
        }

        // Construction du tableau de retour
        $output = array(
            'draw' => $draw,
            'recordsFiltered' => $totalf,
            'recordsTotal' => $total,
            'data' => array(),
        );

        // Parcours des Enregistrement
        $qb = $em->getManager()->createQueryBuilder();
        $qb->select('user')->from("App\Entity\User",'user');
        
        if($this->isGranted('ROLE_ADMIN')||$access=="user")
            $qb->where($qb->expr()->not($qb->expr()->exists($sub->getDQL())));
        else 
            $qb->from('App\Entity\UserModo','usermodo')
               ->where($qb->expr()->not($qb->expr()->exists($sub->getDQL())))
               ->andWhere("usermodo.niveau01 = user.niveau01")
               ->andWhere("usermodo.user = :userid")
               ->setParameter("userid", $usermodo);                            

        if($search["value"]!="") {
            $qb ->andWhere('user.username LIKE :value OR user.email LIKE :value')
                ->setParameter("value", "%".$search["value"]."%");
        }
        $qb->setParameter("groupid",$id);
        switch($order[0]["column"]) {
            case 2 : 
            $qb->orderBy('user.username',$order[0]["dir"]);
            break;

            case 3 : 
            $qb->orderBy('user.email',$order[0]["dir"]);
            break;
        }

        $datas=$qb->setFirstResult($start)->setMaxResults($length)->getQuery()->getResult();

        foreach($datas as $data) {
            // Action
            $action = "";
            if($group->getLdapfilter()==""&&$group->getAttributes()=="")
                $action.="<a style='cursor:pointer' onClick='addUsers(".$data->getId().")'><i class='fa fa-plus fa-fw'></i></a>";
            
            // Avatar
            $avatar="<img onClick='seeUser(".$data->getId().")' src='/".$this->getParameter('alias')."uploads/avatar/".$data->getAvatar()."' style='width:30px;background-color:#337ab7;margin:auto;display:block;cursor:pointer;'>";

            array_push($output["data"],array("DT_RowId"=>"user".$data->getId(),$action,$avatar,$data->getUsername(),$data->getEmail(),"",""));
        }

        // Retour
        return new Response(json_encode($output), 200);
    }    

    public function ajaxusersin($id,$access="config",Request $request, ManagerRegistry $em)
    {
        // S'assurer que c'est un appel ajax
        if (!$request->isXmlHttpRequest()) {
            return new JsonResponse(array('message' => 'Interdit'), 400);
        }
        
        $group=$this->getData($em,$id);
        $this->canManager($em,$group,$access);

        $sub = $em->getManager()->createQueryBuilder();
        $sub->select("usergroup");
        $sub->from("App\Entity\UserGroup","usergroup");
        $sub->andWhere('usergroup.user = user.id');
        $sub->andWhere('usergroup.group = :groupid');    

        $start=$request->query->get('start');
        $length= $request->query->get('length');
        $search= $request->query->get('search');
        $draw= $request->query->get('draw');
        $order= $request->query->get('order');
        $fgcanshare= $request->query->get('fgcanshare');
      
        // Nombre total d'enregistrement
        $qb = $em->getManager()->createQueryBuilder();
        if($this->isGranted('ROLE_ADMIN')||$access=="user")
            $qb->select('COUNT(user)')
               ->from('App\Entity\User','user')
               ->where($qb->expr()->exists($sub->getDQL()))
               ->setParameter("groupid",$id);
        else {
            $usermodo=$this->getUser()->getId();
            $qb->select('COUNT(user)')
               ->from('App\Entity\User','user')
               ->from('App\Entity\UserModo','usermodo')
               ->where($qb->expr()->exists($sub->getDQL()))
               ->andWhere("usermodo.niveau01 = user.niveau01")
               ->andWhere("usermodo.user = :userid")
               ->setParameter("userid", $usermodo)
               ->setParameter("groupid",$id);        
        }
        $total=$qb->getQuery()->getSingleScalarResult();

        // Nombre d'enregistrement filtré
        if($search["value"]=="")
            $totalf = $total;
        else {
            if($this->isGranted('ROLE_ADMIN')||$access=="user")
                $totalf= $em->getManager()->createQueryBuilder()
                            ->select('COUNT(user)')
                            ->from('App\Entity\User','user')
                            ->where('user.username LIKE :value OR user.email LIKE :value')
                            ->andWhere($qb->expr()->exists($sub->getDQL()))
                            ->setParameter("value", "%".$search["value"]."%")
                            ->setParameter("groupid",$id)
                            ->getQuery()
                            ->getSingleScalarResult();
            else
                $totalf= $em->getManager()->createQueryBuilder()
                            ->select('COUNT(user)')
                            ->from('App\Entity\User','user')
                            ->from('App\Entity\UserModo','usermodo')
                            ->where('user.username LIKE :value OR user.email LIKE :value')
                            ->andWhere($qb->expr()->exists($sub->getDQL()))
                            ->andWhere("usermodo.niveau01 = user.niveau01")
                            ->andWhere("usermodo.user = :userid")
                            ->setParameter("userid", $usermodo)                            
                            ->setParameter("value", "%".$search["value"]."%")
                            ->setParameter("groupid",$id)
                            ->getQuery()
                            ->getSingleScalarResult();
    
        }

        // Construction du tableau de retour
        $output = array(
            'draw' => $draw,
            'recordsFiltered' => $totalf,
            'recordsTotal' => $total,
            'data' => array(),
        );

        // Parcours des Enregistrement
        $qb = $em->getManager()->createQueryBuilder();
        $qb->select('user')->from("App\Entity\User",'user');
        
        if($this->isGranted('ROLE_ADMIN')||$access=="user")
            $qb->where($qb->expr()->exists($sub->getDQL()));
        else 
            $qb->from('App\Entity\UserModo','usermodo')
               ->where($qb->expr()->exists($sub->getDQL()))
               ->andWhere("usermodo.niveau01 = user.niveau01")
               ->andWhere("usermodo.user = :userid")
               ->setParameter("userid", $usermodo);                            

        if($search["value"]!="") {
            $qb ->andWhere('user.username LIKE :value OR user.email LIKE :value')
                ->setParameter("value", "%".$search["value"]."%");
        }
        $qb->setParameter("groupid",$id);
        switch($order[0]["column"]) {
            case 2 : 
                $qb->orderBy('user.username',$order[0]["dir"]);
            break;

            case 3 : 
                $qb->orderBy('user.email',$order[0]["dir"]);
            break;
        }

        $datas=$qb->setFirstResult($start)->setMaxResults($length)->getQuery()->getResult();
        $user=$this->getUser();

        $config=$em->getRepository('App\Entity\Config')->find("datausers");
        $fields=$config->getValue();
        $fields=json_decode($fields,true);
        if(!is_array($fields)) $fields=[];
        if(!array_key_exists("visite",$fields)) $fields["visite"]["perm"]=0;
        $fgviewvisite=($fields["visite"]["perm"]==1);
                
        foreach($datas as $data) {
            // Propriétaire
            $usergroup=$em->getRepository("App\Entity\UserGroup")->findOneBy(["user"=>$data->getId(),"group"=>$id]);
            $fgproprio=($usergroup->getUser()==$group->getOwner());

            // Action
            $action = "";
            if($group->getLdapfilter()==""&&$group->getAttributes()==""&&!$fgproprio)
                $action.="<a style='cursor:pointer' onClick='delUsers(".$data->getId().")'><i class='fa fa-minus fa-fw'></i></a>";

            // Avatar
            $avatar="<img onClick='seeUser(".$data->getId().")' src='/".$this->getParameter('alias')."uploads/avatar/".$data->getAvatar()."' style='width:30px;background-color:#337ab7;margin:auto;display:block;cursor:pointer'>";
            
            // Flag manager
            $rolegroup="";
            if($fgcanshare) {
                if($fgproprio) $rolegroup="Propriétaire du groupe";
                elseif($user==$usergroup->getUser()&&$access!="config") $rolegroup="Gestionnaire";
                else {
                    $selectuser=($usergroup->getRolegroup()==0?"selected='selected'":"");
                    $selectwritter=($usergroup->getRolegroup()==50?"selected='selected'":"");
                    $selectmanager=($usergroup->getRolegroup()==90?"selected='selected'":"");

                    $rolegroup='<select id="roleuser-'.$data->getId().'" name="user[visible]" onChange="changeRole('.$data->getId().');"><option value="0" '.$selectuser.'>Utilisateur</option><option value="50" '.$selectwritter.'>Collaborateur</option><option value="90" '.$selectmanager.'>Gestionnaire</option></select>';
                }
            }
        
            // Visite
            if($fgviewvisite) {
                $visite="";
                if($usergroup->getVisitedate()) {
                    $visite=$usergroup->getVisitedate()->format("d/m/Y H:i")."<br>nb = ".$usergroup->getVisitecpt();
                }
            }
            if($fgviewvisite)
                $tmp=array("DT_RowId"=>"user".$data->getId(),$action,$avatar,$data->getUsername(),$data->getEmail(),$visite,$rolegroup);
            else
                $tmp=array("DT_RowId"=>"user".$data->getId(),$action,$avatar,$data->getUsername(),$data->getEmail(),$rolegroup);

            array_push($output["data"],$tmp);
        }

        // Retour
        return new Response(json_encode($output), 200);
    } 

    public function usergroupadd($access="config",Request $request, ManagerRegistry $em)
    {
        // S'assurer que c'est un appel ajax
        if (!$request->isXmlHttpRequest()) {
            return new JsonResponse(array('message' => 'Interdit'), 400);
        }

        $output=array();
        $userid=$request->request->get('userid');
        $groupid=$request->request->get('groupid');

        $group=$em->getRepository("App\Entity\Group")->find($groupid);
        $this->canManager($em,$group,$access);
        if($group->getFgAll()||$group->getFgtemplate())
            throw $this->createNotFoundException('Permission denied');

        $usergroup = $em->getRepository("App\Entity\Usergroup")->findOneBy(array("user"=>$userid,"group"=>$groupid));
        if($usergroup) {
            $response = new Response(json_encode($output));    
            $response->headers->set('Content-Type', 'application/json');        
            return $response;
        }

        $key = Uuid::uuid4();
        $usergroup=new UserGroup();
        $user=$em->getRepository("App\Entity\User")->find($userid);
        $usergroup->setUser($user);
        $usergroup->setGroup($group);
        $usergroup->setKeyvalue($key);
        $usergroup->setRolegroup(0);
        $em->getManager()->persist($usergroup);
        $em->getManager()->flush();

        // Notification message
        $user=$em->getRepository("App\Entity\User")->find($userid);
        $message="Inscription de l'utilisateur<br>".$user->getLastname()." ".$user->getFirstname()."<br>Par ".$this->getUser()->getLastname()." ".$this->getUser()->getFirstname();
        $this->wss->addMessage($this->getUser()->getApikey(),$groupid,$message);

        // Notification mail auprès de la personne inscrite
        if($group->getFgcanshare()&&$request->getSession()->get('fgnotifgroup')) {
            $idpage =$group->getPages()->first()->getId();
            $url = $this->generateUrl('app_core_redirect', ["route"=>"app_core_home","id"=>$idpage], UrlGeneratorInterface::ABSOLUTE_URL);
            $subject=$request->getSession()->get('appname')." : Inscription au groupe de travail : ".$group->getLabel();
            $body="Vous venez d'être inscrit dans le groupe de travail : ".$group->getLabel()."<br><br>".$group->getDescription()."<br>Suivez le lien suivant pour y accéder = <a href='$url'>$url</a>";
            $to = $user->getEmail();
            $from =  $this->getParameter('noreply');
            $fromName = $request->getSession()->get('appname');
            $this->mail->sendEmail($subject, $body, $to, $from, $fromName);      
        }

        // Retour
        $response = new Response(json_encode($output));    
        $response->headers->set('Content-Type', 'application/json');        
        return $response;
    }

    public function usergroupdel($access="config",Request $request, ManagerRegistry $em)
    {
        // S'assurer que c'est un appel ajax
        if (!$request->isXmlHttpRequest()) {
            return new JsonResponse(array('message' => 'Interdit'), 400);
        }
       
        $output=array();
        $userid=$request->request->get('userid');
        $groupid=$request->request->get('groupid');
        
        $group=$em->getRepository("App\Entity\Group")->find($groupid);
        $this->canManager($em,$group,$access);
        if($group->getFgAll()||$group->getFgTemplate())
            throw $this->createNotFoundException('Permission denied');

        // Notification message
        $data = $em->getRepository("App\Entity\Usergroup")->findOneBy(array("user"=>$userid,"group"=>$groupid));
        $user=$em->getRepository("App\Entity\User")->find($userid);
        $message="Désinscription de l'utilisateur<br>".$user->getLastname()." ".$user->getFirstname()."<br>Par ".$this->getUser()->getLastname()." ".$this->getUser()->getFirstname();;
        $this->wss->addMessage($this->getuser()->getApikey(),$groupid,$message);

        // Desinscription
        $em->getManager()->remove($data);
        $em->getManager()->flush();

        // Notification mail auprès des managers
        if($group->getFgcanshare()&&$request->getSession()->get('fgnotifgroup')) {
            $subject=$request->getSession()->get('appname')." : ".$user->getUsername()." = Désinscription au groupe de travail ".$group->getLabel();
            $body=$user->getUsername()." a été désinscrit du groupe de travail : ".$group->getLabel()."<br><br>".$group->getDescription();
            $usergroups=$em->getRepository("App\Entity\Usergroup")->findBy(array("group"=>$groupid));
            $to=array();
            foreach($usergroups as $usergroup) {
                if($usergroup->getRolegroup()>=90)
                    array_push($to,$usergroup->getUser()->getEmail());
            }
            $from =  $this->getParameter('noreply');
            $fromName = $request->getSession()->get('appname');
            $this->mail->sendEmail($subject, $body, $to, $from, $fromName);       
        }
                
        $response = new Response(json_encode($output));    
        $response->headers->set('Content-Type', 'application/json');        
        return $response;
    }

    public function out($id,$access="config",Request $request, ManagerRegistry $em)
    {
        $group=$em->getRepository("App\Entity\Group")->find($id);
        if($group->getFgAll()||$group->getFgTemplate())
            throw $this->createNotFoundException('Permission denied');

        // Notification message
        $usergroup = $em->getRepository("App\Entity\Usergroup")->findOneBy(array("user"=>$this->getUser(),"group"=>$id));
        if($usergroup) {
            $user=$em->getRepository("App\Entity\User")->find($this->getUser());
            $message="Désinscription de l'utilisateur<br>".$user->getLastname()." ".$user->getFirstname()."<br>Par ".$this->getUser()->getLastname()." ".$this->getUser()->getFirstname();;
            $this->wss->addMessage($this->getuser()->getApikey(),$id,$message);
        }

        // Desinscription
        $em->getManager()->remove($usergroup);
        $em->getManager()->flush();

        // Notification mail auprès des managers
        if($group->getFgcanshare()&&$request->getSession()->get('fgnotifgroup')) {
            $subject=$request->getSession()->get('appname')." : ".$user->getUsername()." = Désinscription au groupe de travail ".$group->getLabel();
            $body=$user->getUsername()." a été désinscrit du groupe de travail : ".$group->getLabel()."<br><br>".$group->getDescription();
            $usergroups=$em->getRepository("App\Entity\Usergroup")->findBy(array("group"=>$group));
            $to=array();
            foreach($usergroups as $usergroup) {
                if($usergroup->getRolegroup()>=90)
                    array_push($to,$usergroup->getUser()->getEmail());
            }

            $from =  $this->getParameter('noreply');
            $fromName = $request->getSession()->get('appname');
            $this->mail->sendEmail($subject, $body, $to, $from, $fromName);      
        }

        return $this->redirect($this->generateUrl("app_core_user_group"));
    }

    public function changerole($access="config",Request $request, ManagerRegistry $em)
    {
        // S'assurer que c'est un appel ajax
        if (!$request->isXmlHttpRequest()) {
            return new JsonResponse(array('message' => 'Interdit'), 400);
        }
        
        $output=array();
        $userid=$request->request->get('user');
        $groupid=$request->request->get('group');
        $role=$request->request->get('role');

        $group=$em->getRepository("App\Entity\Group")->find($groupid);
        $this->canManager($em,$group,$access);

        $data = $em->getRepository("App\Entity\Usergroup")->findOneBy(array("user"=>$userid,"group"=>$groupid));
        if($data) $data->setRolegroup($role);

        $em->getManager()->flush();

        $response = new Response(json_encode($output));    
        $response->headers->set('Content-Type', 'application/json');        
        return $response;
    }

    public function submit($access="config",Request $request, ManagerRegistry $em)
    {
        // Permission
        if($access=="user") {
            $permgroup=$request->getSession()->get('permgroup');
            if($permgroup=="NO_BODY") throw $this->createNotFoundException('Permission denied');
            if($permgroup=="ROLE_ANIM" && $this->isGranted('ROLE_USER')) throw $this->createNotFoundException('Permission denied');
            if($permgroup=="ROLE_MODO" && ($this->isGranted('ROLE_ANIM') || $this->isGranted('ROLE_USER'))) throw $this->createNotFoundException('Permission denied');
        }

        // Initialisation de l'enregistrement
        $data = new Group();
        $data->setFgopen(false);
        $data->setFgcanshare(($access=="user"));
        $data->setFgcancreatepage(false);
        $data->setFgcancreatecalendar(false);
        $data->setFgcancreateblog(false);
        $data->setFgcancreateproject(false);
        if($access=="user") {
            $data->setOwner($this->getUser());
            if($this->getParameter("portal_activate")) {
                $template=$em->getRepository("App\Entity\Page")->findoneby(["parentfor"=>"group"]);
                $data->setPagetemplate($template);
            }
        }

        // Création du formulaire
        $form = $this->createForm(GroupType::class,$data,array(
            "mode"=>"submit",
            "fgall"=>false,
            "updatelimite"=>false,
            "access"=>$access,
            "masteridentity"=> $this->GetParameter("masteridentity"),
            "portal_activate"=>$this->getParameter("portal_activate")
            )
        );

        // Récupération des data du formulaire
        $form->handleRequest($request);
        
        // Sur erreur
        $this->getErrorForm($em,null,$form,$request,$data,"submit",$access);
        
        // Sur validation
        if ($form->get('submit')->isClicked() && $form->isValid()) {  
            $data = $form->getData();  
            $data->setFgall(false);
            $data->setFgtemplate(false);
            if($data->getLdapfilter()!="") $data->setFgopen(false);
            if($data->getAttributes()!="") $data->setFgopen(false);
            if($access=="user") $data->setOwner($this->getUser());

            // Icon
            $idicon = $form->get('idicon')->getData();
            $icon=$em->getRepository("App\Entity\Icon")->findoneby(["id"=>$idicon]);
            $data->setIcon($icon);   
            
            // Sauvegarde
            $em->getManager()->persist($data);
            $em->getManager()->flush();

            // On s'assure que le propriétaire est bien membre du groupe
            $this->ctrlOwner($em,$data);

            // On s'assure que le groupe de travail à bien page d'accueil / calendrier / blog associé
            // Sinon on les génère
            $this->ctrlFgcanshare($em,$data,$access);

            // Retour à la liste
            return $this->redirectToRoute("app_core_".$access."_group_users",["id"=>$data->getId(),"idreturn"=>$this->idpage]);
        }
        
        // Affichage du formulaire
        $icons=$em->getRepository("App\Entity\Icon")->findBy(["user"=>null]);
        $iconsuser=null;
        if($access=="user") $iconsuser=$em->getRepository("App\Entity\Icon")->findBy(["user"=>$this->getUser()]);

        return $this->render($this->nameentity.'\edit.html.twig', [
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => ($access=="config"),              
            $this->labeldata    => $data,
            'mode'              => 'submit',
            'access'            => $access,
            'icons'             => $icons,
            'iconsuser'         => $iconsuser,            
            'form'              => $form->createView()
        ]);
    }  

    public function update($id,$access="config",Request $request, ManagerRegistry $em)
    {
        // Récupération de l'enregistrement courant 
        $data=$this->getData($em,$id);
        $oldowner=$data->getOwner();

        $this->canOwner($data,$access);

        // Création du formulaire
        $form = $this->createForm(GroupType::class,$data,array(
            "mode"              => "update",
            "access"            => $access,
            "fgall"             => $data->getFgAll(),
            "updatelimite"      => ($data->getFgAll()||$data->getFgTemplate()),
            "masteridentity"    => $this->GetParameter("masteridentity"),
            "portal_activate"   => $this->getParameter("portal_activate"),
            "idicon"            => ($data->getIcon()?$data->getIcon()->getId():null),
            )
        );

        // Récupération des data du formulaire
        $form->handleRequest($request);
    
        // Sur erreur
        $this->getErrorForm($em,$id,$form,$request,$data,"update",$access);
        
        // Sur validation
        if ($form->get('submit')->isClicked() && $form->isValid()) {
            $data = $form->getData();

            $masteridentity=$this->GetParameter("masteridentity");
            if($masteridentity!="LDAP") $data->setLdapfilter(null);
            if($masteridentity!="SSO") $data->setAttributes(null);
            if($data->getLdapfilter()!="") $data->setFgopen(false);
            if($data->getAttributes()!="") $data->setFgopen(false);
            
            // Icon
            $idicon = $form->get('idicon')->getData();
            $icon=$em->getRepository("App\Entity\Icon")->findoneby(["id"=>$idicon]);
            $data->setIcon($icon); 
            
            // Sauvegarde
            $em->getManager()->flush();

            // On s'assure que le propriétaire est bien membre du groupe
            $this->ctrlOwner($em,$data);

            // On s'assure que le groupe de travail à bien page d'accueil / calendrier / blog associé
            // Sinon on les génère
            $this->ctrlFgcanshare($em,$data,$access);

            // Si le propriétaire change de main on prévient le nouveau propriétaire
            if($data->getOwner()&&$data->getOwner()!=$oldowner&&$request->getSession()->get('fgnotifgroup')) {
                // Email à destination de l'inscript pour le prévenir qu'un administrateur doit valider
                $subject=$request->getSession()->get('appname')." : Transfert de groupe";
                $body="On vient de vous tranférer la propriété du groupe ".$data->getLabel();
                $to = $data->getOwner()->getEmail();
                $from =  $this->getParameter('noreply');
                $fromName = $request->getSession()->get('appname');
                $this->mail->sendEmail($subject, $body, $to, $from, $fromName);
            }

            // Retour à la liste
            return $this->redirectToRoute("app_core_".$access."_group");
        }
        
        $icons=$em->getRepository("App\Entity\Icon")->findBy(["user"=>null]);
        $iconsuser=null;
        if($access=="user") $iconsuser=$em->getRepository("App\Entity\Icon")->findBy(["user"=>$this->getUser()]);

        // Affichage du formulaire
        return $this->render($this->nameentity.'\edit.html.twig', [
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => ($access=="config"),            
            $this->labeldata    => $data,
            'mode'              => 'update',
            'access'            => $access,
            'icons'             => $icons,
            'iconsuser'         => $iconsuser,            
            'form'              => $form->createView()
        ]);
    }

    public function delete($id,$access="config",Request $request, ManagerRegistry $em)
    {
        // Seule role admin peut supprimer un groupe
        if($access=="config"&&!$this->isGranted('ROLE_ADMIN'))
            return $this->redirectToRoute($this->labelroute);

        // Récupération de l'enregistrement courant 
        $data=$this->getData($em,$id);
        $this->canOwner($data,$access);

        // Vérifier que cet enregistrement est supprimable
        if($data->getFgAll()||$data->getFgTemplate())
            throw $this->createNotFoundException('Permission denied');

        // Création du formulaire
        $form = $this->createForm(GroupType::class,$data,array(
            "mode"=>"delete",
            "updatelimite"=>($data->getFgAll()||$data->getFgTemplate()),
            "masteridentity"=> $this->GetParameter("masteridentity"),
            "portal_activate"=>$this->getParameter("portal_activate")
            )
        );

        // Récupération des data du formulaire
        $form->handleRequest($request);        

        // Sur erreur
        $this->getErrorForm($em,$id,$form,$request,$data,"delete",$access);
                
        // Sur validation
        if ($form->get('submit')->isClicked() && $form->isValid()) {
            // Si le groupe est un groupe de travail
            if($data->getFgcanshare()) {
                // Sur l'ensemble des pages liés
                $pages=$data->getPages();
                foreach($pages as $page) {
                    $groups=$page->getGroups();
                    // si la page est lié qu'à un seul group on peut la supprimer
                    if($groups->count()==1)
                        $em->getManager()->remove($page);
                }

                // Sur l'ensemble des calendar liés
                $calendars=$data->getCalendars();
                foreach($calendars as $calendar) {
                    $groups=$calendar->getGroups();
                    // si la page est lié qu'à un seul group on peut la supprimer
                    if($groups->count()==1)
                        $em->getManager()->remove($calendar);
                }                

                // Sur l'ensemble des blog liés
                $blogs=$data->getBlogs();
                foreach($blogs as $blog) {
                    $groups=$blog->getGroups();
                    // si la page est lié qu'à un seul group on peut la supprimer
                    if($groups->count()==1)
                        $em->getManager()->remove($blog);
                }  
                
                // Sur l'ensemble des project liés
                $projects=$data->getProjects();
                foreach($projects as $project) {
                    $groups=$project->getGroups();
                    // si la page est lié qu'à un seul group on peut la supprimer
                    if($groups->count()==1)
                        $em->getManager()->remove($project);
                }                  
            }

            $em->getManager()->remove($data);
            $em->getManager()->flush();
            
            return $this->redirectToRoute("app_core_".$access."_group");
        }
        
        $icons=$em->getRepository("App\Entity\Icon")->findBy(["user"=>null]);
        $iconsuser=null;
        if($access=="user") $iconsuser=$em->getRepository("App\Entity\Icon")->findBy(["user"=>$this->getUser()]);

        // Affichage du formulaire
        return $this->render($this->nameentity.'\edit.html.twig', [
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => ($access=="config"),   
            $this->labeldata    => $data,
            'mode'              => 'delete',
            'access'            => $access,
            'icons'             => $icons,
            'iconsuser'         => $iconsuser,               
            'form'              => $form->createView()
        ]);                    
    }

    public function users($id,$access="config",Request $request, ManagerRegistry $em)
    {      
        // Récupération de l'enregistrement courant 
        $data=$this->getData($em,$id);
        $this->canManager($em,$data,$access);

        // idreturn ?
        $idreturn=$request->get("idreturn");

        $config=$em->getRepository('App\Entity\Config')->find("datausers");
        $fields=$config->getValue();
        $fields=json_decode($fields,true);
        if(!is_array($fields)) $fields=[];
        if(!array_key_exists("visite",$fields)) $fields["visite"]["perm"]=0;
        $fgviewvisite=($fields["visite"]["perm"]==1);
        
        // Affichage du formulaire
        return $this->render($this->nameentity.'\users.html.twig', [
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => ($access=="config"),               
            'access'            => $access,
            $this->labeldata    => $data,
            'idreturn'          => $idreturn,
            'fgviewvisite'      => $fgviewvisite,
        ]);  
    }

    public function info($id,$access="config",Request $request, ManagerRegistry $em)
    {      
        

        if($access=="user") {
            $permannu=$request->getSession()->get('permannu');
            if($permannu=="NO_BODY") throw $this->createNotFoundException('Permission denied');
            if($permannu=="ROLE_ANIM" && $this->isGranted('ROLE_USER')) throw $this->createNotFoundException('Permission denied');
            if($permannu=="ROLE_MODO" && ($this->isGranted('ROLE_ANIM') || $this->isGranted('ROLE_USER'))) throw $this->createNotFoundException('Permission denied');
        }

        // Récupération de l'enregistrement courant 
        $data=$this->getData($em,$id);


        // Affichage du formulaire
        return $this->render($this->nameentity.'\info.html.twig', [
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => ($access=="config"),               
            'access'            => $access,
            'group'             => $data,
        ]);  
    }

    public function groupexport($access="config",Request $request, ManagerRegistry $em)
    {      
        $dir    = $this->appKernel->getProjectDir().'/uploads/export/';
        $file   = "exportgroup.csv";

        $fs = new Filesystem();
        $fs->mkdir($dir);

        $csvh = fopen($dir.$file, 'w');
        $d = ';'; // this is the default but i like to be explicit
        $e = '"'; // this is the default but i like to be explicit

        // Entête de colonne     
        $data=["id","Label","Ouvert","Groupe de Travail","Propriétaire","Date Visite","Cpt Visite","Création Page","Création Calendriers","Création Blogs","Création Projets"];
        fputcsv($csvh, $data, $d, $e);

        // Liste des utilisateurs en fonction du role de l'utilisateur en cours
        $groups=$em->getRepository("App\Entity\Group")->findAll();
        
        foreach($groups as $group) {
            $data = [
                "id"=>$group->getId(),
                "label"=>$group->getLabel(),
                "fgopen"=>($group->getFgopen()?"oui":"non"),
                "fgcanshare"=>($group->getFgcanshare()?"oui":"non"),
                "owner"=>($group->getOwner()?$group->getOwner()->getUsername():""),
                "visitedate"=>"",
                "visitecpt"=>"",
                "fgcancreatepage"=>($group->getFgcancreatepage()?"oui":"non"),
                "fgcancreatecalendar"=>($group->getFgcancreatecalendar()?"oui":"non"),
                "fgcancreateblog"=>($group->getFgcancreateblog()?"oui":"non"),
                "fgcancreateproject"=>($group->getFgcancreateproject()?"oui":"non"),
            ];

            $visitecpt=0;
            $visitelast=null;
            foreach($group->getUsers() as $usergroup) {
                $visitecpt+=$usergroup->getVisitecpt();
                $visitelast=($usergroup->getVisitedate()>$visitelast?$usergroup->getVisitedate():$visitelast);
            }
            
            $data["visitedate"]=($visitelast?$visitelast->format("d/m/Y H:i"):"");
            $data["visitecpt"]=$visitecpt;

            fputcsv($csvh, $data, $d, $e);
        }
        fclose($csvh);        

        $response = new BinaryFileResponse($dir.$file);
        $response->setContentDisposition(ResponseHeaderBag::DISPOSITION_ATTACHMENT);
        
        return $response; 
    }

    public function usergroupexport($id,$access="config",Request $request, ManagerRegistry $em)
    {      
        // Récupération de l'enregistrement courant 
        $group=$this->getData($em,$id);
        $this->canManager($em,$group,$access);

        $dir    = $this->appKernel->getProjectDir().'/uploads/export/';
        $file   = "export-".$id.".csv";

        $fs = new Filesystem();
        $fs->mkdir($dir);

        $csvh = fopen($dir.$file, 'w');
        $d = ';'; // this is the default but i like to be explicit
        $e = '"'; // this is the default but i like to be explicit

        // Entête de colonne     
        $data=["id","Login","Nom","Prénom","Email","Téléphone",$this->getParameter("labelniveau01"),$this->getParameter("labelniveau02"),"Métier","Fonction","Nom Usage","Autres Prénom","Sexe","Adresse","Date Naissance","Pays Naissance","Ville Naissance","Date Visite","Nb Visites"];
        fputcsv($csvh, $data, $d, $e);

        // Liste des utilisateurs en fonction du role de l'utilisateur en cours
        $qb = $em->getManager()->createQueryBuilder();
        if($this->isGranted('ROLE_ADMIN')||$access=="user") {
            $users = $qb->select('user')
                    ->from('App\Entity\User','user')
                    ->from('App\Entity\UserGroup','usergroup')
                    ->where('usergroup.group=:group')
                    ->andWhere('usergroup.user=user')
                    ->setParameter("group", $id)
                    ->getQuery()
                    ->getResult();
        }
        elseif($this->isGranted('ROLE_MODO')) {
            $users = $qb->select('user')
                    ->from('App\Entity\User','user')
                    ->from('App\Entity\UserGroup','usergroup')
                    ->from('App\Entity\Niveau01','niveau01')
                    ->from('App\Entity\UserModo', 'usermodo')                    
                    ->where('usergroup.group=:group')
                    ->andWhere('usergroup.user=user')
                    ->andwhere('user.niveau01=niveau01.id')
                    ->andwhere("usermodo.niveau01 = user.niveau01")
                    ->andWhere("usermodo.user = :userid")                    
                    ->setParameter("group", $id)
                    ->setParameter("userid", $this->getUser()->getId())
                    ->getQuery()
                    ->getResult();
        }        
        
        foreach($users as $user) {
            $data = [
                "id"=>$user->getId(),
                "username"=>$user->getUsername(),
                "name"=>$user->getLastname(),
                "firstname"=>$user->getFirstname(),
                "email"=>$user->getEmail(),
                "phone"=>$user->getTelephonenumber(),
                "niveau01"=>$user->getNiveau01()->getLabel(),
                "niveau02"=>($user->getNiveau02()?$user->getNiveau02()->getLabel():""),
                "job"=>$user->getJob(),
                "position"=>$user->getPosition(),
                "usualname"=>$user->getUsualname(),
                "givensname"=>$user->getGivensname(),
                "gender"=>$user->getGender(),
                "postaladress"=>$user->getPostaladress(),
                "birthdate"=>($user->getBirthdate()?$user->getBirthdate()->format("d/m/Y"):""),
                "birthcountry"=>($user->getBirthcountry()?$user->getBirthcountry()->getLabel():""),
                "birthplace"=>($user->getBirthplace()?$user->getBirthplace()->getLabel():""),
                "visitedate"=>"",
                "visitecpt"=>"",
            ];

            $usergroup=$em->getRepository("App\Entity\UserGroup")->findOneBy(["user"=>$user,"group"=>$group]);
            if($usergroup) {
                if($usergroup->getVisitedate()) {
                    $data["visitedate"]=$usergroup->getVisitedate()->format("d/m/Y H:i");
                    $data["visitecpt"]=$usergroup->getVisitecpt();
                }
            }

            fputcsv($csvh, $data, $d, $e);
        }
        fclose($csvh);        

        $response = new BinaryFileResponse($dir.$file);
        $response->setContentDisposition(ResponseHeaderBag::DISPOSITION_ATTACHMENT);
        
        return $response; 
    }

    public function statistic($id,$access, ManagerRegistry $em) {
        $group=$this->getData($em,$id);
        if(!$group) throw $this->createNotFoundException('Permission denied');
    
        if($access!="config") {
            $usergroup=$em->getRepository("App\Entity\UserGroup")->findOneBy(["user"=>$this->getUser(),"group"=>$group]);
            if(!$usergroup) throw $this->createNotFoundException('Permission denied');
        }
        
        $groupcptvisite=$em->getRepository("App\Entity\Statistic")->findOneBy(["keyvalue"=>"groupcptvisite","group"=>$group]);
        $groupcptmessage=$em->getRepository("App\Entity\Statistic")->findOneBy(["keyvalue"=>"groupcptmessage","group"=>$group]);
        $groupcptblogarticle=$em->getRepository("App\Entity\Statistic")->findOneBy(["keyvalue"=>"groupcptblogarticle","group"=>$group]);
        $groupcptprojecttask=$em->getRepository("App\Entity\Statistic")->findOneBy(["keyvalue"=>"groupcptprojecttask","group"=>$group]);


        return $this->render($this->nameentity.'\statistic.html.twig',[
            'useheader'             => true,
            'usemenu'               => false,
            'usesidebar'            => ($access=="config"),
            'access'                => $access,   
            'group'                 => $group,
            'groupcptvisite'        => $groupcptvisite,
            'groupcptmessage'       => $groupcptmessage,
            'groupcptblogarticle'   => $groupcptblogarticle,
            'groupcptprojecttask'   => $groupcptprojecttask,
    
        ]);
    }

    public function invitation($id,$access="config",Request $request, ManagerRegistry $em)
    {      
        // Récupération de l'enregistrement courant 
        $group=$this->getData($em,$id);
        $this->canManager($em,$group,$access);

        $invitations=$group->getInvitations();
        if(!is_array($invitations)) $invitations=[];
        $listinvitations=[];
        
        foreach($invitations as $key => $mail) {
            $user=$em->getRepository("App\Entity\User")->findOneBy(["email"=>$mail]);
            // Si l'utilisateur est inscript plus la peine de le suivre
            if($user) {
                $listinvitations[$key]=["email"=>$mail,"statut"=>"","relance"=>false];
                $usergroup=$em->getRepository("App\Entity\UserGroup")->findOneBy(["user"=>$user,"group"=>$group]);
                if($usergroup)
                    $listinvitations[$key]["statut"]="Inscrit dans le groupe";
                else
                    $listinvitations[$key]["statut"]="Inscrit sur ".$request->getSession()->get('appname')." mais pas dans le groupe";
            }
            else {
                $listinvitations[$key]=["email"=>$mail,"statut"=>"Non inscrit sur ".$request->getSession()->get('appname'),"relance"=>true];
                $user=$em->getRepository("App\Entity\Registration")->findOneBy(["email"=>$mail]);
                if($user) {
                    $listinvitations[$key]["statut"]=$user->getStatut()->getLabel();
                    $listinvitations[$key]["relance"]=false;
                }
            }
        }

        return $this->render($this->nameentity.'\invitations.html.twig',[
            'useheader'     => false,
            'usemenu'       => false,
            'usesidebar'    => false,
            'id'            => $id,
            'invitations'   => $listinvitations,
        ]);          
    }

    protected function canManager($em,$group,$access) {
        if($access!="config") {
            $user=$em->getRepository("App\Entity\Usergroup")->findOneBy(["group"=>$group,"user"=>$this->getUser()]);
            if(!$user||$user->getRolegroup()<90) 
                throw $this->createNotFoundException('Permission denied');
        }
    }

    protected function canOwner($group,$access) {
        if($access!="config") {
            $isowner=($group->getOwner()==$this->getUser());
            if(!$isowner) 
                throw $this->createNotFoundException('Permission denied');
        }
    }    

    protected function ctrlOwner($em,$group) {
        // Le propriétaire passe manager
        $usergroups=$em->getRepository("App\Entity\Usergroup")->findBy(["group"=>$group,"rolegroup"=>"100"]);
        foreach($usergroups as $usergroup) {
            $usergroup->setRolegroup(90);
            $em->getManager()->flush();                
        }

        // Le propriétaire prend son role dans le groupe
        if($group->getOwner()) {
            $usergroup=$em->getRepository("App\Entity\Usergroup")->findOneBy(["group"=>$group,"user"=>$group->getOwner()]);
            if(!$usergroup) {
                $key = Uuid::uuid4();
                $usergroup=new UserGroup();
                $usergroup->setUser($group->getOwner());
                $usergroup->setGroup($group);
                $usergroup->setKeyvalue($key);
            }
            $usergroup->setRolegroup(100);
            $em->getManager()->persist($usergroup);
            $em->getManager()->flush();                
        }
    }

    protected function ctrlFgcanshare($em,$group,$access) {
        if($group->getFgcanshare()) {
            // On regarde s'il a au moins une page
            if($group->getPages()->isEmpty()) {
                $page=$em->getRepository("App\Entity\Page")->clonePage(null,$group->getPagetemplate());
                $group->addPage($page);
                $page->setName($group->getLabel());
                if($access=="user")$page->setUser($this->getUser());

                $em->getManager()->flush();
                
            }
            $pages=$group->getPages();
            $this->idpage=$pages[0]->getId();
            if($pages[0]->getName()!=$group->getLabel()) {
                $pages[0]->setName($group->getLabel());
                $em->getManager()->flush();
            }
            foreach($pages as $page) {
                $page->setUser($group->getOwner());
                $em->getManager()->flush();                
            }

            // On regarde s'il a au moins un calendrier
            if($group->getCalendars()->isEmpty()) {
                $calendar=new Calendar();
                $key = Uuid::uuid4();

                $calendar->setName($group->getLabel());
                $calendar->setKeyvalue($key);                
                $calendar->addGroup($group);
                $calendar->setColor($group->getColor());
                $calendar->setType(0);
                if($access=="user")$calendar->setUser($this->getUser());

                $em->getManager()->persist($calendar);
                $em->getManager()->flush();                  
            }
            else {
                $calendars=$group->getCalendars();
                if($calendars[0]->getName()!=$group->getLabel()) {
                    $calendars[0]->setName($group->getLabel());
                    $em->getManager()->flush();
                }
                foreach($calendars as $calendar) {
                    $calendar->setUser($group->getOwner());
                    $em->getManager()->flush();                
                }                
            }

            // On regarde s'il a au moins un blog
            if($group->getBlogs()->isEmpty()) {
                $blog=new Blog();

                $blog->setName($group->getLabel());
                $blog->addGroup($group);
                if($access=="user")$blog->setUser($this->getUser());

                $em->getManager()->persist($blog);
                $em->getManager()->flush();                  
            }
            else {            
                $blogs=$group->getBlogs();
                if($blogs[0]->getName()!=$group->getLabel()) {
                    $blogs[0]->setName($group->getLabel());
                    $em->getManager()->flush();
                }
                foreach($blogs as $blog) {
                    $blog->setUser($group->getOwner());
                    $em->getManager()->flush();                
                }                
            }

            // On regarde s'il a au moins un project
            if($group->getProjects()->isEmpty()) {
                $project=new Project();

                $project->setName($group->getLabel());
                $project->addGroup($group);
                if($access=="user")$project->setUser($this->getUser());

                $em->getManager()->persist($project);
                $em->getManager()->flush();                  
            }
            else {            
                $projects=$group->getProjects();
                if($projects[0]->getName()!=$group->getLabel()) {
                    $projects[0]->setName($group->getLabel());
                    $em->getManager()->flush();
                }
                foreach($projects as $project) {
                    $project->setUser($group->getOwner());
                    $em->getManager()->flush();                
                }                  
            }
        }
    }


    protected function getDatas($em)
    {
        $datas = $em->getRepository($this->labelentity)->findAll();
        return $datas;
    } 
            
    protected function getData($em,$id)
    {
        $data = $em->getRepository($this->labelentity)->find($id);

        if (!$data) {
            throw $this->createNotFoundException('Unable to find '.$this->labeldata);
        }

        return $data;
    } 

    protected function getEntityBy($em,$entity,$key,$value)
    {
        $datas = $em->getManager()->createQueryBuilder()
                      ->select('u')
                      ->from($entity,  'u')
                      ->where('u.'.$key.'=:value')
                      ->getQuery()->setParameter("value", $value)
                      ->getResult();
        if (!$datas) return false;
        else return true;
    }

    protected function getErrorForm($em,$id,$form,$request,$data,$mode,$access) {
        if ($form->get('submit')->isClicked()&&$mode=="delete") {
        
        }

        if ($form->get('submit')->isClicked() && ($mode=="submit" || $mode=="update")) {
            $tmp=$this->getEntityBy($em,"App\Entity\Niveau01","label",$data->getLabel());
            if($tmp) $form->addError(new FormError('Un niveau de rang 01 utilise déjà ce label'));

            $tmp=$this->getEntityBy($em,"App\Entity\Niveau02","label",$data->getLabel());
            if($tmp) $form->addError(new FormError('Un niveau de rang 02 utilise déjà ce label'));

            // On s'assure que le label ne contient pas des caractères speciaux
            $string = preg_replace('~[^ éèêôöàïî\'@a-zA-Z0-9._-]~', '', $data->getLabel());
            if($string!=$data->getLabel())
            {
                $form->addError(new FormError('Caractères interdit dans ce label'));
            } 

            if($data->getFgcanshare()&&is_null($data->getPagetemplate()))
                $form->addError(new FormError("Un groupe de travail doit avoir un modèle de page d'accueil"));
        }

        if ($form->get('submit')->isClicked() && $mode=="update" && $access=="user") {
            if(!$data->getOwner()) $form->addError(new FormError('Le propriétaire du groupe est obligatoire'));
        }

        if ($form->get('submit')->isClicked() && !$form->isValid()) {
            $errors = $form->getErrors();
            foreach( $errors as $error ) {
                $request->getSession()->getFlashBag()->add("error", $error->getMessage());
            }
        }
    }    
}
