<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Form\FormError;

use Symfony\Bundle\FrameworkBundle\Console\Application;
use Symfony\Component\Console\Input\ArrayInput;
use Symfony\Component\Console\Output\BufferedOutput;
use Symfony\Component\Console\Output\OutputInterface;
use Ramsey\Uuid\Uuid;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;
use Symfony\Component\HttpFoundation\BinaryFileResponse;
use Symfony\Component\Filesystem\Filesystem;
use Symfony\Component\HttpFoundation\ResponseHeaderBag;
use Doctrine\Persistence\ManagerRegistry;
use Symfony\Component\HttpKernel\KernelInterface;
use App\Service\MessageService;
use App\Service\MailService;

use App\Entity\User;
use App\Entity\UserGroup;
use App\Entity\UserModo;

use App\Form\UserType;
use App\Form\MailingType;


class UserController extends AbstractController
{
    private $nameentity  = "User";
    private $labelentity = 'App\Entity\User';
    private $labelroute  = 'app_core_config_user';
    private $labeldata   = 'user';
    private $labeldatas  = 'users';

    private $appKernel;
    private $wss;
    private $mail;
    
    public function __construct(KernelInterface $appKernel,messageService $wss,mailService $mail)
    {
        $this->appKernel = $appKernel;
        $this->wss = $wss;
        $this->mail = $mail;
    }

    public function list($access,Request $request, ManagerRegistry $em)
    {
        // Permission
        if($access=="user") {
            $permannu=$request->getSession()->get('permannu');
            if($permannu=="NO_BODY") throw $this->createNotFoundException('Permission denied');
            if($permannu=="ROLE_ANIM" && $this->isGranted('ROLE_USER')) throw $this->createNotFoundException('Permission denied');
            if($permannu=="ROLE_MODO" && ($this->isGranted('ROLE_ANIM') || $this->isGranted('ROLE_USER'))) throw $this->createNotFoundException('Permission denied');
        }

        $config=$em->getRepository('App\Entity\Config')->find("datausers");
        $fields=$config->getValue();
        $fields=json_decode($fields,true);

      	return $this->render($this->nameentity.'\list.html.twig',[
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => ($access=="config"),                 
            'access'            => $access,
            'fields'            => $fields
        ]);
    }

    public function ajaxlist($access, Request $request, ManagerRegistry $em)
    {
        // S'assurer que c'est un appel ajax
        if (!$request->isXmlHttpRequest()) {
            return new JsonResponse(array('message' => 'Interdit'), 400);
        }
        
        $start=$request->query->get('start');
        $length= $request->query->get('length');
        $search= $request->query->get('search');
        $draw= $request->query->get('draw');
        $order= $request->query->get('order');
        $viewniveau02=$this->getParameter('viewniveau02');
        $fields=$this->getDefaultDatauser($em);
        $fgusevisible=!($fields["visible"]["perm"]==0);

        // Nombre total d'enregistrement
        if($access=="config") {
            if($this->isGranted('ROLE_ADMIN')) {
                $total = $em->getManager()->createQueryBuilder()->select('COUNT(user)')->from($this->labelentity,'user')->getQuery()->getSingleScalarResult();
            }
            elseif($this->isGranted('ROLE_MODO')) {
                $usermodo=$this->getUser()->getId();
                $total = $em->getManager()->createQueryBuilder()
                            ->select('COUNT(user)')
                            ->from($this->labelentity,'user')
                            ->from("App\Entity\UserModo",'usermodo')
                            ->where("usermodo.niveau01 = user.niveau01")
                            ->andWhere("usermodo.user = :userid")
                            ->setParameter("userid", $usermodo)
                            ->getQuery()->getSingleScalarResult(); 
            }
        }
        else {
            if($fgusevisible) {
                $total = $em->getManager()->createQueryBuilder()->select('COUNT(user)')->from($this->labelentity,'user')->where('user.visible=true')->getQuery()->getSingleScalarResult();
            }
            else {
                $total = $em->getManager()->createQueryBuilder()->select('COUNT(user)')->from($this->labelentity,'user')->getQuery()->getSingleScalarResult();
            }
        }

        // Nombre d'enregistrement filtré
        if($search["value"]=="")
            $totalf = $total;
        else {
            if($access=="config") {
                if($this->isGranted('ROLE_ADMIN')) {
                    $totalf= $em->getManager()->createQueryBuilder()
                                ->select('COUNT(user)')
                                ->from('App\Entity\User','user')
                                ->from('App\Entity\Niveau01', 'niveau01')
                                ->where('user.niveau01=niveau01.id')
                                ->andWhere('user.username LIKE :value OR user.firstname LIKE :value OR user.lastname LIKE :value OR user.email LIKE :value OR user.role LIKE :value OR niveau01.label LIKE :value')
                                ->setParameter("value", "%".$search["value"]."%")
                                ->getQuery()
                                ->getSingleScalarResult();
                }
                elseif($this->isGranted('ROLE_MODO')) {
                    $totalf= $em->getManager()->createQueryBuilder()
                                ->select('COUNT(user)')
                                ->from('App\Entity\User','user')
                                ->from('App\Entity\Niveau01', 'niveau01')
                                ->from('App\Entity\UserModo', 'usermodo')
                                ->where('user.niveau01=niveau01.id')
                                ->andWhere('user.username LIKE :value OR user.firstname LIKE :value OR user.lastname LIKE :value OR user.email LIKE :value OR user.role LIKE :value OR niveau01.label LIKE :value')
                                ->andwhere("usermodo.niveau01 = user.niveau01")
                                ->andWhere("usermodo.user = :userid")
                                ->setParameter("userid", $usermodo)                            
                                ->setParameter("value", "%".$search["value"]."%")
                                ->getQuery()
                                ->getSingleScalarResult();
                }
            }
            else {
                if($fgusevisible) {
                    $totalf= $em->getManager()->createQueryBuilder()
                                ->select('COUNT(user)')
                                ->from('App\Entity\User','user')
                                ->from('App\Entity\Niveau01', 'niveau01')
                                ->where('user.niveau01=niveau01.id')
                                ->andWhere('user.visible=true')
                                ->andWhere('user.username LIKE :value OR user.firstname LIKE :value OR user.lastname LIKE :value OR user.email LIKE :value OR user.role LIKE :value OR niveau01.label LIKE :value')
                                ->setParameter("value", "%".$search["value"]."%")
                                ->getQuery()
                                ->getSingleScalarResult();
                }
                else {
                    $totalf= $em->getManager()->createQueryBuilder()
                                ->select('COUNT(user)')
                                ->from('App\Entity\User','user')
                                ->from('App\Entity\Niveau01', 'niveau01')
                                ->where('user.niveau01=niveau01.id')
                                ->andWhere('user.username LIKE :value OR user.firstname LIKE :value OR user.lastname LIKE :value OR user.email LIKE :value OR user.role LIKE :value OR niveau01.label LIKE :value')
                                ->setParameter("value", "%".$search["value"]."%")
                                ->getQuery()
                                ->getSingleScalarResult();
                }
            }
        }

        // Construction du tableau de retour
        $output = array(
            'draw' => $draw,
            'recordsFiltered' => $totalf,
            'recordsTotal' => $total,
            'data' => array(),
        );

        // Parcours des Enregistrement
        $qb = $em->getManager()->createQueryBuilder();
        if($access=="config") {
            if($this->isGranted('ROLE_ADMIN')) {
                $qb->select('user')->from($this->labelentity,'user')->from('App\Entity\Niveau01','niveau01');
                $qb->where('user.niveau01=niveau01.id');
            }
            elseif($this->isGranted('ROLE_MODO')) {
                $qb->select('user')->from($this->labelentity,'user')->from('App\Entity\Niveau01','niveau01')->from('App\Entity\UserModo', 'usermodo');
                $qb->where('user.niveau01=niveau01.id')
                ->andwhere("usermodo.niveau01 = user.niveau01")
                ->andWhere("usermodo.user = :userid")
                ->setParameter("userid", $usermodo);
            }
        }
        else {
            $qb->select('user')->from($this->labelentity,'user')->from('App\Entity\Niveau01','niveau01');
            $qb->where('user.niveau01=niveau01.id');
            if($fgusevisible) $qb->andWhere('user.visible=true');
        }
        
        if($search["value"]!="") {
            $qb ->andWhere('user.username LIKE :value OR user.firstname LIKE :value OR user.lastname LIKE :value OR user.email LIKE :value OR user.role LIKE :value OR niveau01.label LIKE :value')
                ->setParameter("value", "%".$search["value"]."%");
        }

        if($access=="config") {
            switch($order[0]["column"]) {
                case 2 : 
                $qb->orderBy('user.username',$order[0]["dir"]);
                break;

                case 3 : 
                $qb->orderBy('user.lastname',$order[0]["dir"]);
                break;

                case 4 : 
                $qb->orderBy('user.firstname',$order[0]["dir"]);
                break;

                case 5 : 
                $qb->orderBy('user.email',$order[0]["dir"]);
                break;

                case 6 : 
                $qb->orderBy('user.telephonenumber',$order[0]["dir"]);
                break;

                case 7 : 
                $qb->orderBy('niveau01.label',$order[0]["dir"]);
                break;

                case 10 : 
                $qb->orderBy('user.job',$order[0]["dir"]);
                break;

                case 11 : 
                $qb->orderBy('user.position',$order[0]["dir"]);
                break;

                case 12 : 
                    $qb->orderBy('user.visitedate',$order[0]["dir"]);
                break;

                case 13 : 
                $qb->orderBy('user.role',$order[0]["dir"]);
                break;
            }
        }
        else {
            switch($order[0]["column"]) {
                case 1 : 
                $qb->orderBy('user.username',$order[0]["dir"]);
                break;

                case 2 : 
                $qb->orderBy('user.lastname',$order[0]["dir"]);
                break;

                case 3 : 
                $qb->orderBy('user.firstname',$order[0]["dir"]);
                break;

                case 4 : 
                $qb->orderBy('user.email',$order[0]["dir"]);
                break;

                case 5 : 
                $qb->orderBy('user.telephonenumber',$order[0]["dir"]);
                break;

                case 6 : 
                $qb->orderBy('niveau01.label',$order[0]["dir"]);
                break;

                case 8 : 
                $qb->orderBy('user.job',$order[0]["dir"]);
                break;

                case 9 : 
                $qb->orderBy('user.position',$order[0]["dir"]);
                break;

                case 10 : 
                    $qb->orderBy('user.visitedate',$order[0]["dir"]);
                break;
    
                case 11 : 
                $qb->orderBy('user.role',$order[0]["dir"]);
                break;
            }
        }

        $datas=$qb->setFirstResult($start)->setMaxResults($length)->getQuery()->getResult();

        foreach($datas as $data) {
            // Action
            $action = "";
            if($access=="config") {
                $action.="<a href='".$this->generateUrl('app_core_config_user_update', array('id'=>$data->getId()))."' title='Modifier'><i class='fa fa-file fa-fw fa-2x'></i></a>";
                if($data->getId()>0&&$this->GetParameter("masteridentity")!="LDAP") {
                    $action.="<a href='".$this->generateUrl('app_core_config_user_delete', array('id'=>$data->getId()))."' title='Supprimer'><i class='fa fa-trash fa-fw fa-2x'></i></a>";
                }
            }

            // Groupes
            $groups="";
            foreach($data->getGroups() as $usergroup) {
                $groups.=$usergroup->getGroup()->getLabel()."<br>";
            }

            $tmp=array();
            if($access=="config") array_push($tmp,$action);
            array_push($tmp,"<img style='cursor:pointer' onClick='seeUser(".$data->getId().")' src='/".$this->getParameter('alias')."uploads/avatar/".$data->getAvatar()."' class='avatar' style='margin:auto;display:block;'>");
            array_push($tmp,$data->getUsername());
            array_push($tmp,$data->getLastname());
            array_push($tmp,$data->getFirstname());
            array_push($tmp,"<a href='mailto:".$data->getEmail()."'>".$data->getEmail()."</a>");
            array_push($tmp,$data->getTelephonenumber());
            array_push($tmp,$data->getNiveau01()->getLabel()."<br>".$data->getNiveau01other());
            if($viewniveau02) array_push($tmp,($data->getNiveau02()!==null?$data->getNiveau02()->getLabel():""));
            array_push($tmp,$groups);
            array_push($tmp,$data->getJob());
            array_push($tmp,$data->getPosition());
            array_push($tmp,($data->getVisitedate()?$data->getVisitedate()->format("d/m/Y H:i")."<br>nb = ".$data->getVisitecpt():""));
            array_push($tmp,$data->getRole());
            
            array_push($output["data"],$tmp);
        }

        // Retour
        return new Response(json_encode($output), 200);
    }    

    public function selectlist(Request $request, ManagerRegistry $em)
    {
        // S'assurer que c'est un appel ajax
        if (!$request->isXmlHttpRequest()) {
            return new JsonResponse(array('message' => 'Interdit'), 400);
        }

        $output=array();
        $page_limit=$request->query->get('page_limit');
        $q=$request->query->get('q');
        
        $qb = $em->getManager()->createQueryBuilder();
        $qb->select('table')->from("App\Entity\User",'table')
           ->where('table.username LIKE :value')
           ->setParameter("value", "%".$q."%")
           ->orderBy('table.username');
        
        $datas=$qb->setFirstResult(0)->setMaxResults($page_limit)->getQuery()->getResult();
        foreach($datas as $data) {
            array_push($output,array("id"=>$data->getId(),"text"=>$data->getUsername()));
        }

        $response = new Response(json_encode($output));    
        $response->headers->set('Content-Type', 'application/json');      
        return $response;
    }

    public function submit(Request $request, ManagerRegistry $em)
    {
        // Vérifier que l'on puisse créer
        if($this->GetParameter("masteridentity")!="SQL")
            throw $this->createNotFoundException('Permission denied');

        // Initialisation de l'enregistrement
        $data = new User();
        $data->setVisible(true);
        $data->setAuthlevel("simple");
        $data->setBelongingpopulation("agent"); 
        $data->setApikey(Uuid::uuid4());
        $fields=$this->getDefaultDatauser($em);

        // Création du formulaire
        $form = $this->createForm(UserType::class,$data,array(
            "mode"=>"submit",
            "access"=>"config",
            "perm"=>$this->isGranted('ROLE_ADMIN'),"userid"=>$this->getUser()->getId(),
            "masteridentity"=>$this->GetParameter("masteridentity"),
            "fields"=>$fields
        ));

        // Récupération des data du formulaire
        $form->handleRequest($request);
        
        // Sur erreur
        $this->getErrorForm($em,null,$form,$request,$data,"submit");
        
        // Sur validation
        if ($form->get('submit')->isClicked() && $form->isValid()) {  
            $data = $form->getData();  
            
            // On récupère le SIREN et le SIRET
            $data->setSiren($data->getNiveau01()->getSiren());
            $data->setSiret($data->getNiveau02()!==null?$data->getNiveau02()->getSiret():"");

            // On récupère les groupes et on cacule ceux à ajouter ou à supprimer
            $lstgroups=array_filter(explode(",",$form->get("linkgroups")->getData()));
            $lstmodos=array_filter(explode(",",$form->get("linkmodos")->getData()));

            // Si non modérateur vider le profil de modération
            if($data->getRole()!="ROLE_MODO") $data->setPermmodoprofil(null);
                        
            // Sauvegarde
            $em->getManager()->persist($data);
            $em->getManager()->flush();

            // On récupére l'enregistrement inséré
            $iduser=$data->getId();

            // Ajout des groupes
            foreach($lstgroups as $idgroup) {
                $group=$em->getRepository("App\Entity\Group")->find($idgroup);

                $usergroup=$em->getRepository('App\Entity\UserGroup')->findBy(["user"=>$data,"group"=>$group]);
                if(!$usergroup) {
                    $key = Uuid::uuid4();
                    $usergroup= new UserGroup();
                    $usergroup->setUser($data);
                    $datagroup = $group;
                    $usergroup->setGroup($datagroup);
                    $usergroup->setKeyvalue($key);
                    $usergroup->setRolegroup(0);
                    $em->getManager()->persist($usergroup);
                    $em->getManager()->flush();
                }

                // Notification message
                $message="Inscription de l'utilisateur<br>".$data->getLastname()." ".$data->getFirstname()."<br>Par ".$this->getUser()->getLastname()." ".$this->getUser()->getFirstname();
                $this->wss->addMessage($this->getUser()->getApikey(),$idgroup,$message);

                // Notification mail auprès de la personne inscrite
                if($group->getFgcanshare()&&$request->getSession()->get('fgnotifgroup')) {
                    $idpage =$group->getPages()->first()->getId();
                    $url = $this->generateUrl('app_core_redirect', ["route"=>"app_core_home","id"=>$idpage], UrlGeneratorInterface::ABSOLUTE_URL);
                    $subject=$request->getSession()->get('appname')." : Inscription au groupe de travail : ".$group->getLabel()."\n\n".$group->getDescription();
                    $body="Vous venez d'être inscrit dans le groupe de travail : ".$group->getLabel()."<br>Suivez le lien suivant pour y accéder = <a href='$url'>$url</a>";
                    $to = $data->getEmail();
                    $from =  $this->getParameter('noreply');
                    $fromName = $request->getSession()->get('appname');
                    $this->mail->sendEmail($subject, $body, $to, $from, $fromName); 
                }               
            }

            // Ajout des modos
            foreach($lstmodos as $idmodo) {
                $modo= new UserModo();

                $modo->setUser($data);
                $dataniveau01 = $em->getRepository("App\Entity\Niveau01")->find($idmodo);
                $modo->setNiveau01($dataniveau01);

                $em->getManager()->persist($modo);
                $em->getManager()->flush();
            }

            // Retour à la liste
            return $this->redirectToRoute($this->labelroute);
        }
        
        // Affichage du formulaire
        return $this->render($this->nameentity.'\edit.html.twig', [
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => true,               
            $this->labeldata    => $data,
            'mode'              => 'submit',
            'access'            => 'config',
            'listgroups'        => $this->getListGroups($em,"config"),
            'listmodos'         => $this->getListModos($em),
            'form'              => $form->createView()
        ]);
    }  

    public function update($id,$access,Request $request, ManagerRegistry $em)
    {
        $info = $request->query->get('info');

        // Récupération de l'enregistrement courant 
        $data=$this->getData($em,$id);
        $oldpassword=$data->getPassword();
        $fields=$this->getDefaultDatauser($em);


        // Si un acces modo via console d'admin on s'assure qu'il a les droit dessus sinon retour à la liste
        if($this->isGranted('ROLE_MODO')&&$access=="config") {
            $niveau01=$data->getNiveau01();
            $modos=$this->getUser()->getmodos(); 
            $fgperm=false;
            foreach($modos as $modo) {
                if($modo->getNiveau01()==$niveau01) $fgperm=true;
            }
            if(!$fgperm) return $this->redirectToRoute($this->labelroute);
        }

        // Récuparation des groupes associés
        $oldlstgroups=[];
        foreach($data->getGroups() as $group){
            $oldlstgroups[] = $group->getGroup()->getId();
        }

        // Récuparation des modos associés
        $oldlstmodos=[];
        foreach($data->getModos() as $modo){
            $oldlstmodos[] = $modo->getNiveau01()->getId();
        }        

        // Vérifier que cet enregistrement est modifiable
                                    
        // Création du formulaire
        $form = $this->createForm(UserType::class,$data,array(
            "mode"=>"update",
            "access"=>$access,
            "perm"=>($access=="config"?$this->isGranted('ROLE_ADMIN'):false),
            "userid"=>$this->getUser()->getId(),
            "masteridentity"=>$this->GetParameter("masteridentity"),
            "fields"=>$fields
        ));

        // Récupération des data du formulaire
        $form->handleRequest($request);
    
        // Sur erreur
        $this->getErrorForm($em,$id,$form,$request,$data,"update");
        
        // Sur validation
        if ($form->get('submit')->isClicked() && $form->isValid()) {
            $data = $form->getData();

            // Si pas de changement de password on replace l'ancien
            if($data->getPassword()=="") {
                $data->setPassword($oldpassword);    
            }
            // Sinon on encode le nouveau
            else {
                $data->setPassword($data->getPassword());
            }

            // Si non modérateur vider le profil de modération
            if($data->getRole()!="ROLE_MODO") $data->setPermmodoprofil(null);

            // Sauvegarde
            $em->getManager()->flush();


            // On récupère les groupes et on cacule ceux à ajouter ou à supprimer
            $lstgroups=array_filter(explode(",",$form->get("linkgroups")->getData()));
            $removegroups=array_diff($oldlstgroups,$lstgroups);
            $addgroups=array_diff($lstgroups,$oldlstgroups);


            // Ajout des nouveaux groupes
            foreach($addgroups as $idgroup) {
                $group=$em->getRepository("App\Entity\Group")->find($idgroup);
                
                $usergroup=$em->getRepository('App\Entity\UserGroup')->findBy(["user"=>$data,"group"=>$group]);
                if(!$usergroup) {                
                    $key = Uuid::uuid4();

                    $usergroup= new UserGroup();
                    $usergroup->setUser($data);
                    $datagroup = $group;
                    $usergroup->setGroup($datagroup);
                    $usergroup->setKeyvalue($key);
                    $usergroup->setRolegroup(0);
                    $em->getManager()->persist($usergroup);
                    $em->getManager()->flush();
                }
                
                // notification message
                $message="Inscription de l'utilisateur<br>".$data->getLastname()." ".$data->getFirstname()."<br>Par ".$this->getUser()->getLastname()." ".$this->getUser()->getFirstname();
                $this->wss->addMessage($this->getUser()->getApikey(),$idgroup,$message);

                // Notification mail auprès de la personne inscrite
                if($group->getFgcanshare()&&$request->getSession()->get('fgnotifgroup')) {
                    $idpage =$group->getPages()->first()->getId();
                    $to = $data->getEmail();
                    $from =  $this->getParameter('noreply');
                    $fromName = $request->getSession()->get('appname');
                    $url = $this->generateUrl('app_core_redirect', ["route"=>"app_core_home","id"=>$idpage], UrlGeneratorInterface::ABSOLUTE_URL);
                    $subject=$request->getSession()->get('appname')." : Inscription au groupe de travail : ".$group->getLabel()."\n\n".$group->getDescription();
                    $body="Vous venez d'être inscrit dans le groupe de travail : ".$group->getLabel()."<br>Suivez le lien suivant pour y accéder = <a href='$url'>$url</a>";
                    $this->mail->sendEmail($subject, $body, $to, $from, $fromName);       
                }                  
            }

            // Suppression des groupes obsolètes
            foreach($removegroups as $idgroup) {
                $group=$em->getRepository("App\Entity\Group")->find($idgroup);

                // Lien Group User
                $usergroups = $em   ->getManager()->createQueryBuilder()
                                    ->select('table')
                                    ->from('App\Entity\UserGroup',  'table')
                                    ->where('table.user = :user AND table.group = :group')
                                    ->setParameter('user', $id)
                                    ->setParameter('group', $idgroup)
                                    ->getQuery()
                                    ->getResult();
                foreach($usergroups as $usergroup) {
                    // Notification message
                    $message="Désinscription de l'utilisateur<br>".$data->getLastname()." ".$data->getFirstname()."<br>Par ".$this->getUser()->getLastname()." ".$this->getUser()->getFirstname();
                    $this->wss->addMessage($this->getUser()->getApikey(),$idgroup,$message);

                    // Déscription
                    $em->getManager()->remove($usergroup);
                    $em->getManager()->flush();

                    // Notification mail auprès des managers
                    if($group->getFgcanshare()&&$request->getSession()->get('fgnotifgroup')) {
                        $subject=$request->getSession()->get('appname')." : ".$data->getUsername()." = Désinscription au groupe de travail ".$group->getLabel()."\n\n".$group->getDescription();
                        $body=$data->getUsername()." a été désinscrit du groupe de travail : ".$group->getLabel();
                        $usergroups=$em->getRepository("App\Entity\Usergroup")->findBy(array("group"=>$group));
                        $to=array();
                        foreach($usergroups as $usergroup) {
                            if($usergroup->getRolegroup()>=90)
                                array_push($to,$usergroup->getUser()->getEmail());
                        }
                        $from =  $this->getParameter('noreply');
                        $fromName = $request->getSession()->get('appname');
                        $this->mail->sendEmail($subject, $body, $to, $from, $fromName);      
                    }                      
                }
            }

            // On récupère les modos et on cacule ceux à ajouter ou à supprimer
            $lstmodos=array_filter(explode(",",$form->get("linkmodos")->getData()));
            if($data->getRole()!="ROLE_MODO")
                $lstmodos=array();
            $removemodos=array_diff($oldlstmodos,$lstmodos);
            $addmodos=array_diff($lstmodos,$oldlstmodos);

            // Ajout des nouveaux modos
            foreach($addmodos as $idmodo) {
                $modo= new UserModo();

                $modo->setUser($data);
                $dataniveau01 = $em->getRepository("App\Entity\Niveau01")->find($idmodo);
                $modo->setNiveau01($dataniveau01);

                $em->getManager()->persist($modo);
                $em->getManager()->flush();
            }

            // Suppression des modos obsolètes
            foreach($removemodos as $idmodo) {
                // Lien Group User
                $usermodos = $em    ->getManager()->createQueryBuilder()
                                    ->select('table')
                                    ->from('App\Entity\UserModo',  'table')
                                    ->where('table.user = :user AND table.niveau01 = :niveau01')
                                    ->setParameter('user', $id)
                                    ->setParameter('niveau01', $idmodo)
                                    ->getQuery()
                                    ->getResult();
                foreach($usermodos as $usermodo) {
                    $em->getManager()->remove($usermodo);
                    $em->getManager()->flush();
                }
            }

            // Retour à la liste
            if($access=="config")
                return $this->redirectToRoute($this->labelroute);
            else
                return $this->redirectToRoute("app_core_home");
        }
        
       
        // Affichage du formulaire
        return $this->render($this->nameentity.'\edit.html.twig', [
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => ($access=="config"),     
            'maxwidth'          => ($access=="user"),
            $this->labeldata    => $data,
            'mode'              => 'update',
            'access'            => $access,
            'listgroups'        => $this->getListGroups($em,$access),
            'listmodos'         => $this->getListModos($em),
            'form'              => $form->createView(),
            'info'              => $info,
        ]);
    }

    public function delete($id,Request $request, ManagerRegistry $em)
    {
        // Récupération de l'enregistrement courant 
        $data=$this->getData($em,$id);
        $fields=$this->getDefaultDatauser($em);

        // Si un acces modo via console d'admin on s'assure qu'il a les droit dessus sinon retour à la liste
        if($this->isGranted('ROLE_MODO')) {
            $niveau01=$data->getNiveau01();
            $modos=$this->getUser()->getmodos(); 
            $fgperm=false;
            foreach($modos as $modo) {
                if($modo->getNiveau01()==$niveau01) $fgperm=true;
            }
            if(!$fgperm) return $this->redirectToRoute($this->labelroute);
        }

        // Vérifier que cet enregistrement est supprimable
        if($this->GetParameter("masteridentity")=="LDAP") 
            throw $this->createNotFoundException('Permission denied');

        // Alerte si utilisateur propriétaire de groupe
        if(!$data->getOwnergroups()->isEmpty()) {
            $message ="ATTENTION CET UTILSATEUR EST PROPRIETAIRE DES GROUPES DE TRAVAIL SUIVANT<br>";
            foreach($data->getOwnergroups() as $group) {
                $message.="    - <a href='".$this->generateUrl('app_core_config_group_update', array('id'=>$group->getId()))."' target='_blank'>".$group->getLabel()."</a><br>";
            }
            $message.="<br>En le supprimant les groupes en question n'auront plus de propriétaire";
            $request->getSession()->getFlashBag()->add("notice", $message);
        }

        // Création du formulaire
        $form = $this->createForm(UserType::class,$data,array(
            "mode"=>"delete",
            "access"=>"config",
            "perm"=>false,
            "userid"=>$this->getUser()->getId(),
            "masteridentity"=>$this->GetParameter("masteridentity"),
            "fields"=>$fields
        ));

        // Récupération des data du formulaire
        $form->handleRequest($request);        

        // Sur erreur
        $this->getErrorForm($em,$id,$form,$request,$data,"delete");
                
        // Sur validation
        if ($form->get('submit')->isClicked() && $form->isValid()) {
            // Avant de supprimer l'utilisateur on passe à vide l'ensemble des groupes propriétaire à vide
            foreach($data->getOwnergroups() as $group) {
                $pages=$group->getPages();
                foreach($pages as $page) {
                    $page->setUser(null);
                    $em->getManager()->flush();
                }

                $blogs=$group->getBlogs();
                foreach($blogs as $blog) {
                    $blog->setUser(null);
                    $em->getManager()->flush();
                }

                $calendars=$group->getCalendars();
                foreach($calendars as $calendar) {
                    $calendar->setUser(null);
                    $em->getManager()->flush();
                }

                $projects=$group->getProjects();
                foreach($projects as $project) {
                    $project->setUser(null);
                    $em->getManager()->flush();
                }
            }

            $em->getManager()->remove($data);
            $em->getManager()->flush();
            
            return $this->redirectToRoute($this->labelroute);
        }
        
        // Affichage du formulaire
        return $this->render($this->nameentity.'\edit.html.twig', [
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => true,               
            $this->labeldata    => $data,
            'mode'              => 'delete',
            'access'            => 'config',
            'listgroups'        => $this->getListGroups($em,"config"),
            'listmodos'         => $this->getListModos($em),
            'form'              => $form->createView()
        ]);                    
    }

    public function sync(Request $request, ManagerRegistry $em)
    {
        $application = new Application($this->appKernel);
        $application->setAutoExit(false);
        $command = $application->find('app:Synchro');

        $parameter = new ArrayInput(['simulate' => 'false']);

        $output = new BufferedOutput(OutputInterface::VERBOSITY_NORMAL,false);
        $command->run($parameter, $output);
        $content = $output->fetch();

        return $this->render('Cron\command.html.twig', [
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => true,               
            "title"             =>"Synchronisation avec Annuaire",
            "return_path"       =>"app_core_config_user",
            "content"           =>$content
        ]);
    }

    public function profil(Request $request, ManagerRegistry $em)
    {    
        $user = $this->getUser();
        return $this->update($user->getId(),"user",$request,$em);
    }

    public function view($id, Request $request, ManagerRegistry $em) 
    {
        $user=$this->getData($em,$id);
        $fields=$this->getDefaultDatausers($em,$request);

        return $this->render($this->nameentity.'\view.html.twig', [
            'useheader'         => false,
            'usemenu'           => false,
            'usesidebar'        => false,               
            'user'              => $user,
            'fields'            => $fields,

        ]);        
    }

    
    public function mailing(Request $request, ManagerRegistry $em) {
        $form = $this->createForm(MailingType::class,$this->getUser(),array(
            "perm"=>$this->isGranted('ROLE_ADMIN'),
            "userid"=>$this->getUser()->getId(),
        ));

        // Récupération des data du formulaire
        $form->handleRequest($request);
    
        // Error si pas de message
        if ($form->get('submit')->isClicked()) {
            if(!$form->get('message')->getData()) {
                $form->addError(new FormError("Merci de renseigner un message à votre mail")); 
                $errors = $form->getErrors();
                foreach( $errors as $error ) {
                    $request->getSession()->getFlashBag()->add("error", $error->getMessage());
                }
            }
        }

        // Sur validation
        if ($form->get('submit')->isClicked() && $form->isValid()) {
            $users=[];
            if($this->isGranted('ROLE_ADMIN')) {
                $groups=$form->get('groups')->getData();
                foreach($groups as $group) {
                    foreach($group->getUsers() as $usergroup) {
                        if(!in_array($usergroup->getUser()->getEmail(),$users)) {
                            array_push($users,$usergroup->getUser()->getEmail());
                        }
                    }
                }
            }
            $niveau01s=$form->get('niveau01')->getData();
            foreach($niveau01s as $niveau01) {
                foreach($niveau01->getUsers() as $user) {
                    if(!in_array($user->getEmail(),$users)) {
                        array_push($users,$user->getEmail());
                    }
                }
            }

            $text=$form->get("message")->getData();
            $subject=$form->get("subject")->getData();
            $body=nl2br($text);
            $from =  $this->getParameter('noreply');
            $fromName = $this->getUser()->getFirstname()." ".$this->getUser()->getLastname();
            foreach($users as $to) {
                $this->mail->sendEmail($subject, $body, $to, $from, $fromName);
            }

            return $this->redirectToRoute("app_core_config");
        }

        return $this->render('Mail\mailing.html.twig', [
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => true,
            'form'              => $form->createView()
        ]);        
    }
    
    public function exportuser(Request $request, ManagerRegistry $em) {
        $dir    = $this->appKernel->getProjectDir().'/uploads/export/';
        $file   = "exportuser.csv";

        $fs = new Filesystem();
        $fs->mkdir($dir);

        $csvh = fopen($dir.$file, 'w');
        $d = ';'; // this is the default but i like to be explicit
        $e = '"'; // this is the default but i like to be explicit

        // Entête de colonne     
        $data=["id","Login","Nom","Prénom","Email","Téléphone",$this->getParameter("labelniveau01"),$this->getParameter("labelniveau02"),"Métier","Fonction","Nom Usage","Autres Prénom","Sexe","Adresse","Date Naissance","Pays Naissance","Ville Naissance","Date Visite","Cpt Visite","Groupes"];
        fputcsv($csvh, $data, $d, $e);

        // Liste des utilisateurs en fonction du role de l'utilisateur en cours
        if($this->isGranted('ROLE_ADMIN')) {
            $users=$em->getRepository($this->labelentity)->findAll();
        }
        elseif($this->isGranted('ROLE_MODO')) {
            $qb = $em->getManager()->createQueryBuilder();
            $users = $qb->select('user')
                    ->from($this->labelentity,'user')
                    ->from('App\Entity\Niveau01','niveau01')
                    ->from('App\Entity\UserModo', 'usermodo')
                    ->where('user.niveau01=niveau01.id')
                    ->andwhere("usermodo.niveau01 = user.niveau01")
                    ->andWhere("usermodo.user = :userid")
                    ->setParameter("userid", $this->getUser()->getId())
                    ->getQuery()
                    ->getResult();
        }        
        
        foreach($users as $user) {
            $groups="";
            $fgfirst=true;
            foreach($user->getGroups() as $key => $usergroup) {
                if(!$fgfirst) $groups.=" - ";
                $groups.=$usergroup->getGroup()->getLabel();
                if($fgfirst) $fgfirst=false;
            }

            $visite = ($user->getVisitedate()?$user->getVisitedate()->format("d/m/Y H:i"):"");
            $cptvisite = ($user->getVisitedate()?$user->getVisitecpt():"");

            $data = [
                "id"=>$user->getId(),
                "username"=>$user->getUsername(),
                "name"=>$user->getLastname(),
                "firstname"=>$user->getFirstname(),
                "email"=>$user->getEmail(),
                "phone"=>$user->getTelephonenumber(),
                "niveau01"=>$user->getNiveau01()->getLabel(),
                "niveau02"=>($user->getNiveau02()?$user->getNiveau02()->getLabel():""),
                "job"=>$user->getJob(),
                "position"=>$user->getPosition(),
                "usualname"=>$user->getUsualname(),
                "givensname"=>$user->getGivensname(),
                "gender"=>$user->getGender(),
                "postaladress"=>$user->getPostaladress(),
                "birthdate"=>($user->getBirthdate()?$user->getBirthdate()->format("d/m/Y"):""),
                "birthcountry"=>($user->getBirthcountry()?$user->getBirthcountry()->getLabel():""),
                "birthplace"=>($user->getBirthplace()?$user->getBirthplace()->getLabel():""),
                "visite"=>$visite,
                "cptvisite"=>$cptvisite,
                "groups"=>$groups,

            ];

            fputcsv($csvh, $data, $d, $e);
        }
        fclose($csvh);        

        $response = new BinaryFileResponse($dir.$file);
        $response->setContentDisposition(ResponseHeaderBag::DISPOSITION_ATTACHMENT);
        
        return $response;
    }

    public function importuser(Request $request, ManagerRegistry $em) {
        if($this->GetParameter("masteridentity")!="SQL")
            throw $this->createNotFoundException('Permission denied');

        return $this->render($this->nameentity.'\import.html.twig',[
            'useheader'     => true,
            'usemenu'       => false,
            'usesidebar'    => true,
        ]);
    }

    public function importuserfile(ManagerRegistry $em)
    {
        return $this->render($this->nameentity.'\importfile.html.twig',[
            'useheader'     => false,
            'usemenu'       => false,
            'usesidebar'    => false,
        ]);
    }

    public function importuserfilectrl(Request $request, ManagerRegistry $em)
    {
        // S'assurer que c'est un appel ajax
        if (!$request->isXmlHttpRequest()) return new JsonResponse(array('message' => 'Interdit'), 400);

        $output=array();
        $file = $request->request->get('file');

        $csv    = file_get_contents($this->appKernel->getProjectDir()."/".$file);
        
        $tbfile = $this->csv_to_array($csv);
        $error="";
        if(empty($tbfile)||!$tbfile[0]) 
            $error.="<p>Votre fichier CSV est mal formé, merci de le corriger<p>";
        else {
            // On s'assure que les données minimums sont présentes en colonne
            if(!array_key_exists("login",$tbfile[0]))       $error.="<p>Colonne login manquante</p>";
            if(!array_key_exists("nom",$tbfile[0]))         $error.="<p>Colonne nom manquante</p>";
            if(!array_key_exists("email",$tbfile[0]))       $error.="<p>Colonne email manquante</p>";
            if(!array_key_exists("niveau01",$tbfile[0]))    $error.="<p>Colonne niveau01 manquante</p>";

            // On s'assure que toutes les colonnes sont des colonnes gérées par l'import
            $tbkey=["login","prenom","nom","email","niveau01","niveau02","metier","fonction","nomusage","sexe","autreprenom","telephone","adresse","datenaissance","pays","ville","visible","role"];
            foreach($tbfile[0] as $key => $value) {
                if(!in_array($key,$tbkey))
                    $error.="<p>La colonne $key n'est pas une colonne gérée par l'import</p>";
            }

            // On vérifie les données
            foreach($tbfile as $user) {
                // On regarde si le login n'est pas déjà existant
                $userbdd=$em->getRepository('App\Entity\User')->findOneBy(["username"=>$user["login"]]);
                if($userbdd) {
                    $error.="<p>Utilisateur = ".$user["login"]." existe déjà</p>";
                }

                // On s'assure que le login n'est pas trop court
                if(strlen($user["login"])<5)
                    $error.="<p>Utilisateur = ".$user["login"]." login trop court doit être >= 5</p>";
            
                // On s'assure que le username ne contient pas des caractères speciaux
                $string = preg_replace('~[^@a-zA-Z0-9._-]~', '', $user["login"]);
                if($string!=$user["login"])
                    $error.="<p>Utilisateur = ".$user["login"]." login avec caractères invalide</p>";

                // On regarde si le email n'est pas déjà existant
                $userbdd=$em->getRepository('App\Entity\User')->findOneBy(["email"=>$user["email"]]);
                if($userbdd) {
                    $error.="<p>Email = ".$user["email"]." existe déjà</p>";
                }                

                // On regarde si le login / mail / nom n'est pas vide
                if($user["login"]==""||$user["nom"]==""||$user["email"]=="")
                    $error.="<p>Valeur obligatoire pour login / nom / email</p>";


                // On regarde si le niveau01 existe
                $niveau01=$em->getRepository('App\Entity\Niveau01')->findOneBy(["label"=>$user["niveau01"]]);
                if(!$niveau01) $error.="<p>Niveau 01 = ".$user["niveau01"]." inexistant</p>";

                // On regarde si le niveau02 existe
                if(array_key_exists("niveau02",$user)&&$user["niveau02"]!="") {
                    $niveau02=$em->getRepository('App\Entity\Niveau02')->findOneBy(["label"=>$user["niveau02"],"niveau01"=>$niveau01]);
                    if(!$niveau02) $error.="<p>Niveau 02 = ".$user["niveau02"]." inexistant</p>";
                }

                // On regarde si le sexe est correctement formatté
                if(array_key_exists("sexe",$user)&&$user["sexe"]!="") {
                    if($user["sexe"]!="male"&&$user["sexe"]!="female")
                        $error.="<p>Sexe ne peut prendre que la valeur vide / male / female</p>";
                }

                // On regarde si la date de naissance est correctement formatté
                if(array_key_exists("datenaissance",$user)&&$user["datenaissance"]!="") {
                    try {
                        $date = \DateTime::createFromFormat('d/m/Y', $user["datenaissance"]);
                        if(!$date) $error.="<p>Date de naissance mal formattée</p>";    
                    }
                    catch (Exception $e) {
                        $error.="<p>Date de naissance mal formattée</p>";
                    }
                }

                // On regarde si la pays existe
                if(array_key_exists("pays",$user)&&$user["pays"]!="") {
                    $country=$em->getRepository('App\Entity\Country')->findOneBy(["label"=>$user["pays"]]);
                    if(!$country) $error.="<p>Pays = ".$user["pays"]." inexistant</p>";
                }

                // On regarde si la ville existe
                if(array_key_exists("ville",$user)&&$user["ville"]!="") {
                    $city=$em->getRepository('App\Entity\City')->findOneBy(["label"=>$user["ville"]]);
                    if(!$city) $error.="<p>Ville = ".$user["ville"]." inexistant</p>";
                }                

                // On regarde si visible est correctement formatté
                if(array_key_exists("visible",$user)&&$user["visible"]!="") {
                    if($user["visible"]!="oui"&&$user["sexe"]!="non")
                        $error.="<p>Visible ne peut prendre que la valeur vide / oui / non</p>";
                }

                // On regarde si visible est correctement formatté
                if(array_key_exists("role",$user)&&$user["role"]!="") {
                    if($user["role"]!="ROLE_ADMIN"&&$user["role"]!="ROLE_MODO"&&$user["role"]!="ROLE_USER")
                        $error.="<p>Role ne peut prendre que la valeur vide / ROLE_ADMIN / ROLE_MODO / ROLE_USER</p>";
                }
            }
        }

        if($error!="") {
            $output["status"]="KO";
            $output["error"]=$error;
        }
        else {
            $output["status"]   ="OK";
            $output["users"]    ="";

            $appname = $request->getSession()->get('appname');
            $noreply = $this->getParameter('noreply');

            // On importe
            foreach($tbfile as $csvuser) {
                $output["users"].="Création Utilisateur = ".$csvuser["login"]."<br>";

                $user               = new User();
                $username           = $csvuser["login"];
                $password           = Uuid::uuid4();
                $apikey             = Uuid::uuid4();
                $email              = $csvuser["email"];
                $lastname           = $csvuser["nom"];
                $firstname          = (array_key_exists("prenom",$csvuser)?$csvuser["prenom"]:null);
                $niveau01           = $em->getRepository('App\Entity\Niveau01')->findOneBy(["label"=>$csvuser["niveau01"]]);
                $niveau02           = (array_key_exists("niveau02",$csvuser)?$em->getRepository('App\Entity\Niveau02')->findOneBy(["label"=>$csvuser["niveau02"]]):null);
                $job                = (array_key_exists("metier",$csvuser)?$csvuser["metier"]:null);
                $position           = (array_key_exists("fonction",$csvuser)?$csvuser["fonction"]:null);
                $usalname           = (array_key_exists("nomusage",$csvuser)?$csvuser["nomusage"]:null);
                $gender             = (array_key_exists("sexe",$csvuser)?$csvuser["sexe"]:null);
                $givensname         = (array_key_exists("autreprenom",$csvuser)?$csvuser["autreprenom"]:null);
                $telephonenumber    = (array_key_exists("telephone",$csvuser)?$csvuser["telephone"]:null);
                $postaladress       = (array_key_exists("adresse",$csvuser)?$csvuser["adresse"]:null);
                $birthdate          = (array_key_exists("datenaissance",$csvuser)&&$csvuser["datenaissance"]!=""?$csvuser["datenaissance"]:null);
                $birthdate          = (!is_null($birthdate)?\DateTime::createFromFormat('d/m/Y', $csvuser["datenaissance"]):null);
                $birthcountry       = (array_key_exists("pays",$csvuser)?$em->getRepository('App\Entity\Country')->findOneBy(["label"=>$csvuser["pays"]]):null);
                $birthplace         = (array_key_exists("ville",$csvuser)?$em->getRepository('App\Entity\City')->findOneBy(["label"=>$csvuser["ville"]]):null);
                $visible            = (array_key_exists("visible",$csvuser)&&$csvuser["visible"]!=""?($csvuser["visible"]=="oui"):true);
                $role               = (array_key_exists("role",$csvuser)&&$csvuser["role"]!=""?$csvuser["role"]:"ROLE_USER");

                $user->setUsername($username);
                $user->setPassword($password);
                $user->setApikey($apikey);
                $user->setEmail($email);
                $user->setLastname($lastname);
                $user->setFirstname($firstname);
                $user->setNiveau01($niveau01);
                $user->setNiveau02($niveau02);
                $user->setJob($job);
                $user->setPosition($position);
                $user->setUsualname($usalname);
                $user->setGender($gender);
                $user->setGivensname($givensname);
                $user->setTelephonenumber($telephonenumber);
                $user->setPostaladress($postaladress);
                $user->setBirthdate($birthdate);
                $user->setBirthcountry($birthcountry);
                $user->setBirthplace($birthplace);
                $user->setVisible($visible);
                $user->setRole($role);

                $user->setSiren($niveau01->getSiren());
                $user->setSiret((!is_null($niveau02)?$niveau02->getSiret():null));
                $user->setAuthlevel("simple");
                $user->setBelongingpopulation("agent");

                $em->getManager()->persist($user);
                $em->getManager()->flush();
                
                // Email à destination de l'inscrit pour le prévenir qu'il dispose d'un compte
                $url = $this->generateUrl('app_core_resetpwd01', [], UrlGeneratorInterface::ABSOLUTE_URL);
                $subject=$appname." : Inscription automatique";
                $body ="Vous venez d'être inscrit au portail = ".$appname."<br><br>";
                $body.="Login = ".$username."<br>";
                $body.="Password = Merci de suivre le lien suivant pour définir votre password<br><br>";
                $body=$body."<a href='$url'>$url</a>";
                $to = $email;
                $from =  $noreply;
                $fromName = $appname;
                $this->mail->sendEmail($subject, $body, $to, $from, $fromName);                   
            }
        }

        $response = new Response(json_encode($output));    
        $response->headers->set('Content-Type', 'application/json');        
        return $response;         
    }

    public function viewcalendarAction (Request $request, ManagerRegistry $em)
    {
        // S'assurer que c'est un appel ajax
        if (!$request->isXmlHttpRequest()) {
            return new JsonResponse(array('message' => 'Interdit'), 400);
        }
        
        $user=$this->getUser();
        if($user) {
            $view=$request->request->get('view');
            $idview=1;
            if($view=="month") $idview=1;
            if($view=="agendaWeek") $idview=2;
            if($view=="agendaDay") $idview=3;

            $user->setViewcalendar($idview);
            $em->getManager()->flush();            
        }

        return new Response();
    }

    public function preference(Request $request, ManagerRegistry $em) {
        // S'assurer que c'est un appel ajax
        if (!$request->isXmlHttpRequest()) {
            return new JsonResponse(array('message' => 'Interdit'), 400);
        }

        $key=$request->request->get('key');
        $id=$request->request->get('id');
        $value=$request->request->get('value');
        
        // Récupérer les préférences de l'utilisateur
        $preference=$this->getUser()->getPreference();

        // Cas particulier de page bookmark, on vide la préférence si on reset la meme valeur
        if($key=="pagebookmark") {
            if(is_array($preference)&&array_key_exists("pagebookmark",$preference)) {
                $oldid=$preference["pagebookmark"][0];
                if($oldid==$value) {
                    unset($preference["pagebookmark"]);
                    $this->getUser()->setPreference($preference);
                    $request->getSession()->set("pagebookmark", "");
                    $em->getManager()->flush();   
                    return new Response();             
                }
            }            
        }

        // Mise à jour de la préférence
        $toupdate=false;
        if(!is_array($preference)) {
            $toupdate=true;
            $preference=[];
        }

        if(!array_key_exists($key,$preference)) {
            $toupdate=true;
            $preference[$key]=[];
        }
        if((!array_key_exists($id,$preference[$key]))) {
            $toupdate=true;
            $preference[$key][$id]=$value;
        }
        if($preference[$key][$id]!=$value) {
            $toupdate=true;
            $preference[$key][$id]=$value;            
        }        

        // Mise à jour des préferences
        if($toupdate) {
            $this->getUser()->setPreference($preference);
            $em->getManager()->flush();             
        }
        
        return new Response();
    }

    protected function getDatas($em)
    {
        $datas = $em->getRepository($this->labelentity)->findAll();
        return $datas;
    } 
            
    protected function getData($em,$id)
    {
        $data = $em->getRepository($this->labelentity)->find($id);

        if (!$data) {
            throw $this->createNotFoundException('Unable to find '.$this->labeldata);
        }

        return $data;
    } 

    protected function getRegistrationBy($em,$key,$value)
    {
        $datas = $em->getManager()->createQueryBuilder()
                      ->select('u')
                      ->from('App\Entity\registration',  'u')
                      ->where('u.'.$key.'=:value')
                      ->getQuery()->setParameter("value", $value)
                      ->getResult();
        if (!$datas) return false;
        else return true;
    }

    protected function getListGroups($em,$access)
    {
        $qb=$em->getManager()->createQueryBuilder();
        $qb->select('b')->from('App\Entity\Group','b');
        if($access!="config")
            $qb->where("b.fgopen=true");
        $qb->andWhere("b.ldapfilter IS NULL");
        $qb->andWhere("b.attributes IS NULL");
        $datas=$qb->getQuery()->getResult();

        return $datas;
    }

    protected function getListModos($em)
    {
        $qb=$em->getManager()->createQueryBuilder();
        $qb->select('b')->from('App\Entity\Niveau01','b');
        $datas=$qb->getQuery()->getResult();
        return $datas;
    }

    protected function getDefaultDatauser($em) 
    {
        $config=$em->getRepository('App\Entity\Config')->find("datauser");
        $fields=$config->getValue();
        $fields=json_decode($fields,true);
        if(!is_array($fields)) $fields=[];

        // Valeur par défaut 0=caché / 1=falcultatif / 2=obligatoire
        if(!array_key_exists("firstname",$fields)) {
            $fields["firstname"]["perm"]=1;
            $fields["firstname"]["label"]="Prénom";
        }            

        if(!array_key_exists("visible",$fields)) {
            $fields["visible"]["perm"]=2;
            $fields["visible"]["label"]="Visible";
        }   

        if(!array_key_exists("authlevel",$fields)) {
            $fields["authlevel"]["perm"]=2;
            $fields["authlevel"]["label"]="Niveau d'authentification";
        }   

        if(!array_key_exists("belongingpopulation",$fields)) {
            $fields["belongingpopulation"]["perm"]=2;
            $fields["belongingpopulation"]["label"]="Population d'appartenance";
        }   

        if(!array_key_exists("job",$fields)) {
            $fields["job"]["perm"]=1;
            $fields["job"]["label"]="Métier";
        }   

        if(!array_key_exists("position",$fields)) {
            $fields["position"]["perm"]=1;
            $fields["position"]["label"]="Fonction";
        }   

        if(!array_key_exists("niveau02",$fields)) {
            $fields["niveau02"]["perm"]=1;
            $fields["niveau02"]["label"]="Niveau 02";
        }   

        if(!array_key_exists("usualname",$fields)) {
            $fields["usualname"]["perm"]=1;
            $fields["usualname"]["label"]="Nom d'Usage";
        }   

        if(!array_key_exists("gender",$fields)) {
            $fields["gender"]["perm"]=1;
            $fields["gender"]["label"]="Sexe";
        }   

        if(!array_key_exists("givensname",$fields)) {
            $fields["givensname"]["perm"]=1;
            $fields["givensname"]["label"]="Autre Prénom";
        }   

        if(!array_key_exists("telephonenumber",$fields)) {
            $fields["telephonenumber"]["perm"]=1;
            $fields["telephonenumber"]["label"]="Téléphone";
        }   

        if(!array_key_exists("postaladress",$fields)) {
            $fields["postaladress"]["perm"]=1;
            $fields["postaladress"]["label"]="Adresse";
        }   

        if(!array_key_exists("birthdate",$fields)) {
            $fields["birthdate"]["perm"]=1;
            $fields["birthdate"]["label"]="Date de Naissance";
        }   

        if(!array_key_exists("birthcountry",$fields)) {
            $fields["birthcountry"]["perm"]=1;
            $fields["birthcountry"]["label"]="Pays de Naissance";
        }   

        if(!array_key_exists("birthplace",$fields)) {
            $fields["birthplace"]["perm"]=1;
            $fields["birthplace"]["label"]="Ville de Naissance";
        }   
        
        if(!array_key_exists("visite",$fields)) {
            $fields["visite"]["perm"]=1;
            $fields["visite"]["label"]="Visite";
        }  
        
        
        return $fields;
    }

    protected function getDefaultDatausers($em,$request)
    {      
        $session=$request->getSession();
        $config=$em->getRepository('App\Entity\Config')->find("datausers");
        $fields=$config->getValue();

        $fields=json_decode($fields, true);
        if(!is_array($fields)) $fields=[];
        
        // Valeur par défaut 0=caché / 3=visible
        if(!array_key_exists("avatar",$fields)) {
            $fields["avatar"]["perm"]=1;
            $fields["avatar"]["label"]="Avatar";
        }
        if(!array_key_exists("login",$fields)) {
            $fields["login"]["perm"]=1;
            $fields["login"]["label"]="Login";
        }
        if(!array_key_exists("lastname",$fields)) {
            $fields["lastname"]["perm"]=1;
            $fields["lastname"]["label"]="Nom";
        }
        if(!array_key_exists("firstname",$fields)) {
            $fields["firstname"]["perm"]=1;
            $fields["firstname"]["label"]="Prenom";
        }
        if(!array_key_exists("email",$fields)) {
            $fields["email"]["perm"]=1;
            $fields["email"]["label"]="Email";
        }
        if(!array_key_exists("niveau01",$fields)) {
            $fields["niveau01"]["perm"]=1;
            $fields["niveau01"]["label"]=$session->get('labelniveau01');
        }   
        if(!array_key_exists("niveau02",$fields)) {
            $fields["niveau02"]["perm"]=1;
            $fields["niveau02"]["label"]=$session->get('labelniveau02');
        }
        if(!array_key_exists("group",$fields)) $fields["group"]["perm"]=1;
        $fields["group"]["label"]="Groupes (caché uniquement pour le rôle Utilisateur) ";

        if(!array_key_exists("job",$fields)) {
            $fields["job"]["perm"]=1;
            $fields["job"]["label"]="Métier";
        }
        if(!array_key_exists("position",$fields)) {
            $fields["position"]["perm"]=1;
            $fields["position"]["label"]="Fonction";
        }   
        if(!array_key_exists("role",$fields)) {
            $fields["role"]["perm"]=1;
            $fields["role"]["label"]="Rôles";
        }
        if(!array_key_exists("telephonenumber",$fields)) {
            $fields["telephonenumber"]["perm"]=1;
            $fields["telephonenumber"]["label"]="Téléphone";            
        }
        if(!array_key_exists("visitedate",$fields)) $fields["visitedate"]["perm"]=1;
        $fields["visitedate"]["label"]="Visite (caché uniquement pour les rôles Animateur et Utilisateur) ";

        if(!$session->get('viewniveau02'))
            unset($fields["niveau02"]);

        return $fields;
    }

    protected function getErrorForm($em,$id,$form,$request,$data,$mode) {
        if ($form->get('submit')->isClicked()&&$mode=="delete") {
        }

        if ($form->get('submit')->isClicked() && ($mode=="submit" || $mode=="update")) {
            // Taille du login > 5
            if (is_null($data->getUsername()) || strlen($data->getUsername()) < '5') {
                $form->addError(new FormError('Taille minimum du login 5 caractères'));
            }

            // On s'assure que le username ne contient pas des caractères speciaux
            $string = preg_replace('~[^@a-zA-Z0-9._-]~', '', $data->getUsername());
            if($string!=$data->getUsername())
            {
                $form->addError(new FormError('Caractères interdit dans votre login'));
            }
                        
            // On s'assure que le username et le mail n'existe pas dans la table des users
            if($this->getRegistrationBy($em,"username",$data->getUsername())||$this->getRegistrationBy($em,"email",$data->getEmail())) {
                $form->addError(new FormError('Une inscription utilise déjà ce login ou cet email'));
            }

            // On s'assure que les modérateurs aient un profil de modération
            if($data->getRole()=="ROLE_MODO"&&!$data->getPermmodoprofil()) {
                $form->addError(new FormError('Vous devez préciser un profil de modération'));
            }

            // Si niveau01 commence par autre = niveau01other obligatoire
            $niveau01=strtolower($data->getNiveau01()->getLabel());
            if(stripos($niveau01,"autre")===0) {
                if(!$data->getNiveau01other()) {
                    $form->addError(new FormError("Merci de compléter le champ 'Autre ".$this->getParameter("labelniveau01")."'")); 
                }
            }
        }

      

        if ($form->get('submit')->isClicked() && !$form->isValid()) {
            $errors = $form->getErrors();
            foreach( $errors as $error ) {
                $request->getSession()->getFlashBag()->add("error", $error->getMessage());
            }
        }
    }  

    protected function csv_to_array($csv, $delimiter = ';', $enclosure = '', $escape = '\\', $terminator = "\n") { 
        $r = array(); 
        $rows = explode($terminator,trim($csv)); 

        $names = array_shift($rows); 
        $names = str_getcsv($names,$delimiter,$enclosure,$escape); 
        $nc = count($names); 
        foreach ($rows as $row) { 
            if (trim($row)) { 
                $values = str_getcsv($row,$delimiter,$enclosure,$escape); 
                if (!$values) $values = array_fill(0,$nc,null); 
                @$r[] = array_combine($names,$values); 
            } 
        } 
        return $r; 
    }       
}
