<?php
namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;

use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @ORM\Entity
 * @ORM\Table(name="usergroupe",uniqueConstraints={@ORM\UniqueConstraint(columns={"user_id", "group_id"})})
 * @ORM\HasLifecycleCallbacks()
 *
 * @UniqueEntity(fields={"user", "group"}, message="Cette liaison existe déjà !")
 */
class UserGroup
{
    /**
     * @ORM\Column(type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity="User", inversedBy="groups")
     * @ORM\JoinColumn(name="user_id", referencedColumnName="id", nullable=false)
     */
    private $user;

    /**
     * @ORM\ManyToOne(targetEntity="Group", inversedBy="users")
     * @ORM\JoinColumn(name="group_id", referencedColumnName="id", nullable=false)
     */
    private $group;

    /**
     * @ORM\Column(type="boolean", options={"default" : false})
     * CE CHAMP N'EST PLUS UTILSE
     */
    private $fgmanager = false;        

    /**
     * @ORM\Column(type="integer", length=60, nullable=true)
     */
    private $rolegroup;        

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     */
    private $keyvalue;   

    /**
     * @ORM\Column(type="datetime", nullable=true)
     */
    private $visitedate;

    /**
     * @ORM\Column(type="integer", nullable=true)
     */
    private $visitecpt;
        
    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set user
     *
     * @param User $user
     *
     * @return UserGroup
     */
    public function setUser(User $user)
    {
        $this->user = $user;

        return $this;
    }

    /**
     * Get user
     *
     * @return User
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * Set group
     *
     * @param Group $group
     *
     * @return UserGroup
     */
    public function setGroup(Group $group)
    {
        $this->group = $group;

        return $this;
    }

    /**
     * Get group
     *
     * @return Group
     */
    public function getGroup()
    {
        return $this->group;
    }

    /**
     * Set fgmanager
     *
     * @param boolean $fgmanager
     *
     * @return UserGroup
     */
    public function setFgmanager($fgmanager)
    {
        $this->fgmanager = $fgmanager;

        return $this;
    }

    /**
     * Get fgmanager
     *
     * @return boolean
     */
    public function getFgmanager()
    {
        return $this->fgmanager;
    }

    /**
     * Set keyvalue
     *
     * @param string $keyvalue
     *
     * @return UserGroup
     */
    public function setKeyvalue($keyvalue)
    {
        $this->keyvalue = $keyvalue;

        return $this;
    }

    /**
     * Get keyvalue
     *
     * @return string
     */
    public function getKeyvalue()
    {
        return $this->keyvalue;
    }

    /**
     * Set visitedate
     *
     * @param \DateTime $visitedate
     *
     * @return UserGroup
     */
    public function setVisitedate($visitedate)
    {
        $this->visitedate = $visitedate;

        return $this;
    }

    /**
     * Get visitedate
     *
     * @return \DateTime
     */
    public function getVisitedate()
    {
        return $this->visitedate;
    }

    /**
     * Set visitecpt
     *
     * @param integer $visitecpt
     *
     * @return UserGroup
     */
    public function setVisitecpt($visitecpt)
    {
        $this->visitecpt = $visitecpt;

        return $this;
    }

    /**
     * Get visitecpt
     *
     * @return integer
     */
    public function getVisitecpt()
    {
        return $this->visitecpt;
    }

    /**
     * Set rolegroup
     *
     * @param integer $rolegroup
     *
     * @return UserGroup
     */
    public function setRolegroup($rolegroup)
    {
        $this->rolegroup = $rolegroup;

        return $this;
    }

    /**
     * Get rolegroup
     *
     * @return integer
     */
    public function getRolegroup()
    {
        return $this->rolegroup;
    }
}
