<?php

namespace App\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use FOS\CKEditorBundle\Form\Type\CKEditorType;
use Tetranz\Select2EntityBundle\Form\Type\Select2EntityType;
use Symfony\Component\OptionsResolver\OptionsResolver;
use App\Formtype\IconChoiceType;

class PageUpdateEditorType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('submit', SubmitType::class, [
                "label"         => ($options["mode"]=="delete"?"Confirmer la Suppression":"Valider"),
                "attr"          => ($options["mode"]=="delete"?array("class" => "btn btn-danger"):array("class" => "btn btn-success"))
            ])    

            ->add('name', TextType::class, [
                'label'         => 'Nom'
            ])  

            ->add('roworder', IntegerType::class, [
                'label'         => 'Ordre'
            ])                

            ->add('fonticon', IconChoiceType::class, [
                'label' => 'Icône',
                'required' => false,
            ])

            ->add('maxwidth', IntegerType::class, [
                'label'         => "Largeur maximum (0 pour largeur de l'écran)",
            ])
                        
            ->add("html",CKEditorType::class,[
                "config_name"   => 'full_config',
                "label"         => 'Description',
                "required"      => false,
                "disabled"      => ($options["mode"]=="delete"?true:false),
                "config"        => array("height" => "500px",'filebrowserUploadRoute' => 'app_portal_'.$options["access"].'_page_upload')
            ]);

            if($options["access"]=="config") {
                $builder
                    ->add('roles', ChoiceType::class, [
                        "label"         => 'Visible pour les Rôles',
                        "choices" => [
                            "Visiteur"              => 'ROLE_ANONYME',
                            "Utilisateur"           => 'ROLE_USER',
                            "Animateur de Groupe"   => 'ROLE_ANIM',
                            "Modérateur"            => 'ROLE_MODO',
                            "Administateur"         => 'ROLE_ADMIN',
                        ],                
                        "multiple"      => true,
                        "expanded"      => true,
                        "disabled"      => ($options["mode"]=="delete"?true:false),
                    ])

                    ->add('groups', Select2EntityType::class, [
                        'label'                 => 'Visible pour les Groupes',
                        'class'                 => 'App\Entity\Group',
                        'text_property'         => 'label',
                        'multiple'              => true,
                        'remote_route'          => 'app_core_ajax_group_list',
                        'primary_key'           => 'id',
                        'text_property'         => 'label',
                        'minimum_input_length'  => 0,
                        'page_limit'            => 100,
                        'allow_clear'           => true,
                        'delay'                 => 250,
                        'cache'                 => false,
                        'cache_timeout'         => 60000,
                        'language'              => 'fr',
                        'placeholder'           => 'Selectionner un groupe',                        
                    ])
                    
                    ->add('user', Select2EntityType::class, [
                        'label' => "Propriétaire",
                        'disabled' => ($options["mode"]=="delete"?true:false),
                        "required"    => false,
                        'multiple' => false,
                        'remote_route' => 'app_core_config_user_ajax_selectlist',
                        'class' => 'App\Entity\User',
                        'primary_key' => 'id',
                        'text_property' => 'username',
                        'minimum_input_length' => 2,
                        'page_limit' => 10,
                        'allow_clear' => true,
                        'delay' => 250,
                        'cache' => false,
                        'cache_timeout' => 60000, // if 'cache' is true
                        'language' => 'fr',
                        'placeholder' => 'Selectionner un propriétaire',
                    ]);
            }
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => 'App\Entity\Page',
            'mode' => 'string',
            'access' => 'string'
        ]);
    }
}
