<?php
namespace Cadoles\CoreBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\RepeatedType;
use Symfony\Component\Form\Extension\Core\Type\PasswordType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\ButtonType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Ivory\CKEditorBundle\Form\Type\CKEditorType;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;


use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\EntityManager;

class MailType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder->add('submit',
            SubmitType::class, array(
                "label"       => "Envoyer l'invitation",
                "attr"        => array("class" => "btn btn-success")
            )
        );

        $builder->add('destinataire',
            TextType::class, array(
                "label"       =>"Destinataires",
                "attr"        => array("class" => "form-control", "style" => "margin-bottom:15px"),
                "mapped"      => false
            )
        );

        $builder->add('subject',
            TextType::class, array(
                "label"       =>"Sujet",
                "attr"        => array("class" => "form-control", "style" => "margin-bottom:15px"),
                "mapped"      => false
            )
        );

        $builder
        ->add("message",CKEditorType::class,[
            'config_name' => 'small_config',
            'label' => "Message",
            'mapped'=> false,
            'required' => false,
            'attr' => array("class" => "form-control", "style" => "margin-bottom:15px"),
            'config' => ["height" => "150px"]
        ]);
    }

    public function configureOptions(OptionsResolver $resolver)
    {

    }
}
