<?php

namespace Cadoles\PortalBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Blogarticle
 *
 * @ORM\Entity
 * @ORM\Table(name="blogarticle")
 * @ORM\Entity(repositoryClass="Cadoles\PortalBundle\Repository\BlogarticleRepository")
 * @ORM\HasLifecycleCallbacks
 */
class Blogarticle
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="name", type="string", length=100)
     */
    private $name;

    /**
    * @var string
    *
    * @ORM\Column(name="description", type="text", nullable=true)
    */
    private $description;

    /**
     * @ORM\Column(name="submit", type="datetime")
     */
    private $submit;   

    /**
     * @ORM\Column(name="fgdraft", type="boolean")
     */
    private $fgdraft;  

    /**
     * @ORM\Column(name="fgcomment", type="boolean")
     */
    private $fgcomment;  

    /**
     * @var string
     *
     * @ORM\Column(name="image", type="string", length=100, nullable=true)
     */
    private $image;

    /**
     * @ORM\ManyToOne(targetEntity="Cadoles\CoreBundle\Entity\User", inversedBy="blogarticles")
     * @ORM\JoinColumn(nullable=true)
     */
    private $user;

    /**
     * @ORM\ManyToOne(targetEntity="Cadoles\PortalBundle\Entity\Blog", inversedBy="blogarticles")
     * @ORM\JoinColumn(nullable=false)
     */
    private $blog;

    /**
     * @var ArrayCollection $blogcomment
     * @var Blogcomment
     *
     * @ORM\OneToMany(targetEntity="Cadoles\PortalBundle\Entity\Blogcomment", mappedBy="blogarticle", cascade={"persist"}, orphanRemoval=true)
     */
    private $blogcomments;



    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set name
     *
     * @param string $name
     *
     * @return Blogarticle
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set description
     *
     * @param string $description
     *
     * @return Blogarticle
     */
    public function setDescription($description)
    {
        $this->description = $description;

        return $this;
    }

    /**
     * Get description
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Set submit
     *
     * @param \DateTime $submit
     *
     * @return Blogarticle
     */
    public function setSubmit($submit)
    {
        $this->submit = $submit;

        return $this;
    }

    /**
     * Get submit
     *
     * @return \DateTime
     */
    public function getSubmit()
    {
        return $this->submit;
    }

    /**
     * Set fgdraft
     *
     * @param boolean $fgdraft
     *
     * @return Blogarticle
     */
    public function setFgdraft($fgdraft)
    {
        $this->fgdraft = $fgdraft;

        return $this;
    }

    /**
     * Get fgdraft
     *
     * @return boolean
     */
    public function getFgdraft()
    {
        return $this->fgdraft;
    }

    /**
     * Set image
     *
     * @param string $image
     *
     * @return Blogarticle
     */
    public function setImage($image)
    {
        $this->image = $image;

        return $this;
    }

    /**
     * Get image
     *
     * @return string
     */
    public function getImage()
    {
        return $this->image;
    }

    /**
     * Set user
     *
     * @param \Cadoles\CoreBundle\Entity\User $user
     *
     * @return Blogarticle
     */
    public function setUser(\Cadoles\CoreBundle\Entity\User $user = null)
    {
        $this->user = $user;

        return $this;
    }

    /**
     * Get user
     *
     * @return \Cadoles\CoreBundle\Entity\User
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * Set blog
     *
     * @param \Cadoles\PortalBundle\Entity\blog $blog
     *
     * @return Blogarticle
     */
    public function setBlog(\Cadoles\PortalBundle\Entity\blog $blog)
    {
        $this->blog = $blog;

        return $this;
    }

    /**
     * Get blog
     *
     * @return \Cadoles\PortalBundle\Entity\blog
     */
    public function getBlog()
    {
        return $this->blog;
    }

    /**
     * Set fgcomment
     *
     * @param boolean $fgcomment
     *
     * @return Blogarticle
     */
    public function setFgcomment($fgcomment)
    {
        $this->fgcomment = $fgcomment;

        return $this;
    }

    /**
     * Get fgcomment
     *
     * @return boolean
     */
    public function getFgcomment()
    {
        return $this->fgcomment;
    }
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->blogcomments = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Add blogcomment
     *
     * @param \Cadoles\PortalBundle\Entity\Blogcomment $blogcomment
     *
     * @return Blogarticle
     */
    public function addBlogcomment(\Cadoles\PortalBundle\Entity\Blogcomment $blogcomment)
    {
        $this->blogcomments[] = $blogcomment;

        return $this;
    }

    /**
     * Remove blogcomment
     *
     * @param \Cadoles\PortalBundle\Entity\Blogcomment $blogcomment
     */
    public function removeBlogcomment(\Cadoles\PortalBundle\Entity\Blogcomment $blogcomment)
    {
        $this->blogcomments->removeElement($blogcomment);
    }

    /**
     * Get blogcomments
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getBlogcomments()
    {
        return $this->blogcomments;
    }
}
