<?php

namespace Cadoles\PortalBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\ColorType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Ivory\CKEditorBundle\Form\Type\CKEditorType;

use Cadoles\PortalBundle\Entity\Itemcategory;

class PagewidgetType extends AbstractType
{
    public $container;
 
    public function __construct($container) {
        $this->container = $container;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        // Ajout des champs commun à tout les widgets
        $builder
            ->add('submit',SubmitType::class, [
                "label"         => ($options["mode"]=="delete"?"Confirmer la Suppression":"Valider"),
                "attr"          => ($options["mode"]=="delete"?array("class" => "btn btn-danger"):array("class" => "btn btn-success"))
            ])

            ->add('name', TextType::class, [
              'label' => 'Nom'
            ])                     
            ->add('height', IntegerType::class, [
              'label' => "Hauteur du Widget",
            ]) 
            ->add('border', ChoiceType::class, [
              'label' => "Afficher les Bords",
              'choices' => array("oui" => "1","non" => "0")
            ])     
            ->add('autoajust', ChoiceType::class, [
              'label' => "Ajuster la Hauteur au Contenu",
              'choices' => array("oui" => "1","non" => "0")
            ])   
            ->add('opened', ChoiceType::class, [
                'label' => "Afficher le corps du widget à l'ouverture",
                'choices' => array("oui" => "1","non" => "0")
              ])              
            ->add('colorheaderback', TextType::class, [
              'label' => "Couleur de Fond de l'Entête",
              'required'    => false,
              'attr'        => array("class" => "pick-a-color")              
            ])             
            ->add('colorheaderfont', TextType::class, [
              'label' => "Couleur du Texte de l'Entête",
              'required'    => false,
              'attr'        => array("class" => "pick-a-color")
            ])  
            ->add('colorbodyback', TextType::class, [
              'label' => "Couleur de Fond du Corps",
              'required'    => false,
              'attr'        => array("class" => "pick-a-color")              
            ])  
            ->add('colorbodyfont', TextType::class, [
              'label' => "Couleur du Texte du Corps",
              'required'    => false,
              'attr'        => array("class" => "pick-a-color")              
            ])      
            
            ->add('idicon', HiddenType::class,['mapped'=> false,'data' => $options["idicon"]]);
        
        foreach($options["param"]->fields as $field) {
            if($field->type=="string") {
                $builder
                ->add($field->id, TextType::class, [
                'label' => $field->label,
                'mapped'=> false,
                'label_attr' => ['loc' => $field->loc],
                'data' => $field->value,
                'required' => ($field->mandatory=="true"),
                ]);
            }

            elseif($field->type=="integer") {
                $builder
                ->add($field->id, IntegerType::class, [
                'label' => $field->label,
                'mapped'=> false,
                'label_attr' => ['loc' => $field->loc],              
                'data' => $field->value,
                'required' => ($field->mandatory=="true"),
                ]);
            }

            elseif($field->type=="boolean") {
                $builder
                ->add($field->id, ChoiceType::class, [
                    'label' => $field->label,
                    'mapped'=> false,
                    'label_attr' => ['loc' => $field->loc],              
                    'data' => $field->value,
                    'required' => ($field->mandatory=="true"),
                    'choices' => array("Non" => 0,"Oui" => 1)
                ]) ;           
            } 

            elseif($field->type=="desktopmode") {
                $builder
                ->add($field->id, ChoiceType::class, [
                    'label' => $field->label,
                    'mapped'=> false,
                    'label_attr' => ['loc' => $field->loc],              
                    'data' => $field->value,
                    'required' => ($field->mandatory=="true"),
                    'choices' => array("Grand" => "0","Moyen" => "1", "Petit" => "2", "Liste" => "3")
                ]) ;           
            }

            elseif($field->type=="modelist") {
                $builder
                ->add($field->id, ChoiceType::class, [
                    'label' => $field->label,
                    'mapped'=> false,
                    'label_attr' => ['loc' => $field->loc],              
                    'data' => $field->value,
                    'required' => ($field->mandatory=="true"),
                    'choices' => array("Pavet" => "0","Liste" => "1")
                ]) ;           
            }            
            

            elseif($field->type=="withbookmark") {
                $builder
                ->add($field->id, ChoiceType::class, [
                    'label' => $field->label,
                    'mapped'=> false,
                    'label_attr' => ['loc' => $field->loc],              
                    'data' => $field->value,
                    'required' => ($field->mandatory=="true"),
                    'choices' => array("Favoris + Items" => "0","Items uniquement" => "1", "Favoris uniquement" => "2")
                ]) ;           
            }

            elseif($field->type=="itemcategory") {
                $id = $field->value;
                $categorys= $this->container->get('doctrine.orm.entity_manager')->getRepository("CadolesPortalBundle:Itemcategory")->findAll();
                $choices=array();
                foreach($categorys as $category) {
                    $choices[$category->getLabel()]=$category->getId();
                }

                $builder
                ->add($field->id, ChoiceType::class, [
                    'label' => $field->label,
                    'mapped'=> false,
                    'label_attr' => ['loc' => $field->loc],              
                    'data' => $id,
                    'required' => ($field->mandatory=="true"),
                    'choices' => $choices,
                    'placeholder'   => '-- Sélectionnez une catégorie --',
                ]) ;       
            }

            elseif($field->type=="alertcategory") {
                $id = $field->value;
                $categorys= $this->container->get('doctrine.orm.entity_manager')->getRepository("CadolesPortalBundle:Alertcategory")->findAll();
                $choices=array();
                foreach($categorys as $category) {
                    $choices[$category->getLabel()]=$category->getId();
                }

                $builder
                ->add($field->id, ChoiceType::class, [
                    'label' => $field->label,
                    'mapped'=> false,
                    'label_attr' => ['loc' => $field->loc],              
                    'data' => $id,
                    'required' => ($field->mandatory=="true"),
                    'choices' => $choices,
                    'placeholder'   => '-- Sélectionnez une catégorie --',
                ]) ;       
            } 
            
            elseif($field->type=="appexternal") {
                $id = $field->value;
                $appexternals= $this->container->get('doctrine.orm.entity_manager')->getRepository("CadolesPortalBundle:Appexternal")->findAll();
                $choices=array();
                foreach($appexternals as $appexternal) {
                    $choices[$appexternal->getName()]=$appexternal->getId();
                }

                $builder
                ->add($field->id, ChoiceType::class, [
                    'label' => $field->label,
                    'mapped'=> false,
                    'label_attr' => ['loc' => $field->loc],              
                    'data' => $id,
                    'required' => ($field->mandatory=="true"),
                    'choices' => $choices,
                    'placeholder'   => '-- Sélectionnez une application --',
                ]) ;       
            } 

            elseif($field->type=="apponly") {
                $builder
                ->add($field->id, ChoiceType::class, [
                    'label' => $field->label,
                    'mapped'=> false,
                    'label_attr' => ['loc' => $field->loc],              
                    'data' => $field->value,
                    'required' => ($field->mandatory=="true"),
                    'choices' => array("Documents + Tâches" => "0","Documents uniquement" => "1", "Tâches uniquement" => "2")
                ]) ;       
            } 

            elseif($field->type=="target") {
                $builder
                ->add($field->id, ChoiceType::class, [
                    'label' => $field->label,
                    'mapped'=> false,
                    'label_attr' => ['loc' => $field->loc],              
                    'data' => $field->value,
                    'required' => ($field->mandatory=="true"),
                    'choices' => array("Nouvel onglet/fenêtre" => "_blank", "iFrame" => "frame","Onglet courant" => "_self")
                ]) ;       
            } 
            
            elseif($field->type=="ckeditor") {
                $builder
                ->add($field->id,CKEditorType::class,[
                    'config_name' => 'full_config',
                    'label' => $field->label,
                    'mapped'=> false,
                    'label_attr' => ['loc' => $field->loc],              
                    'data' => $field->value,
                    'required' => ($field->mandatory=="true"),
                    'config' => ['filebrowserUploadRoute' => 'cadoles_portal_'.$options["access"].'_pagewidget_upload']
                ]);
            }

            elseif($field->type=="clock") {
                $builder
                ->add($field->id, ChoiceType::class, [
                    'label' => $field->label,
                    'mapped'=> false,
                    'label_attr' => ['loc' => $field->loc],              
                    'data' => $field->value,
                    'required' => ($field->mandatory=="true"),
                    'choices' => array("Analogique" => "0","Numérique" => "1")
                ]) ;           
            }            
        }
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => 'Cadoles\PortalBundle\Entity\Pagewidget',
            'param' => 'string',
            'mode' => 'string',
            'access' => 'string',
            'idicon' => 'string'
        ]);
    }
}
