<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Page
 *
 * @ORM\Entity
 * @ORM\Table(name="page")
 * @ORM\HasLifecycleCallbacks
 * @ORM\Entity(repositoryClass="App\Repository\PageRepository")
 */
class Page
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="name", type="string", length=100)
     */
    private $name;

    /**
     * @var integer
     *
     * @ORM\Column(name="roworder", type="integer")
     */
    private $roworder;

    /**
     * @var integer
     *
     * @ORM\Column(name="maxwidth", type="integer")
     */
    private $maxwidth;

    /**
     * @var string
     *
     * @ORM\Column(name="fonticon", type="string", nullable=true)
     */
    private $fonticon;

    /**
     * @var string
     *
     * @ORM\Column(name="url", type="text", nullable=true)
     */
    private $url;

     /**
     * @var boolean
     *
     * @ORM\Column(name="toreload", type="boolean", nullable=true)
     */
    private $toreload;

    /**
     * @var string
     *
     * @ORM\Column(name="html", type="text", nullable=true)
     */
    private $html;

    /**
     * @var string
     *
     * @ORM\Column(name="template", type="array", nullable=true)
     */
    private $template;

    /**
     * @var string
     *
     * @ORM\Column(name="parentfor", type="string", nullable=true)
     */
    protected $parentfor;  

    /**
     * @var string
     *
     * @ORM\Column(name="roles", type="array",  nullable=true)
     */
    private $roles;

     /**
     * @var boolean
     *
     * @ORM\Column(name="fgpreference", type="boolean", nullable=true)
     */
    private $fgpreference;

    /**
     * @ORM\ManyToOne(targetEntity="Pagecategory", inversedBy="pages")
     */
    private $pagecategory;

    /**
     * @ORM\ManyToMany(targetEntity="Group", inversedBy="pages", cascade={"persist"})
     * @ORM\JoinTable(name="pagegroupe",
     *   joinColumns={@ORM\JoinColumn(name="page", referencedColumnName="id")},
     *   inverseJoinColumns={@ORM\JoinColumn(name="groupe", referencedColumnName="id")}
     * )
     */
    protected $groups;

    /**
     * @ORM\ManyToOne(targetEntity="User", inversedBy="pages")
     * @ORM\JoinColumn(nullable=true)
     */
    private $user;

    /**
     * @var ArrayCollection $pagewidgets
     * @var Pagewidget
     *
     * @ORM\OneToMany(targetEntity="Pagewidget", mappedBy="page", cascade={"persist"}, orphanRemoval=true)
     * @ORM\OrderBy({"loc" = "ASC", "roworder" = "ASC"})
     */
    private $pagewidgets; 

    /**
     * @ORM\ManyToOne(targetEntity="Page", inversedBy="pages")
     * @ORM\JoinColumn(nullable=true, onDelete="SET NULL")
     */
    private $page;    

    /**
     * @var ArrayCollection $pages
     * @var Page
     *
     * @ORM\OneToMany(targetEntity="Page", mappedBy="page", cascade={"persist"}, orphanRemoval=false)
     */
    private $pages; 

    /**
     * @var ArrayCollection $templategroups
     * @var Group
     *
     * @ORM\OneToMany(targetEntity="Group", mappedBy="pagetemplate", cascade={"persist"}, orphanRemoval=false)
     */
    private $templategroups; 


    
    /* champs calculé non stocké en base */
    private $canupdate;
    public function getCanupdate()
    {
        return $this->canupdate;
    }    
    public function setCanupdate($canupdate)
    {
        $this->canupdate = $canupdate;
        return $this;
    }

    /* champs calculé non stocké en base */
    private $counterread;
    public function getCounterRead()
    {
        return $this->counterread;
    }    
    public function setCounterRead($counterread)
    {
        $this->counterread = $counterread;
        return $this;
    }    

    // A garder pour forcer l'id en init
    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }   
        

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->groups = new \Doctrine\Common\Collections\ArrayCollection();
        $this->pagewidgets = new \Doctrine\Common\Collections\ArrayCollection();
        $this->pages = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set name
     *
     * @param string $name
     *
     * @return Page
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set roworder
     *
     * @param integer $roworder
     *
     * @return Page
     */
    public function setRoworder($roworder)
    {
        $this->roworder = $roworder;

        return $this;
    }

    /**
     * Get roworder
     *
     * @return integer
     */
    public function getRoworder()
    {
        return $this->roworder;
    }

    /**
     * Set maxwidth
     *
     * @param integer $maxwidth
     *
     * @return Page
     */
    public function setMaxwidth($maxwidth)
    {
        $this->maxwidth = $maxwidth;

        return $this;
    }

    /**
     * Get maxwidth
     *
     * @return integer
     */
    public function getMaxwidth()
    {
        return $this->maxwidth;
    }

    /**
     * Set url
     *
     * @param string $url
     *
     * @return Page
     */
    public function setUrl($url)
    {
        $this->url = $url;

        return $this;
    }

    /**
     * Get url
     *
     * @return string
     */
    public function getUrl()
    {
        return $this->url;
    }

    /**
     * Set html
     *
     * @param string $html
     *
     * @return Page
     */
    public function setHtml($html)
    {
        $this->html = $html;

        return $this;
    }

    /**
     * Get html
     *
     * @return string
     */
    public function getHtml()
    {
        return $this->html;
    }

    /**
     * Set template
     *
     * @param array $template
     *
     * @return Page
     */
    public function setTemplate($template)
    {
        $this->template = $template;

        return $this;
    }

    /**
     * Get template
     *
     * @return array
     */
    public function getTemplate()
    {
        return $this->template;
    }

    /**
     * Set parentfor
     *
     * @param string $parentfor
     *
     * @return Page
     */
    public function setParentfor($parentfor)
    {
        $this->parentfor = $parentfor;

        return $this;
    }

    /**
     * Get parentfor
     *
     * @return string
     */
    public function getParentfor()
    {
        return $this->parentfor;
    }

    /**
     * Set roles
     *
     * @param array $roles
     *
     * @return Page
     */
    public function setRoles($roles)
    {
        $this->roles = $roles;

        return $this;
    }

    /**
     * Get roles
     *
     * @return array
     */
    public function getRoles()
    {
        return $this->roles;
    }

    /**
     * Set pagecategory
     *
     * @param Pagecategory $pagecategory
     *
     * @return Page
     */
    public function setPagecategory(Pagecategory $pagecategory = null)
    {
        $this->pagecategory = $pagecategory;

        return $this;
    }

    /**
     * Get pagecategory
     *
     * @return Pagecategory
     */
    public function getPagecategory()
    {
        return $this->pagecategory;
    }

    /**
     * Add group
     *
     * @param Group $group
     *
     * @return Page
     */
    public function addGroup(Group $group)
    {
        $this->groups[] = $group;

        return $this;
    }

    /**
     * Remove group
     *
     * @param Group $group
     */
    public function removeGroup(Group $group)
    {
        $this->groups->removeElement($group);
    }

    /**
     * Get groups
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getGroups()
    {
        return $this->groups;
    }

    /**
     * Set user
     *
     * @param User $user
     *
     * @return Page
     */
    public function setUser(User $user = null)
    {
        $this->user = $user;

        return $this;
    }

    /**
     * Get user
     *
     * @return User
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * Add pagewidget
     *
     * @param Pagewidget $pagewidget
     *
     * @return Page
     */
    public function addPagewidget(Pagewidget $pagewidget)
    {
        $this->pagewidgets[] = $pagewidget;

        return $this;
    }

    /**
     * Remove pagewidget
     *
     * @param Pagewidget $pagewidget
     */
    public function removePagewidget(Pagewidget $pagewidget)
    {
        $this->pagewidgets->removeElement($pagewidget);
    }

    /**
     * Get pagewidgets
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getPagewidgets()
    {
        return $this->pagewidgets;
    }

    /**
     * Set page
     *
     * @param Page $page
     *
     * @return Page
     */
    public function setPage(Page $page = null)
    {
        $this->page = $page;

        return $this;
    }

    /**
     * Get page
     *
     * @return Page
     */
    public function getPage()
    {
        return $this->page;
    }

    /**
     * Add page
     *
     * @param Page $page
     *
     * @return Page
     */
    public function addPage(Page $page)
    {
        $this->pages[] = $page;

        return $this;
    }

    /**
     * Remove page
     *
     * @param Page $page
     */
    public function removePage(Page $page)
    {
        $this->pages->removeElement($page);
    }

    /**
     * Get pages
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getPages()
    {
        return $this->pages;
    }

    /**
     * Add templategroup
     *
     * @param Group $templategroup
     *
     * @return Page
     */
    public function addTemplategroup(Group $templategroup)
    {
        $this->templategroups[] = $templategroup;

        return $this;
    }

    /**
     * Remove templategroup
     *
     * @param Group $templategroup
     */
    public function removeTemplategroup(Group $templategroup)
    {
        $this->templategroups->removeElement($templategroup);
    }

    /**
     * Get templategroups
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getTemplategroups()
    {
        return $this->templategroups;
    }

    /**
     * Set fonticon
     *
     * @param string $fonticon
     *
     * @return Page
     */
    public function setFonticon($fonticon)
    {
        $this->fonticon = $fonticon;

        return $this;
    }

    /**
     * Get fonticon
     *
     * @return string
     */
    public function getFonticon()
    {
        return $this->fonticon;
    }

    /**
     * Set toreload
     *
     * @param boolean $toreload
     *
     * @return Page
     */
    public function setToreload($toreload)
    {
        $this->toreload = $toreload;

        return $this;
    }

    /**
     * Get toreload
     *
     * @return boolean
     */
    public function getToreload()
    {
        return $this->toreload;
    }

    /**
     * Set fgpreference
     *
     * @param boolean $fgpreference
     *
     * @return Page
     */
    public function setFgpreference($fgpreference)
    {
        $this->fgpreference = $fgpreference;

        return $this;
    }

    /**
     * Get fgpreference
     *
     * @return boolean
     */
    public function getFgpreference()
    {
        return $this->fgpreference;
    }    
}
