<?php
namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;

use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;
use App\Validator as UserAssert;
use Symfony\Component\Validator\Constraints as Assert;

use Symfony\Component\Security\Core\User\UserInterface;
use Symfony\Component\Security\Core\User\LegacyPasswordAuthenticatedUserInterface;


/**
 * @ORM\Entity
 * @ORM\Table(name="user",indexes={@ORM\Index(name="apikey", columns={"apikey"})})
 * @ORM\HasLifecycleCallbacks()
 *
 * @UniqueEntity(fields="username", message="Un utilisateur existe déjà avec ce login.")
 * @UniqueEntity(fields="email", message="Un utilisateur existe déjà avec ce mail.")
  */
class User implements UserInterface, LegacyPasswordAuthenticatedUserInterface
{
    /**
     * @ORM\Column(type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=128, unique=true)
     * @Assert\Length(
     *      min = "5",
     *      max = "128",
     *      minMessage = "Votre nom doit faire au moins {{ limit }} caractères",
     *      maxMessage = "Votre nom ne peut pas être plus long que {{ limit }} caractères"
     * )
     */
    private $username;

    /**
     * @ORM\Column(type="string", length=250, nullable=true)
     */
    private $firstname;

    /**
     * @ORM\Column(type="string", length=250, nullable=true)
     */
    private $lastname;

    /**
     * @ORM\Column(type="string", length=250)
     */
    private $password;
    
    /**
     * @UserAssert\Password()
     */
    private $passwordplain;

    /**
     * @ORM\Column(type="string", length=250)
     */
    private $salt;

    /**
     * @ORM\Column(type="string", length=800, nullable=true)
     */
    private $passwordad;

    /**
     * @ORM\Column(type="string", length=128, unique=true)
     */
    private $email;

    /**
     * @ORM\Column(name="visible", type="boolean")
     */
    protected $visible;

    /**
      * @ORM\Column(type="string", length=60, nullable=true, options={"default" : 0})
     */
    private $avatar;

    /**
     * @ORM\Column(type="string", length=60)
     */
    private $role;

    /**
     * @ORM\Column(type="string", length=60)
     */
    private $authlevel;

    /**
     * @ORM\Column(type="string", length=9, nullable=true)
     */
    private $siren;

    /**
     * @ORM\Column(type="string", length=14, nullable=true)
     */
    private $siret;

    /**
     * @ORM\Column(type="string", length=250, nullable=true)
     */
    private $labelniveau01;

    /**
     * @ORM\Column(type="string", length=250, nullable=true)
     */
    private $labelniveau02;


    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     */
    private $usualname;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     */
    private $telephonenumber;

    /**
     * @ORM\Column(type="text", nullable=true)
     */
    private $postaladress;

    /**
     * @ORM\Column(type="string", length=250, nullable=true)
     */
    private $givensname;

    /**
     * @ORM\Column(type="date", nullable=true)
     */
    private $birthdate;

    /**
     * @ORM\Column(type="string", length=20, nullable=true)
     */
    private $gender;

    /**
     * @ORM\Column(type="string", length=250, nullable=true)
     */
    private $job;
    
    /**
     * @ORM\Column(type="string", length=250, nullable=true)
     */
    private $position;    


    /**
     * @ORM\Column(type="string", length=250, nullable=true)
     */
    private $apikey;

    /**
     * @ORM\Column(type="datetime", nullable=true)
     */
    private $keyexpire;    

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     */
    private $keyvalue;    
        
    /**
     * @ORM\Column(type="string", length=250, nullable=true)
     */
    private $belongingpopulation;    

    /**
     * @ORM\Column(type="integer", nullable=true)
     */
    private $viewcalendar;   

    /**
     * @ORM\Column(type="datetime", nullable=true)
     */
    private $visitedate;

    /**
     * @ORM\Column(type="integer", nullable=true)
     */
    private $visitecpt;

    /**
     * @ORM\Column(type="string", length=150, nullable=true)
     */
    private $niveau01other;

    /**
     * @ORM\Column(name="motivation", type="text", nullable=true)
     */
    private $motivation;

    /**
     * @ORM\Column(name="note", type="text", nullable=true)
     */
    private $note;

    /**
     * @ORM\Column(name="preference", type="array", nullable=true)
     */
    private $preference;

    /**
     * @ORM\ManyToOne(targetEntity="PermModoProfil", inversedBy="users")
     * @ORM\JoinColumn(nullable=true)
     */
    private $permmodoprofil;

    /**
     * @ORM\ManyToOne(targetEntity="Country", inversedBy="users")
     * @ORM\JoinColumn(nullable=true)
     */
    private $birthcountry;

    /**
     * @ORM\ManyToOne(targetEntity="City", inversedBy="users")
     * @ORM\JoinColumn(nullable=true)
     */
    private $birthplace;

    /**
     * @ORM\ManyToOne(targetEntity="Niveau01", inversedBy="users")
     * @ORM\JoinColumn(nullable=false)
     */
    private $niveau01;

    /**
     * @ORM\ManyToOne(targetEntity="Niveau02", inversedBy="users")
     * @ORM\JoinColumn(nullable=true)
     */
    private $niveau02;    

    /**
     * @var ArrayCollection $groups
     * @var UserGroup
     *
     * @ORM\OneToMany(targetEntity="UserGroup", mappedBy="user", cascade={"persist"}, orphanRemoval=true)
     */
    private $groups;

    /**
     * @var ArrayCollection $ownergroups
     * @var Group
     *
     * @ORM\OneToMany(targetEntity="Group", mappedBy="owner", cascade={"persist"}, orphanRemoval=false)
     */
    private $ownergroups;

    /**
     * @var ArrayCollection $groups
     * @var UserGroup
     *
     * @ORM\OneToMany(targetEntity="UserModo", mappedBy="user", cascade={"persist"}, orphanRemoval=true)
     */
    private $modos;

    /**
     * @var ArrayCollection $page
     * @var Page
     *
     * @ORM\OneToMany(targetEntity="Page", mappedBy="user", cascade={"persist"}, orphanRemoval=true)
     */
    private $pages;

    /**
     * @var ArrayCollection $bookmark
     * @var Bookmark
     *
     * @ORM\OneToMany(targetEntity="Bookmark", mappedBy="user", cascade={"persist"}, orphanRemoval=true)
     */
    private $bookmarks;

    /**
     * @var ArrayCollection $calendar
     * @var Calendar
     *
     * @ORM\OneToMany(targetEntity="Calendar", mappedBy="user", cascade={"persist"}, orphanRemoval=true)
     */
    private $calendars;

    /**
    * @ORM\ManyToMany(targetEntity="Notice", mappedBy="users")
    */    
    private $notices;  

    /**
     * @var ArrayCollection $blog
     * @var Blog
     *
     * @ORM\OneToMany(targetEntity="Blog", mappedBy="user", cascade={"persist"}, orphanRemoval=true)
     */
    private $blogs;    

    /**
    * @ORM\ManyToMany(targetEntity="Blog", mappedBy="writers")
    */    
    private $blogwriters;    

    /**
     * @var ArrayCollection $blogarticle
     * @var Blogarticle
     *
     * @ORM\OneToMany(targetEntity="Blogarticle", mappedBy="user", cascade={"persist"}, orphanRemoval=true)
     */
    private $blogarticles;    

    /**
     * @var ArrayCollection $blogcomment
     * @var Blogcomment
     *
     * @ORM\OneToMany(targetEntity="Blogcomment", mappedBy="user", cascade={"persist"}, orphanRemoval=true)
     */
    private $blogcomments;

    /**
     * @var ArrayCollection $project
     * @var Project
     *
     * @ORM\OneToMany(targetEntity="Project", mappedBy="user", cascade={"persist"}, orphanRemoval=true)
     */
    private $projects;    

    /**
    * @ORM\ManyToMany(targetEntity="Project", mappedBy="writers")
    */    
    private $projectwriters;    

    /**
     * @var ArrayCollection $projecttask
     * @var Projecttask
     *
     * @ORM\OneToMany(targetEntity="Projecttask", mappedBy="user", cascade={"persist"}, orphanRemoval=true)
     */
    private $projecttasks;    

    /**
     * @var ArrayCollection $projecttask
     * @var Projecttask
     *
     * @ORM\OneToMany(targetEntity="Projecttask", mappedBy="owner", cascade={"persist"}, orphanRemoval=true)
     */
    private $projectownertasks;    

    /**
     * @var ArrayCollection $projectcomment
     * @var Projectcomment
     *
     * @ORM\OneToMany(targetEntity="Projectcomment", mappedBy="user", cascade={"persist"}, orphanRemoval=true)
     */
    private $projectcomments;

    /**
     * @var ArrayCollection $icon
     * @var Icon
     *
     * @ORM\OneToMany(targetEntity="Icon", mappedBy="user", cascade={"persist"}, orphanRemoval=true)
     */
    private $icons;    

    /**
     * @var ArrayCollection $message
     * @var Message
     *
     * @ORM\OneToMany(targetEntity="Message", mappedBy="user", cascade={"persist"}, orphanRemoval=true)
     */
    private $messages;  

    /**
    * @ORM\ManyToMany(targetEntity="Message", mappedBy="readers")
    */    
    protected $messagereaders;     

    /**
    * @ORM\ManyToMany(targetEntity="Message", mappedBy="sees")
    */    
    protected $messagesees;  

    /**
    * @ORM\ManyToMany(targetEntity="Alert", mappedBy="readers")
    */    
    protected $alertreaders;     


//== CODE A NE PAS REGENERER
    /**
     * @ORM\PostLoad
     */
    public function PostLoad() {
        if($this->getAvatar()=="") {
            $this->setAvatar("noavatar.png");
        }
    }

    public function getUserName()
    {
        return $this->username;
    }

    public function getSalt(): ?string
    {
        return $this->salt;
    }

    public function setPassword($password)
    {
        if($password!=$this->password&&$password!=""){
            // Placer le password non encodé dans une variable tempo sur laquel on va appliquer la contraite
            $this->passwordplain = $password;

            // Password encrypté format openldap           
            $this->salt = uniqid(mt_rand(), true);
            $hash = '{SSHA}'.base64_encode(pack('H*', sha1($password.$this->salt)).$this->salt);
            $this->password = $hash;

            // Password encrypté AD
            $newPassword = "\"" . $password . "\"";
            $len = strlen($newPassword);
            $newPassw = "";
            for($i=0;$i<$len;$i++) {
                $newPassw .= "{".$newPassword."{".$i."}}\000";
            }   
            $this->passwordad = $newPassw;   
        }
        
        return $this;
    }

    public function setPasswordDirect($password)
    {
        // Permet de setter le password généré lors de l'inscription
        $this->password = $password;
        return $this;
    }
        
    public function getPassword(): string
    {
        return $this->password;
    }

    public function getRoles()
    {
        return explode(",",$this->role);
    }
    
    public function hasRole(string $role): ?bool
    {
        return ($role==$this->role);
    }

    public function getDisplayname()
    {
        return $this->firstname." ".$this->lastname;
    }
        
    public function eraseCredentials()
    {
    }

    /** @see \Serializable::serialize() */
    public function serialize()
    {
        return serialize(array(
            $this->id,
            $this->username,
            $this->password,
            $this->salt,
        ));
    }

    /** @see \Serializable::unserialize() */
    public function unserialize($serialized)
    {
        list (
            $this->id,
            $this->login,
            $this->password,
            $this->salt
        ) = unserialize($serialized);
    }

//== FIN DU CODE A NE PAS REGENERER




    /**
     * Constructor
     */
    public function __construct()
    {
        $this->groups = new \Doctrine\Common\Collections\ArrayCollection();
        $this->modos = new \Doctrine\Common\Collections\ArrayCollection();
        $this->pages = new \Doctrine\Common\Collections\ArrayCollection();
        $this->bookmarks = new \Doctrine\Common\Collections\ArrayCollection();
        $this->calendars = new \Doctrine\Common\Collections\ArrayCollection();
        $this->notices = new \Doctrine\Common\Collections\ArrayCollection();
        $this->blogs = new \Doctrine\Common\Collections\ArrayCollection();
        $this->blogwriters = new \Doctrine\Common\Collections\ArrayCollection();
        $this->blogarticles = new \Doctrine\Common\Collections\ArrayCollection();
        $this->icons = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set username
     *
     * @param string $username
     *
     * @return User
     */
    public function setUsername($username)
    {
        $this->username = $username;

        return $this;
    }

    /**
     * Set firstname
     *
     * @param string $firstname
     *
     * @return User
     */
    public function setFirstname($firstname)
    {
        $this->firstname = $firstname;

        return $this;
    }

    /**
     * Get firstname
     *
     * @return string
     */
    public function getFirstname()
    {
        return $this->firstname;
    }

    /**
     * Set lastname
     *
     * @param string $lastname
     *
     * @return User
     */
    public function setLastname($lastname)
    {
        $this->lastname = $lastname;

        return $this;
    }

    /**
     * Get lastname
     *
     * @return string
     */
    public function getLastname()
    {
        return $this->lastname;
    }

    /**
     * Set salt
     *
     * @param string $salt
     *
     * @return User
     */
    public function setSalt($salt)
    {
        $this->salt = $salt;

        return $this;
    }

    /**
     * Set email
     *
     * @param string $email
     *
     * @return User
     */
    public function setEmail($email)
    {
        $this->email = $email;

        return $this;
    }

    /**
     * Get email
     *
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * Set visible
     *
     * @param boolean $visible
     *
     * @return User
     */
    public function setVisible($visible)
    {
        $this->visible = $visible;

        return $this;
    }

    /**
     * Get visible
     *
     * @return boolean
     */
    public function getVisible()
    {
        return $this->visible;
    }

    /**
     * Set avatar
     *
     * @param string $avatar
     *
     * @return User
     */
    public function setAvatar($avatar)
    {
        $this->avatar = $avatar;

        return $this;
    }

    /**
     * Get avatar
     *
     * @return string
     */
    public function getAvatar()
    {
        return $this->avatar;
    }

    /**
     * Set role
     *
     * @param string $role
     *
     * @return User
     */
    public function setRole($role)
    {
        $this->role = $role;

        return $this;
    }

    /**
     * Get role
     *
     * @return string
     */
    public function getRole()
    {
        return $this->role;
    }

    /**
     * Set authlevel
     *
     * @param string $authlevel
     *
     * @return User
     */
    public function setAuthlevel($authlevel)
    {
        $this->authlevel = $authlevel;

        return $this;
    }

    /**
     * Get authlevel
     *
     * @return string
     */
    public function getAuthlevel()
    {
        return $this->authlevel;
    }

    /**
     * Set siren
     *
     * @param string $siren
     *
     * @return User
     */
    public function setSiren($siren)
    {
        $this->siren = $siren;

        return $this;
    }

    /**
     * Get siren
     *
     * @return string
     */
    public function getSiren()
    {
        return $this->siren;
    }

    /**
     * Set siret
     *
     * @param string $siret
     *
     * @return User
     */
    public function setSiret($siret)
    {
        $this->siret = $siret;

        return $this;
    }

    /**
     * Get siret
     *
     * @return string
     */
    public function getSiret()
    {
        return $this->siret;
    }

    /**
     * Set labelniveau01
     *
     * @param string $labelniveau01
     *
     * @return User
     */
    public function setLabelniveau01($labelniveau01)
    {
        $this->labelniveau01 = $labelniveau01;

        return $this;
    }

    /**
     * Get labelniveau01
     *
     * @return string
     */
    public function getLabelniveau01()
    {
        return $this->labelniveau01;
    }

    /**
     * Set labelniveau02
     *
     * @param string $labelniveau02
     *
     * @return User
     */
    public function setLabelniveau02($labelniveau02)
    {
        $this->labelniveau02 = $labelniveau02;

        return $this;
    }

    /**
     * Get labelniveau02
     *
     * @return string
     */
    public function getLabelniveau02()
    {
        return $this->labelniveau02;
    }

    /**
     * Set usualname
     *
     * @param string $usualname
     *
     * @return User
     */
    public function setUsualname($usualname)
    {
        $this->usualname = $usualname;

        return $this;
    }

    /**
     * Get usualname
     *
     * @return string
     */
    public function getUsualname()
    {
        return $this->usualname;
    }

    /**
     * Set telephonenumber
     *
     * @param string $telephonenumber
     *
     * @return User
     */
    public function setTelephonenumber($telephonenumber)
    {
        $this->telephonenumber = $telephonenumber;

        return $this;
    }

    /**
     * Get telephonenumber
     *
     * @return string
     */
    public function getTelephonenumber()
    {
        return $this->telephonenumber;
    }

    /**
     * Set postaladress
     *
     * @param string $postaladress
     *
     * @return User
     */
    public function setPostaladress($postaladress)
    {
        $this->postaladress = $postaladress;

        return $this;
    }

    /**
     * Get postaladress
     *
     * @return string
     */
    public function getPostaladress()
    {
        return $this->postaladress;
    }

    /**
     * Set givensname
     *
     * @param string $givensname
     *
     * @return User
     */
    public function setGivensname($givensname)
    {
        $this->givensname = $givensname;

        return $this;
    }

    /**
     * Get givensname
     *
     * @return string
     */
    public function getGivensname()
    {
        return $this->givensname;
    }

    /**
     * Set birthdate
     *
     * @param \DateTime $birthdate
     *
     * @return User
     */
    public function setBirthdate($birthdate)
    {
        $this->birthdate = $birthdate;

        return $this;
    }

    /**
     * Get birthdate
     *
     * @return \DateTime
     */
    public function getBirthdate()
    {
        return $this->birthdate;
    }

    /**
     * Set gender
     *
     * @param string $gender
     *
     * @return User
     */
    public function setGender($gender)
    {
        $this->gender = $gender;

        return $this;
    }

    /**
     * Get gender
     *
     * @return string
     */
    public function getGender()
    {
        return $this->gender;
    }

    /**
     * Set job
     *
     * @param string $job
     *
     * @return User
     */
    public function setJob($job)
    {
        $this->job = $job;

        return $this;
    }

    /**
     * Get job
     *
     * @return string
     */
    public function getJob()
    {
        return $this->job;
    }

    /**
     * Set position
     *
     * @param string $position
     *
     * @return User
     */
    public function setPosition($position)
    {
        $this->position = $position;

        return $this;
    }

    /**
     * Get position
     *
     * @return string
     */
    public function getPosition()
    {
        return $this->position;
    }

    /**
     * Set apikey
     *
     * @param string $apikey
     *
     * @return User
     */
    public function setApikey($apikey)
    {
        $this->apikey = $apikey;

        return $this;
    }

    /**
     * Get apikey
     *
     * @return string
     */
    public function getApikey()
    {
        return $this->apikey;
    }

    /**
     * Set keyexpire
     *
     * @param \DateTime $keyexpire
     *
     * @return User
     */
    public function setKeyexpire($keyexpire)
    {
        $this->keyexpire = $keyexpire;

        return $this;
    }

    /**
     * Get keyexpire
     *
     * @return \DateTime
     */
    public function getKeyexpire()
    {
        return $this->keyexpire;
    }

    /**
     * Set keyvalue
     *
     * @param string $keyvalue
     *
     * @return User
     */
    public function setKeyvalue($keyvalue)
    {
        $this->keyvalue = $keyvalue;

        return $this;
    }

    /**
     * Get keyvalue
     *
     * @return string
     */
    public function getKeyvalue()
    {
        return $this->keyvalue;
    }

    /**
     * Set belongingpopulation
     *
     * @param string $belongingpopulation
     *
     * @return User
     */
    public function setBelongingpopulation($belongingpopulation)
    {
        $this->belongingpopulation = $belongingpopulation;

        return $this;
    }

    /**
     * Get belongingpopulation
     *
     * @return string
     */
    public function getBelongingpopulation()
    {
        return $this->belongingpopulation;
    }

    /**
     * Set viewcalendar
     *
     * @param integer $viewcalendar
     *
     * @return User
     */
    public function setViewcalendar($viewcalendar)
    {
        $this->viewcalendar = $viewcalendar;

        return $this;
    }

    /**
     * Get viewcalendar
     *
     * @return integer
     */
    public function getViewcalendar()
    {
        return $this->viewcalendar;
    }    

    /**
     * Set birthcountry
     *
     * @param Country $birthcountry
     *
     * @return User
     */
    public function setBirthcountry(Country $birthcountry = null)
    {
        $this->birthcountry = $birthcountry;

        return $this;
    }

    /**
     * Get birthcountry
     *
     * @return Country
     */
    public function getBirthcountry()
    {
        return $this->birthcountry;
    }

    /**
     * Set birthplace
     *
     * @param City $birthplace
     *
     * @return User
     */
    public function setBirthplace(City $birthplace = null)
    {
        $this->birthplace = $birthplace;

        return $this;
    }

    /**
     * Get birthplace
     *
     * @return City
     */
    public function getBirthplace()
    {
        return $this->birthplace;
    }

    /**
     * Set niveau01
     *
     * @param Niveau01 $niveau01
     *
     * @return User
     */
    public function setNiveau01(Niveau01 $niveau01)
    {
        $this->niveau01 = $niveau01;

        return $this;
    }

    /**
     * Get niveau01
     *
     * @return Niveau01
     */
    public function getNiveau01()
    {
        return $this->niveau01;
    }

    /**
     * Set niveau02
     *
     * @param Niveau02 $niveau02
     *
     * @return User
     */
    public function setNiveau02(Niveau02 $niveau02 = null)
    {
        $this->niveau02 = $niveau02;

        return $this;
    }

    /**
     * Get niveau02
     *
     * @return Niveau02
     */
    public function getNiveau02()
    {
        return $this->niveau02;
    }

    /**
     * Add group
     *
     * @param UserGroup $group
     *
     * @return User
     */
    public function addGroup(UserGroup $group)
    {
        $this->groups[] = $group;

        return $this;
    }

    /**
     * Remove group
     *
     * @param UserGroup $group
     */
    public function removeGroup(UserGroup $group)
    {
        $this->groups->removeElement($group);
    }

    /**
     * Get groups
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getGroups()
    {
        return $this->groups;
    }

    /**
     * Add modo
     *
     * @param UserModo $modo
     *
     * @return User
     */
    public function addModo(UserModo $modo)
    {
        $this->modos[] = $modo;

        return $this;
    }

    /**
     * Remove modo
     *
     * @param UserModo $modo
     */
    public function removeModo(UserModo $modo)
    {
        $this->modos->removeElement($modo);
    }

    /**
     * Get modos
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getModos()
    {
        return $this->modos;
    }

    /**
     * Add page
     *
     * @param Page $page
     *
     * @return User
     */
    public function addPage(Page $page)
    {
        $this->pages[] = $page;

        return $this;
    }

    /**
     * Remove page
     *
     * @param Page $page
     */
    public function removePage(Page $page)
    {
        $this->pages->removeElement($page);
    }

    /**
     * Get pages
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getPages()
    {
        return $this->pages;
    }

    /**
     * Add bookmark
     *
     * @param Bookmark $bookmark
     *
     * @return User
     */
    public function addBookmark(Bookmark $bookmark)
    {
        $this->bookmarks[] = $bookmark;

        return $this;
    }

    /**
     * Remove bookmark
     *
     * @param Bookmark $bookmark
     */
    public function removeBookmark(Bookmark $bookmark)
    {
        $this->bookmarks->removeElement($bookmark);
    }

    /**
     * Get bookmarks
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getBookmarks()
    {
        return $this->bookmarks;
    }

    /**
     * Add calendar
     *
     * @param Calendar $calendar
     *
     * @return User
     */
    public function addCalendar(Calendar $calendar)
    {
        $this->calendars[] = $calendar;

        return $this;
    }

    /**
     * Remove calendar
     *
     * @param Calendar $calendar
     */
    public function removeCalendar(Calendar $calendar)
    {
        $this->calendars->removeElement($calendar);
    }

    /**
     * Get calendars
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getCalendars()
    {
        return $this->calendars;
    }

    /**
     * Add notice
     *
     * @param Notice $notice
     *
     * @return User
     */
    public function addNotice(Notice $notice)
    {
        $this->notices[] = $notice;

        return $this;
    }

    /**
     * Remove notice
     *
     * @param Notice $notice
     */
    public function removeNotice(Notice $notice)
    {
        $this->notices->removeElement($notice);
    }

    /**
     * Get notices
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getNotices()
    {
        return $this->notices;
    }

    /**
     * Add blog
     *
     * @param Blog $blog
     *
     * @return User
     */
    public function addBlog(Blog $blog)
    {
        $this->blogs[] = $blog;

        return $this;
    }

    /**
     * Remove blog
     *
     * @param Blog $blog
     */
    public function removeBlog(Blog $blog)
    {
        $this->blogs->removeElement($blog);
    }

    /**
     * Get blogs
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getBlogs()
    {
        return $this->blogs;
    }

    /**
     * Add blogwriter
     *
     * @param Blog $blogwriter
     *
     * @return User
     */
    public function addBlogwriter(Blog $blogwriter)
    {
        $this->blogwriters[] = $blogwriter;

        return $this;
    }

    /**
     * Remove blogwriter
     *
     * @param Blog $blogwriter
     */
    public function removeBlogwriter(Blog $blogwriter)
    {
        $this->blogwriters->removeElement($blogwriter);
    }

    /**
     * Get blogwriters
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getBlogwriters()
    {
        return $this->blogwriters;
    }

    /**
     * Add blogarticle
     *
     * @param Blogarticle $blogarticle
     *
     * @return User
     */
    public function addBlogarticle(Blogarticle $blogarticle)
    {
        $this->blogarticles[] = $blogarticle;

        return $this;
    }

    /**
     * Remove blogarticle
     *
     * @param Blogarticle $blogarticle
     */
    public function removeBlogarticle(Blogarticle $blogarticle)
    {
        $this->blogarticles->removeElement($blogarticle);
    }

    /**
     * Get blogarticles
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getBlogarticles()
    {
        return $this->blogarticles;
    }

    /**
     * Add icon
     *
     * @param Icon $icon
     *
     * @return User
     */
    public function addIcon(Icon $icon)
    {
        $this->icons[] = $icon;

        return $this;
    }

    /**
     * Remove icon
     *
     * @param Icon $icon
     */
    public function removeIcon(Icon $icon)
    {
        $this->icons->removeElement($icon);
    }

    /**
     * Get icons
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getIcons()
    {
        return $this->icons;
    }

    /**
     * Add ownergroup
     *
     * @param Group $ownergroup
     *
     * @return User
     */
    public function addOwnergroup(Group $ownergroup)
    {
        $this->ownergroups[] = $ownergroup;

        return $this;
    }

    /**
     * Remove ownergroup
     *
     * @param Group $ownergroup
     */
    public function removeOwnergroup(Group $ownergroup)
    {
        $this->ownergroups->removeElement($ownergroup);
    }

    /**
     * Get ownergroups
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getOwnergroups()
    {
        return $this->ownergroups;
    }

    /**
     * Add message
     *
     * @param Message $message
     *
     * @return User
     */
    public function addMessage(Message $message)
    {
        $this->messages[] = $message;

        return $this;
    }

    /**
     * Remove message
     *
     * @param Message $message
     */
    public function removeMessage(Message $message)
    {
        $this->messages->removeElement($message);
    }

    /**
     * Get messages
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getMessages()
    {
        return $this->messages;
    }

    /**
     * Add messagereader
     *
     * @param Message $messagereader
     *
     * @return User
     */
    public function addMessagereader(Message $messagereader)
    {
        $this->messagereaders[] = $messagereader;

        return $this;
    }

    /**
     * Remove messagereader
     *
     * @param Message $messagereader
     */
    public function removeMessagereader(Message $messagereader)
    {
        $this->messagereaders->removeElement($messagereader);
    }

    /**
     * Get messagereaders
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getMessagereaders()
    {
        return $this->messagereaders;
    }

    /**
     * Add messagesee
     *
     * @param Message $messagesee
     *
     * @return User
     */
    public function addMessagesee(Message $messagesee)
    {
        $this->messagesees[] = $messagesee;

        return $this;
    }

    /**
     * Remove messagesee
     *
     * @param Message $messagesee
     */
    public function removeMessagesee(Message $messagesee)
    {
        $this->messagesees->removeElement($messagesee);
    }

    /**
     * Get messagesees
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getMessagesees()
    {
        return $this->messagesees;
    }

    /**
     * Add blogcomment
     *
     * @param Blogcomment $blogcomment
     *
     * @return User
     */
    public function addBlogcomment(Blogcomment $blogcomment)
    {
        $this->blogcomments[] = $blogcomment;

        return $this;
    }

    /**
     * Remove blogcomment
     *
     * @param Blogcomment $blogcomment
     */
    public function removeBlogcomment(Blogcomment $blogcomment)
    {
        $this->blogcomments->removeElement($blogcomment);
    }

    /**
     * Get blogcomments
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getBlogcomments()
    {
        return $this->blogcomments;
    }

    /**
     * Add project
     *
     * @param Project $project
     *
     * @return User
     */
    public function addProject(Project $project)
    {
        $this->projects[] = $project;

        return $this;
    }

    /**
     * Remove project
     *
     * @param Project $project
     */
    public function removeProject(Project $project)
    {
        $this->projects->removeElement($project);
    }

    /**
     * Get projects
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getProjects()
    {
        return $this->projects;
    }

    /**
     * Add projectwriter
     *
     * @param Project $projectwriter
     *
     * @return User
     */
    public function addProjectwriter(Project $projectwriter)
    {
        $this->projectwriters[] = $projectwriter;

        return $this;
    }

    /**
     * Remove projectwriter
     *
     * @param Project $projectwriter
     */
    public function removeProjectwriter(Project $projectwriter)
    {
        $this->projectwriters->removeElement($projectwriter);
    }

    /**
     * Get projectwriters
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getProjectwriters()
    {
        return $this->projectwriters;
    }

    /**
     * Add projecttask
     *
     * @param Projecttask $projecttask
     *
     * @return User
     */
    public function addProjecttask(Projecttask $projecttask)
    {
        $this->projecttasks[] = $projecttask;

        return $this;
    }

    /**
     * Remove projecttask
     *
     * @param Projecttask $projecttask
     */
    public function removeProjecttask(Projecttask $projecttask)
    {
        $this->projecttasks->removeElement($projecttask);
    }

    /**
     * Get projecttasks
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getProjecttasks()
    {
        return $this->projecttasks;
    }

    /**
     * Add projectownertask
     *
     * @param Projecttask $projectownertask
     *
     * @return User
     */
    public function addProjectownertask(Projecttask $projectownertask)
    {
        $this->projectownertasks[] = $projectownertask;

        return $this;
    }

    /**
     * Remove projectownertask
     *
     * @param Projecttask $projectownertask
     */
    public function removeProjectownertask(Projecttask $projectownertask)
    {
        $this->projectownertasks->removeElement($projectownertask);
    }

    /**
     * Get projectownertasks
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getProjectownertasks()
    {
        return $this->projectownertasks;
    }

    /**
     * Add projectcomment
     *
     * @param Projectcomment $projectcomment
     *
     * @return User
     */
    public function addProjectcomment(Projectcomment $projectcomment)
    {
        $this->projectcomments[] = $projectcomment;

        return $this;
    }

    /**
     * Remove projectcomment
     *
     * @param Projectcomment $projectcomment
     */
    public function removeProjectcomment(Projectcomment $projectcomment)
    {
        $this->projectcomments->removeElement($projectcomment);
    }

    /**
     * Get projectcomments
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getProjectcomments()
    {
        return $this->projectcomments;
    }

    /**
     * Set visitedate
     *
     * @param \DateTime $visitedate
     *
     * @return User
     */
    public function setVisitedate($visitedate)
    {
        $this->visitedate = $visitedate;

        return $this;
    }

    /**
     * Get visitedate
     *
     * @return \DateTime
     */
    public function getVisitedate()
    {
        return $this->visitedate;
    }

    /**
     * Set visitecpt
     *
     * @param integer $visitecpt
     *
     * @return User
     */
    public function setVisitecpt($visitecpt)
    {
        $this->visitecpt = $visitecpt;

        return $this;
    }

    /**
     * Get visitecpt
     *
     * @return integer
     */
    public function getVisitecpt()
    {
        return $this->visitecpt;
    }

    /**
     * Set niveau01other
     *
     * @param string $niveau01other
     *
     * @return User
     */
    public function setNiveau01other($niveau01other)
    {
        $this->niveau01other = $niveau01other;

        return $this;
    }

    /**
     * Get niveau01other
     *
     * @return string
     */
    public function getNiveau01other()
    {
        return $this->niveau01other;
    }

    /**
     * Add alertreader
     *
     * @param Alert $alertreader
     *
     * @return User
     */
    public function addAlertreader(Alert $alertreader)
    {
        $this->alertreaders[] = $alertreader;

        return $this;
    }

    /**
     * Remove alertreader
     *
     * @param Alert $alertreader
     */
    public function removeAlertreader(Alert $alertreader)
    {
        $this->alertreaders->removeElement($alertreader);
    }

    /**
     * Get alertreaders
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getAlertreaders()
    {
        return $this->alertreaders;
    }

    /**
     * Set motivation
     *
     * @param string $motivation
     *
     * @return User
     */
    public function setMotivation($motivation)
    {
        $this->motivation = $motivation;

        return $this;
    }

    /**
     * Get motivation
     *
     * @return string
     */
    public function getMotivation()
    {
        return $this->motivation;
    }

    /**
     * Set preference
     *
     * @param array $preference
     *
     * @return User
     */
    public function setPreference($preference)
    {
        $this->preference = $preference;

        return $this;
    }

    /**
     * Get preference
     *
     * @return array
     */
    public function getPreference()
    {
        return $this->preference;
    }

    /**
     * Set permmodoprofil
     *
     * @param PermModoProfil $permmodoprofil
     *
     * @return User
     */
    public function setPermmodoprofil(PermModoProfil $permmodoprofil = null)
    {
        $this->permmodoprofil = $permmodoprofil;

        return $this;
    }

    /**
     * Get permmodoprofil
     *
     * @return PermModoProfil
     */
    public function getPermmodoprofil()
    {
        return $this->permmodoprofil;
    }

    /**
     * Set passwordad.
     *
     * @param string|null $passwordad
     *
     * @return User
     */
    public function setPasswordad($passwordad = null)
    {
        $this->passwordad = $passwordad;

        return $this;
    }

    /**
     * Get passwordad.
     *
     * @return string|null
     */
    public function getPasswordad()
    {
        return $this->passwordad;
    }

    /**
     * Set note
     *
     * @param string $note
     *
     * @return User
     */
    public function setNote($note)
    {
        $this->note = $note;

        return $this;
    }

    /**
     * Get note
     *
     * @return string
     */
    public function getNote()
    {
        return $this->note;
    }
}
