<?php
namespace App\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\RepeatedType;
use Symfony\Component\Form\Extension\Core\Type\PasswordType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\ButtonType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;


use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\EntityManager;

class ResetpwdType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder->add('submit',
            SubmitType::class, array(
                "label"       => ($options["mode"]=="delete"?"Confirmer la Suppression":"Valider"),
                "attr"        => ($options["mode"]=="delete"?array("class" => "btn btn-danger"):array("class" => "btn btn-success"))
            )
        );

        if($options["mode"]=="resetpwd01") {
            $builder->add('email',
                TextType::class, array(
                    "label"       =>"Votre Mail",
                    "disabled"    => ($options["mode"]=="delete"?true:false),
                )
            );   
        }
        else {
            $builder->add('password',
                RepeatedType::class, array(
                    "type" => PasswordType::class,
                    "required" => ($options["mode"]=="submit"?true:false),
                    "options" => array("always_empty" => true),
                    "first_options"  => array("label" => "Votre nouveau Mot de Passe"),
                    "second_options" => array('label' => 'Confirmer votre nouveau Mot de Passe'),
                    "invalid_message" => "Mot de passe non valide"
                )
            );        
        }
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'mode' => "string"
        ));
    }
}
