<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Asset\Packages;
use Symfony\Component\Finder\Finder;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Yaml\Yaml;

class ThemeController extends AbstractController
{
    private $data = 'config';
    private $route = 'app_config';
    private $render = 'Config/';
    private $entity = 'App:Config';

    public function list(Request $request, Packages $packages)
    {
        $session = $this->get('session');
        $finder = new Finder();

        $dir = $this->getParameter('kernel.project_dir').'/public/themes';
        $url = $packages->getUrl('themes');

        $finder->in($dir)->directories()->depth('== 0');
        $themes = [];
        $themes['']['dir'] = '';
        $themes['']['url'] = $url;
        $themes['']['name'] = 'Thème par défaut';

        foreach ($finder as $file) {
            $key = $file->getRelativePathname();
            $themes[$key]['dir'] = $key;
            $themes[$key]['url'] = $url.'/'.$key;

            $yml = Yaml::parseFile($dir.'/'.$key.'/info.yml');
            $themes[$key]['name'] = $yml['name'];
        }

        $current = $session->get('apptheme');
        $currentheme = $themes[$current];
        unset($themes[$current]);

        return $this->render('Theme/list.html.twig', [
            'useheader' => true,
            'usesidebar' => true,
            'currentheme' => $currentheme,
            'themes' => $themes,
        ]);
    }

    public function select(Request $request, $name)
    {
        $em = $this->getDoctrine()->getManager();
        $config = $em->getRepository('App:Config')->findoneBy(['id' => 'apptheme']);
        $config->setValue($name);

        $em->persist($config);
        $em->flush();

        return $this->redirectToRoute('app_theme');
    }
}
