<?php
namespace App\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Tetranz\Select2EntityBundle\Form\Type\Select2EntityType;
use FOS\CKEditorBundle\Form\Type\CKEditorType;

class ActivityType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder->add('submit',
            SubmitType::class, [
                "label" => "Valider",
                "attr" => ["class" => "btn btn-success"],
            ]
        );

        if($options["mode"]=="update") {
            $builder->add('clone',
            SubmitType::class, [
                "label" => "Dupliquer",
                "attr" => [
                    "class" => "btn btn-success",
                    "data-method" => "submit",
                    "data-confirm" => "Êtes-vous sûr de vouloir dupliquer cette activité ?",
                ],
            ]);
        }

        if($options["mode"]=="update"&&$options["status"]==0) {
            $builder->add('distribution',
            SubmitType::class, [
                "label" => "Distribuer",
                "attr" => [
                    "class" => "btn btn-success",
                    "data-method" => "submit",
                    "data-confirm" => "Confirmez vous la distribution de l'activité ? Une fois validée, vous ne pourrez plus modifier son entête et son énoncé."                    
                ],
            ]);
        }

        if($options["status"]==1&&$options["maxanwsered"]<=0) {
            if($options["maxanwsered"]==0) {
                $builder->add('recraft',
                SubmitType::class, [
                    "label" => "Replacer en mode brouillon",
                    "attr" => [
                        "class" => "btn btn-danger",
                        "data-method" => "submit",
                        "data-confirm" => "Attention des élèves ont vu votre activité ! Désirez-vous malgré tout replacer votre activité en mode brouillon ?"                   
                    ],
                ]);
            }
            else {
                $builder->add('recraft',
                SubmitType::class, [
                    "label" => "Replacer en mode brouillon",
                    "attr" => [
                        "class" => "btn btn-danger",
                    ]
                ]);                
            }
        }

        if($options["status"]==1) {
            $builder->add('archiving',
            SubmitType::class, [
                "label" => "Archiver",
                "attr" => [
                    "class" => "btn btn-danger float-right",
                    "data-method" => "submit",
                    "data-confirm" => "L'activité archivée ne se sera plus accessible aux élèves. Confirmez-vous ? "                    ],
                ]
            );        
        }

        if($options["status"]==10) {
            $builder->add('distribution',
            SubmitType::class, [
                "label" => "Réouvrir",
                "attr" => [
                    "class" => "btn btn-success",
                    "data-method" => "submit",
                    "data-confirm" => "Confirmez vous la réouverture de l'activité ?"                    ],
                ]
            );
        }

        $builder->add('name',
            TextType::class, [
                "disabled" => ($options["status"]>0),
                "label" =>"Nom",
            ]
        );

        $builder->add('subject',
            TextType::class, [
                "disabled" => ($options["status"]>0),
                "required" => false,
                "label" =>"Matière",
            ]
        );

        $builder->add('startdate',
            DateType::class, [
                "required" => false,
                "label" =>"Date début",
                "widget" => 'single_text',
            ]
        );

        $builder->add('enddate',
            DateType::class, [
                "required" => false,
                "label" =>"Date fin",
                "widget" => 'single_text',
            ]
        );

        $builder->add('group',
            Select2EntityType::class, [
                "label" => "Groupe",
                "disabled" => ($options["status"]>0),
                "required"    => true,
                "multiple" => false,
                "remote_route" => "app_group_select",
                "class" => "App:Group",
                "primary_key" => "id",
                "text_property" => "name",
                "minimum_input_length" => 0,
                "page_limit" => 100,
                "allow_clear" => true,
                "delay" => 250,
                "cache" => false,
                "cache_timeout" => 60000,
                "language" => "fr",
                "placeholder" => "Selectionner un Groupe",
            ]
        );
        
        if(($options["status"]==0)) {
            $builder->add('activity',
                CKEditorType::class, [
                    "required" => false,
                    "config" => [
                        'uiColor' => '#ffffff',
                        'height' => 600,
                        'filebrowserUploadRoute' => 'app_ckeditor_upload',
                        'language' => 'fr',
                    ],
                ]
            );        
        }

        $builder->add('corrected',
            CKEditorType::class, [
                "disabled" => ($options["status"]==10),
                "required" => false,
                "config" => [
                    'uiColor' => '#ffffff',
                    'height' => 600,
                    'filebrowserUploadRoute' => 'app_ckeditor_upload',
                    'language' => 'fr',
                ],
            ]
        );         
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class'    => 'App\Entity\Activity',
            'mode'          => 'string',
            'status'        => 'integer',
            'maxanwsered'   => 'integer',
        ));
    }
}
