<?php

namespace App\Entity;

use App\Repository\SurveyguestRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass=SurveyguestRepository::class)
 */
class Surveyguest
{
    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(name="email", type="string", length=255)
     */
    private $email;

    /**
     * @ORM\Column(name="display_name", type="string", length=50)
     */
    private $displayName;

    /**
     * @ORM\Column(name="keyaccess", type="string", length=255)
     */
    private $key;

    /**
     * @ORM\Column(name="tonotifyguest", type="boolean")
     */
    private $tonotifyguest;    

    /**
     * @ORM\Column(name="tonotifyowner", type="boolean")
     */
    private $tonotifyowner;        

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\Survey", inversedBy="surveyguests")
     */
    private $survey;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\User", inversedBy="surveyguests")
     */
    private $user;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\Surveyvote", mappedBy="surveyguest", cascade={"persist"}, orphanRemoval=true)
     */
    private $surveyvotes;


    /**
     * Calculate
     * jsonsurveyvotes = formatage des votes du guest en une chaine json
     */
    private $jsonsurveyvotes;

    public function __construct()
    {
        $this->surveyvotes = new ArrayCollection();
    }


    public function setJsonsurveyvotes(string $jsonsurveyvotes): self
    {
        $this->jsonsurveyvotes = $jsonsurveyvotes;

        return $this;
    }

    public function getJsonsurveyvotes(): ?string
    {
        return $this->jsonsurveyvotes;
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getEmail(): ?string
    {
        return $this->email;
    }

    public function setEmail(string $email): self
    {
        $this->email = $email;

        return $this;
    }

    public function getDisplayName(): ?string
    {
        return $this->displayName;
    }

    public function setDisplayName(string $displayName): self
    {
        $this->displayName = $displayName;

        return $this;
    }

    public function getKey(): ?string
    {
        return $this->key;
    }

    public function setKey(string $key): self
    {
        $this->key = $key;

        return $this;
    }

    public function getTonotifyguest(): ?bool
    {
        return $this->tonotifyguest;
    }

    public function setTonotifyguest(bool $tonotifyguest): self
    {
        $this->tonotifyguest = $tonotifyguest;

        return $this;
    }

    public function getTonotifyowner(): ?bool
    {
        return $this->tonotifyowner;
    }

    public function setTonotifyowner(bool $tonotifyowner): self
    {
        $this->tonotifyowner = $tonotifyowner;

        return $this;
    }

    public function getSurvey(): ?Survey
    {
        return $this->survey;
    }

    public function setSurvey(?Survey $survey): self
    {
        $this->survey = $survey;

        return $this;
    }

    public function getUser(): ?User
    {
        return $this->user;
    }

    public function setUser(?User $user): self
    {
        $this->user = $user;

        return $this;
    }

    /**
     * @return Collection|Surveyvote[]
     */
    public function getSurveyvotes(): Collection
    {
        return $this->surveyvotes;
    }

    public function addSurveyvote(Surveyvote $surveyvote): self
    {
        if (!$this->surveyvotes->contains($surveyvote)) {
            $this->surveyvotes[] = $surveyvote;
            $surveyvote->setSurveyguest($this);
        }

        return $this;
    }

    public function removeSurveyvote(Surveyvote $surveyvote): self
    {
        if ($this->surveyvotes->removeElement($surveyvote)) {
            // set the owning side to null (unless already changed)
            if ($surveyvote->getSurveyguest() === $this) {
                $surveyvote->setSurveyguest(null);
            }
        }

        return $this;
    }

   
}
