<?php
namespace App\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;


class QuestguestType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder->add('jsonquestvotes', 
            HiddenType::class, [
                'label' => 'jsonquestvotes',
                'required' => false,
                'empty_data' => '',                  
            ]
        );
    
        if($options['status']==0) {
            $builder->add('submit',
                SubmitType::class, [
                    "label" => "Enregistrer mes réponses",
                    "attr" => ["class" => "btn btn-success no-print", "style" => "width:100%; font-size:200%"],
                ]
            );
        }
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class'    => 'App\Entity\Questguest',
            'status'        => 'string',
        ));
    }
}
