<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Form\FormError;
use App\Form\CreateQuestFlow;
use Ramsey\Uuid\Uuid;

use Symfony\Component\HttpKernel\KernelInterface;
use Symfony\Component\Filesystem\Filesystem;
use Symfony\Component\HttpFoundation\BinaryFileResponse;
use Symfony\Component\HttpFoundation\ResponseHeaderBag;

use App\Entity\Quest;
use App\Entity\Questoption;
use App\Entity\Questguest;
use App\Entity\Questvote;
use App\Form\QuestguestType as QuestguestType;
use App\Form\QuestkeyType as QuestkeyType;
use App\Form\QueststatusType as QueststatusType;

class QuestController extends AbstractController
{
    private $knpSnappy;
    private $appKernel;

    public function __construct(KernelInterface $appKernel,\Knp\Snappy\Pdf $knpSnappy)
    {
        $this->appKernel = $appKernel;
        $this->knpSnappy = $knpSnappy;
    }

    public function list()
    {
        $questguests=$this->getUser()->getQuestguests();

        return $this->render('Quest/quest.html.twig', [
            'useheader'   => true,
            'usesidebar'  => false,                 
            'questguests' => $questguests,
        ]);
    }

    public function submit(CreateQuestFlow $flow)
    {
        $em = $this->getDoctrine()->getManager();
        $key = Uuid::uuid4();
        $quest = new Quest();
        $quest->setUser($this->getUser());
        $quest->setKey($key);
        $quest->setPrivate(true);
        $quest->setNotification(true);
        $quest->setStatus(0);
        $quest->setTonotifyclose(false);
        $quest->setTonotifyopen(false);

        $flow->bind($quest);
        $form = $flow->createForm();

        $return = $this->edit($flow,$form,$quest);

        if($return) return $this->redirect($this->generateUrl('app_quest'));

        return $this->render('Quest/edit.html.twig',[
            'useheader'         => true,
            'usesidebar'        => false,
            'form'              => $form->createView(),
            'flow'              => $flow,
            'quest'            => $quest,
        ]);        
    }
    
    public function update($id,CreateQuestFlow $flow)
    {
        $em = $this->getDoctrine()->getManager();
        $quest=$em->getRepository("App:Quest")->find($id);

        // Construction de la chaine jsonquestoptions
        $questoptions=$em->getRepository("App:Questoption")->findBy(["quest"=>$quest],["roworder"=>"ASC"]);
        $tboptions=[];
        foreach($questoptions as $questoption) {
            $roworder=$questoption->getRoworder();

            $tboptions[$roworder]=[
                "id"=>$questoption->getId(),
                "code"=>$questoption->getCode(),
                "roworder"=>$questoption->getRoworder(),
                "name"=>$questoption->getName(),
                "required"=>$questoption->getRequired(),
                "type"=>$questoption->getType(),
                "parameters"=>implode(";",$questoption->getParameters()),
            ];
        }

        $jsonquestoptions="[";
        $i=0;
        foreach($tboptions as $option) {
            if($i>0) $jsonquestoptions.=",";
            $jsonquestoptions.=json_encode($option);
            $i++;
            
        }
        $jsonquestoptions.="]";
        $quest->setJsonquestoptions($jsonquestoptions);

        // Construction de la chaine jsonquestguests
        $questguests=$em->getRepository("App:Questguest")->findBy(["quest"=>$quest],["email"=>"ASC"]);
        $tbquestguests=[];
        foreach($questguests as $questguest) {
            array_push($tbquestguests,$questguest->getEmail());
        }
        $quest->setJsonquestguests(json_encode($tbquestguests));

        $flow->bind($quest);
        $form = $flow->createForm();

        $return = $this->edit($flow,$form,$quest);
        if($return) return $this->redirect($this->generateUrl('app_quest'));
        
        return $this->render('Quest/edit.html.twig',[
            'useheader'         => true,
            'usesidebar'        => false,
            'form'              => $form->createView(),
            'flow'              => $flow,
            'quest'             => $quest,
            'id'                => $id,
        ]);        
    }

    private function edit(CreateQuestFlow &$flow,&$form,$quest)
    {
        $em = $this->getDoctrine()->getManager();

        // On s'assure que le quest appartient bien à l'utilisateur
        if($this->getUser()!=$quest->getUser()) {
            return $this->redirect($this->generateUrl('app_quest'));
        }

        if ($flow->isValid($form)) {
            // Controle de validité étape questoptions
            if($flow->getCurrentStepNumber()=="2") {
                $data=$form->getData();

                $jsonquestoptions=$data->getJsonquestoptions();
                if(!$jsonquestoptions||$jsonquestoptions=="[]") {
                    $form->addError(new FormError("Votre enquête doit comporter au minimum une question")); 
                }
                
                $fgerrname=false;
                $fgerrrequired=false;
                $fgerrtype=false;
                $fgerrparameters=false;
                $json=json_decode($jsonquestoptions);
                foreach($json as $option) {
                    if($option->name==""&&!$fgerrname) {
                        $fgerrname=true;
                        $form->addError(new FormError("Les intitulés de question sont obligatoire")); 
                    }
                    if($option->required==""&&!$fgerrrequired) {
                        $fgerrrequired=true;
                        $form->addError(new FormError("Vous devez préciser si les questions sont obligatoire ou non")); 
                    }
                    if($option->type==""&&!$fgerrtype) {
                        $fgerrtype=true;
                        $form->addError(new FormError("Vous devez préciser si le type sur l'ensemble des questions")); 
                    }  
                    if($option->type=="110"&&$option->parameters==""&&!$fgerrparameters) {
                        $fgerrparameters=true;
                        $form->addError(new FormError("Vous devez préciser les valeurs de choix sur l'ensemble des questions de type choix")); 
                    }                                        
                    
                }
                
                $errors = $form->getErrors();
                foreach( $errors as $error ) {
                    $this->get('session')->getFlashBag()->add("error", $error->getMessage());
                }
            }

            // Controle de validité étape questguests
            if($flow->getCurrentStepNumber()=="3") {
                $data=$form->getData();

                if($quest->getPrivate()) {
                    $jsonquestguests=$data->getJsonquestguests();
                    if(!$jsonquestguests||$jsonquestguests=="[]") {
                        $form->addError(new FormError("Votre enquête doit comporter au minimum un invité")); 
                    }

                    $errors = $form->getErrors();
                    foreach( $errors as $error ) {
                        $this->get('session')->getFlashBag()->add("error", $error->getMessage());
                    }
                }
            }


            if($form->isValid($form)) {
                $flow->saveCurrentStepData($form);
                
                if ($flow->nextStep()) {
                    $form = $flow->createForm();
                } else {
                    // Sauvegarde du sondage
                    $em->persist($quest);
                    
                    // Sauvegarde des questoptions
                    $data=$form->getData();
                    $jsonquestoptions=json_decode($data->getJsonquestoptions());
                    $tbquestoptions=[];
                    foreach($jsonquestoptions as $option) {                          
                        $questoption=$em->getRepository("App:Questoption")->findOneBy(["code"=>$option->code,"quest"=>$quest]);
                        if(!$questoption) {
                            $questoption=new Questoption();
                            $questoption->setCode($option->code);
                            $questoption->setQuest($quest);
                            $questoption->setName($option->name);
                            $questoption->setRoworder($option->roworder);
                            $questoption->setRequired($option->required);
                            $questoption->setType($option->type);
                            $questoption->setParameters(explode(";",$option->parameters));
                            $em->persist($questoption);
                        }
                    }

                    // Sauvegarde des invités
                    if($quest->getPrivate()) {
                        $data=$form->getData();
                        $jsonquestguest=json_decode($data->getJsonquestguests());
                        $tbquestguests=[];

                        // On ajoute le propriétaire du sondage en tant qu'invité si ce n'est pas le cas
                        if(!in_array($this->getUser()->getEmail(),$jsonquestguest)) array_push($jsonquestguest,$this->getUser()->getEmail());
                    
                        foreach($jsonquestguest as $email) {
                            array_push($tbquestguests,$email);
                            $user=$em->getRepository("App:User")->findOneBy(["email"=>$email]);

                            $questguest=$em->getRepository("App:Questguest")->findOneBy(["email"=>$email,"quest"=>$quest]);
                            if(!$questguest) {
                                $key = Uuid::uuid4();
                                $displayname=$email;
                                $tonotifyquestguest=true;
                                if($user) {
                                    $displayname=$user->getDisplayname();
                                    $tonotifyquestguest=($user!=$this->getUser());
                                }

                                $questguest=new Questguest();
                                $questguest->setEmail($email);
                                $questguest->setDisplayname($displayname);
                                $questguest->setKey($key);
                                $questguest->setQuest($quest);
                                $questguest->setTonotifyguest($tonotifyquestguest);
                                $questguest->setTonotifyowner(false);
                            }
                            $questguest->setUser($user);
                            $em->persist($questguest);

                        }

                        // Suppression des invités obsolète
                        $questguests=$quest->getQuestguests();
                        foreach($questguests as $questguest) {
                            if(!in_array($questguest->getEmail(),$tbquestguests)) {
                                $em->remove($questguest);
                            }
                        }
                    } 
                    else {
                        // On ajoute qu'il arrive le propriétaire en tant qu'invité
                        $questguest=$em->getRepository("App:Questguest")->findOneBy(["email"=>$this->getUser()->getEmail(),"quest"=>$quest]);
                        if(!$questguest) {
                            $key = Uuid::uuid4();
                            $questguest=new Questguest();
                            $questguest->setEmail($this->getUser()->getEmail());
                            $questguest->setDisplayname($this->getUser()->getDisplayname());
                            $questguest->setKey($key);
                            $questguest->setQuest($quest);
                            $questguest->setTonotifyguest(false);
                            $questguest->setTonotifyowner(false);
                        }                        
                        $questguest->setUser($this->getUser());
                        $em->persist($questguest);
                    }

                    $em->flush();
                    $flow->reset();
                    return true;
                }   
            }
        }

        return false;
    }

    public function delete($id,Request $request)
    {
        // Initialisation de l'enregistrement
        $em = $this->getDoctrine()->getManager();
        $quest=$em->getRepository("App:Quest")->find($id);

        // On s'assure que le quest appartient bien à l'utilisateur
        if($this->getUser()!=$quest->getUser()) {
            return $this->redirect($this->generateUrl('app_quest'));
        }
        
        // Suppression
        $em->remove($quest);
        $em->flush();

        return $this->redirect($this->generateUrl('app_quest'));
    } 

    public function closeopen($id,$status,Request $request) {
        // Initialisation de l'enregistrement
        $em = $this->getDoctrine()->getManager();
        $quest=$em->getRepository("App:Quest")->find($id);

        // On s'assure que le quest appartient bien à l'utilisateur
        if($this->getUser()!=$quest->getUser()) {
            return $this->redirect($this->generateUrl('app_quest'));
        }

        $modalclose=false;
        $quest->setStatus($status);
        
        if($status==1) {
            $quest->setTonotifyclose(true);
            $quest->setTonotifymessage("Bonjour,<br><br>L'enquête suivante est à présent close : <b>".$quest->getTitle()."</b><br><br>Merci de votre réponse.<br><br>Vous pouvez consulter les résultats de l'enquête via le lien ci-après: <a href='#LINK#'>accéder au résultat de l'enquête</a><br><br>Cordialement<br>".$quest->getUser()->getDisplayname());
        }
        else {
            $quest->setTonotifyopen(true);
            $quest->setTonotifymessage("Bonjour,<br><br>L'enquête suivante est à présent réouverte: <b>".$quest->getTitle()."</b><br><br>Vous pouvez de nouveau modifier vos réponses via le lien ci-après: <a href='#LINK#'>accéder à l'enquête</a>.<br><br>Cordialement<br>".$quest->getUser()->getDisplayname());
        }

        // Création du formulaire
        $form = $this->createForm(QueststatusType::class,$quest,array("status"=>$status));

        // Récupération des data du formulaire
        $form->handleRequest($request);

        // Sur validation
        if ($form->get('submit')->isClicked() && $form->isValid()) {  
            $data = $form->getData();  
           
            $em->persist($data);
            $em->flush();

            // Retour à la liste
            $modalclose=true;
        }

        return $this->render('Quest/status.html.twig',[
            'useheader'         => false,
            'usesidebar'        => false,
            'form'              => $form->createView(),
            'modalclose'        => $modalclose,
        ]);        
    }

    public function byuserkey($key,Request $request)
    {
        $em = $this->getDoctrine()->getManager();

        // Recherche de l'utilisateur dans le sondage
        $questguest = $em->getRepository("App:Questguest")->findOneBy(["quest"=>$key,"user"=>$this->getUser()]);
        if(!$questguest) {
            return $this->render('Response/nokey.html.twig',[
                'useheader'         => true,
                'usesidebar'        => false,
            ]);
        }            

        $return = $this->questvote($request,$form,$questguest,"byuserkey");
        if($return) return $this->redirect($this->generateUrl('app_quest'));

        return $this->render('Response/questvote.html.twig',[
            'useheader'         => true,
            'usesidebar'        => false,
            'questguest'        => $questguest,
            'form'              => $form->createView(),
            'by'                => "byuserkey",
        ]);
    }

    public function byguestkey($key,Request $request)
    {
        $em = $this->getDoctrine()->getManager();

        // Recherche de la clé d'invitation
        $questguest = $em->getRepository("App:Questguest")->findOneBy(["key"=>$key]);

        if(!$questguest) {
            return $this->render('Response/nokey.html.twig',[
                'useheader'         => true,
                'usesidebar'        => false,
            ]);
        }            

        $this->questvote($request,$form,$questguest,"byguestkey");

        return $this->render('Response/questvote.html.twig',[
            'useheader'         => true,
            'usesidebar'        => false,
            'questguest'        => $questguest,
            'form'              => $form->createView(),
            'by'                => "byguestkey",
        ]);
    }

    public function byquestkey($key,Request $request)
    {
        $em = $this->getDoctrine()->getManager();

        // Recherche de la clé d'invitation
        $quest = $em->getRepository("App:Quest")->findOneBy(["key"=>$key]);
        if(!$quest) {
            return $this->render('Response/nokey.html.twig',[
                'useheader'         => true,
                'usesidebar'        => false,
            ]);
        }   

        // S'assurer que le sondage est public
        if($quest->getPrivate()) {
            return $this->render('Response/nokey.html.twig',[
                'useheader'         => true,
                'usesidebar'        => false,
            ]);
        }

        // Si la personne est déjà connectée : on génère une invitation et on le redirige via un accès user
        if($this->getUser()) {
            $questguest = $em->getRepository("App:Questguest")->findOneBy(["quest"=>$quest,"user"=>$this->getUser()]);
            if(!$questguest) {
                $key = Uuid::uuid4();
                $email=$this->getUser()->getEmail();
                $displayname=$this->getUser()->getDisplayname();
                $tonotifyquestguest=true;

                $questguest=new Questguest();
                $questguest->setEmail($email);
                $questguest->setDisplayname($displayname);
                $questguest->setKey($key);
                $questguest->setQuest($quest);
                $questguest->setTonotifyguest($tonotifyquestguest);
                $questguest->setTonotifyowner(false);
                $questguest->setUser($this->getUser());
                $em->persist($questguest);
                $em->flush();                
            }

            return $this->redirect($this->generateUrl('app_quest_byuserkey',["key"=>$quest->getId()])); 
        }
        

        // Initialisation de l'enregistrement
        $data = new Questguest();

        // Création du formulaire
        $form = $this->createForm(QuestkeyType::class,$data);

        // Récupération des data du formulaire
        $form->handleRequest($request);

        // S'assurer que la personne n'a pas déjà voté
        // Si c'est le cas il ne devrait plus utiliser cette url
        // On lui retourne l'url associé à son questvote
        if ($form->get('submit')->isClicked()) {
            $data = $form->getData();  
            $email=$data->getEmail();
            $questguest=$em->getRepository("App:Questguest")->findOneBy(["quest"=>$quest,"email"=>$email]);
            if($questguest) {
               $questguest->setTonotifyguest(true);
               $em->persist($questguest);
               $em->flush(); 
               
               // Initialiser l'erreur
               $form->addError(new FormError("Une personne a déjà utiliser ce mail pour répondre au sondage.<br>Si vous êtes cette personne vous allez recevoir un mail vous indiquant l'url d'accès pour modifier ou visualiser votre réponse"));
               $this->get('session')->getFlashBag()->clear();
               $errors = $form->getErrors();
               foreach( $errors as $error ) {
                   $request->getSession()->getFlashBag()->add("error", $error->getMessage());
               }               
            }
        }
        
        if ($form->get('submit')->isClicked()&&$form->isValid()) {
            $user=$em->getRepository("App:User")->findOneBy(["email"=>$email]);

            $questguest=$em->getRepository("App:Questguest")->findOneBy(["email"=>$email,"quest"=>$quest]);
            if(!$questguest) {
                $key = Uuid::uuid4();
                $displayname=$data->getDisplayname();
                $tonotifyquestguest=true;

                $questguest=new Questguest();
                $questguest->setEmail($email);
                $questguest->setDisplayname($displayname);
                $questguest->setKey($key);
                $questguest->setQuest($quest);
                $questguest->setTonotifyguest($tonotifyquestguest);
                $questguest->setTonotifyowner(false);
            }
            $questguest->setUser($user);
            $em->persist($questguest);
            $em->flush();

            return $this->redirect($this->generateUrl('app_quest_byguestkey',["key"=>$questguest->getKey()])); 
        }

        return $this->render('Quest/byquestkey.html.twig',[
            'useheader'         => false,
            'usesidebar'        => false,
            'quest'             => $quest,
            'key'               => $key,
            'form'              => $form->createView(),
        ]);
    }    

    public function byloginkey($key,Request $request) {
        $em = $this->getDoctrine()->getManager();

        // Recherche de la clé d'invitation
        $quest = $em->getRepository("App:Quest")->findOneBy(["key"=>$key]);
        if(!$quest) {
            return $this->render('Response/nokey.html.twig',[
                'useheader'         => true,
                'usesidebar'        => false,
            ]);
        }   

        // S'assurer que le sondage est public
        if($quest->getPrivate()) {
            return $this->render('Response/nokey.html.twig',[
                'useheader'         => true,
                'usesidebar'        => false,
            ]);
        }

        // Si la personne est déjà connectée : on génère une invitation et on le redirige via un accès user
        if($this->getUser()) {
            $questguest = $em->getRepository("App:Questguest")->findOneBy(["quest"=>$quest,"user"=>$this->getUser()]);
            if(!$questguest) {
                $key = Uuid::uuid4();
                $email=$this->getUser()->getEmail();
                $displayname=$this->getUser()->getDisplayname();
                $tonotifyquestguest=true;

                $questguest=new Questguest();
                $questguest->setEmail($email);
                $questguest->setDisplayname($displayname);
                $questguest->setKey($key);
                $questguest->setQuest($quest);
                $questguest->setTonotifyguest($tonotifyquestguest);
                $questguest->setTonotifyowner(false);
                $questguest->setUser($this->getUser());
                $em->persist($questguest);
                $em->flush();                
            }

            return $this->redirect($this->generateUrl('app_quest_byuserkey',["key"=>$quest->getId()])); 
        }        

        return $this->render('Response/nokey.html.twig',[
            'useheader'         => true,
            'usesidebar'        => false,
        ]);
    }

    private function questvote(&$request,&$form,&$questguest,$by) {
        $em = $this->getDoctrine()->getManager();

        // Construction de la chaine jsonquestvotes
        $questoptions=$em->getRepository("App:Questoption")->findBy(["quest"=>$questguest->getQuest()],["roworder"=>"ASC"]);
        $tbquestvotes=[];
        foreach($questoptions as $questoption) {
            $code=$questoption->getCode();
            $type=$questoption->getType();

            if(!array_key_exists($code,$tbquestvotes)) {
                $tbquestvotes[$code]=["code"=>$code,"val"=>"","type"=>$type];
            }

            $questvote=$em->getRepository("App:Questvote")->findOneBy(["questguest"=>$questguest,"questoption"=>$questoption]);
            if($questvote)
            $tbquestvotes[$code]["val"]=(!is_null($questvote->getVote())?$questvote->getVote():"");
        }

        $jsonquestvotes="[";
        $i=0;
        foreach($tbquestvotes as $questvote) {
            if($i>0) $jsonquestvotes.=",";
            $jsonquestvotes.=json_encode($questvote);
            $i++;
            
        }
        $jsonquestvotes.="]";
        $questguest->setJsonquestvotes($jsonquestvotes);

        // Création du formulaire
        $form = $this->createForm(QuestguestType::class,$questguest,["status"=>$questguest->getQuest()->getStatus()]);

        // Récupération des data du formulaire
        $form->handleRequest($request);
        
        // Si validation
        if($questguest->getQuest()->getStatus()==0) {
            if ($form->get('submit')->isClicked() && $form->isValid()) {
                $data=$form->getData();
                $jsonquestvotes=json_decode($data->getJsonquestvotes());

                foreach($jsonquestvotes as $toquestvote) {
                    $questoption=$em->getRepository("App:Questoption")->findOneBy(["quest"=>$questguest->getQuest(),"code"=>$toquestvote->code]);
                    if($questoption) {
                        $questvote=$em->getRepository("App:Questvote")->findOneBy(["questguest"=>$questguest,"questoption"=>$questoption]);
                        if(!$questvote) {
                            $questvote= new Questvote();
                            $questvote->setQuestguest($questguest);
                            $questvote->setQuestoption($questoption);
                        }

                        $questvote->setVote($toquestvote->val==""?null:$toquestvote->val);
                        $em->persist($questvote);
                        $em->flush();
                    }
                }

                // Si le questvote n'est pas celui du propriétaire : on positionne le flag de notification du owner
                if($questguest->getUser()!=$questguest->getQuest()->getUser()) {
                    $questguest->setTonotifyowner(true);
                    $em->persist($questvote);
                    $em->flush();
                }

                if($by=="byuserkey") return true;
                $this->get('session')->getFlashBag()->add("notice", "Votre réponse a bien été prise en compte.<br>Vous pouvez à tout moment modifier vos réponses via le lien qui vous a été transmis par mail.");
            }
        }
        else 
            $this->get('session')->getFlashBag()->add("notice", "Cette enquête est close");

        return false;
    }

    public function result($id,Request $request,$access="") {
        // Type pdf / css
        $type=$request->get('type');
        if($access!="") $type="";
        
        $em = $this->getDoctrine()->getManager();
        $quest=$em->getRepository("App:Quest")->find($id);
        $questguests=$em->getRepository("App:Questguest")->findBy(["quest"=>$quest]);
        $questoptions=$em->getRepository("App:Questoption")->findBy(["quest"=>$quest],["roworder"=>"ASC"]);

        // On s'assure que le quest appartient bien à l'utilisateur
        if($this->getUser()!=$quest->getUser()&&$access=="") {
            return $this->redirect($this->generateUrl('app_quest'));
        }

        $graphs=[];
        $tbcolor=array("red"=>"#CF000F","green"=>"#3FC380","blue"=>"#446CB3","orange"=>"#F89406");
        foreach($questoptions as $option) {
            $questvotes=$option->getQuestvotes();
            if(!empty($questvotes)) {
                // Initialisation du tableau de données consolidées
                switch($option->getType()) {
                    // type = oui / non
                    case 10:
                        $tmp=[];
                        $tmp["datacode"]=$option->getCode();
                        $tmp["dataname"]=$option->getName();
                        $tmp["datatype"]="donut";
                        $tmp["data"]=[
                            0 => ["total"=>0,"label"=>"non","color"=>$tbcolor["red"]],
                            1 => ["total"=>0,"label"=>"oui","color"=>$tbcolor["green"]],
                        ];                    

                        $graphs[$option->getRoworder()]=$tmp;
                        break;

                    // Type oui / non=0 / peut-être
                    // Type oui / non=0 / en partie
                    case 20:
                    case 30:
                        $tmp=[];
                        $tmp["datacode"]=$option->getCode();
                        $tmp["dataname"]=$option->getName();
                        $tmp["datatype"]="donut";
                        $tmp["data"]=[
                            0 => ["total"=>0,"label"=>"non","color"=>$tbcolor["red"]],
                            1 => ["total"=>0,"label"=>"oui","color"=>$tbcolor["green"]],
                            2 => ["total"=>0,"label"=>($option->getType()=="20"?"peut-être":"en partie"),"color"=>$tbcolor["orange"]],
                        ];
                        $graphs[$option->getRoworder()]=$tmp;
                        break;  
                        
                    // Type = Très Satisfait / Satisfait / Peu Satisfait /Insatisfait
                    case 40:
                    case 50:
                        $tmp=[];
                        $tmp["datacode"]=$option->getCode();
                        $tmp["dataname"]=$option->getName();
                        $tmp["datatype"]="donut";
                        $tmp["data"]=[
                            0 => ["total"=>0,"label"=>"Très Satisfait","color"=>$tbcolor["green"]],
                            1 => ["total"=>0,"label"=>"Satisfait","color"=>$tbcolor["blue"]],
                            2 => ["total"=>0,"label"=>"Peu Satisfait","color"=>$tbcolor["orange"]],
                            3 => ["total"=>0,"label"=>"Insatisfait","color"=>$tbcolor["red"]]
                        ];
                        $graphs[$option->getRoworder()]=$tmp;
                        break;   
                        
                    // Type Note
                    case 60:
                    case 70:
                    case 80:
                        switch($option->getType()) {
                            case 60:$datamax=5; break;
                            case 70:$datamax=10; break;
                            case 80:$datamax=20; break;
                        }
                        $tmp=[];
                        $tmp["datacode"]=$option->getCode();
                        $tmp["dataname"]=$option->getName();
                        $tmp["datatype"]="average";
                        $tmp["datamax"]=$datamax;
                        $tmp["data"]=["total"=>0,"count"=>0];
                        $graphs[$option->getRoworder()]=$tmp;
                        break;   
                        
                    // Type = Très Satisfait / Satisfait / Peu Satisfait /Insatisfait
                    case 110:
                        $tmp=[];
                        $tmp["datacode"]=$option->getCode();
                        $tmp["dataname"]=$option->getName();
                        $tmp["datatype"]="donut";
                        $tmp["data"]=[];
                        foreach($option->getParameters() as $parameter) {
                            $tmp["data"][$parameter] = ["total"=>0,"label"=>$parameter,"color"=>('#'.substr(str_shuffle('ABCDEF0123456789'),0,6))];
                        }
                        $graphs[$option->getRoworder()]=$tmp;
                        break;                          
                }

                // Cumule des réponses
                foreach($questvotes as $vote) {                
                    $val=explode("||||",$vote->getVote())[0];
                    switch($option->getType()) {
                        // Type donut
                        case 10:
                        case 20:
                        case 30:
                        case 40:
                        case 50:
                        case 110;
                            $graphs[$option->getRoworder()]["data"][$val]["total"]++;
                            break;

                        // Type Moyenne
                        case 60:
                        case 70:
                        case 80:
                            $graphs[$option->getRoworder()]["data"]["total"]+=$val;
                            $graphs[$option->getRoworder()]["data"]["count"]++;
                            break;                            
                    }
                }
            }
        }
        
        if($type=="pdf") {
            $rootdir = $this->appKernel->getProjectDir();
            $filename="Enquete-".str_pad($id,5,"0",STR_PAD_LEFT).".pdf";
            $fileloc=$rootdir."/uploads/quest/$id/".$filename;

            $fs = new Filesystem();
            $fs->remove(array($fileloc));    

            $render = $this->renderView('Quest/result.html.twig',[
                'useheader'         => false,
                'usesidebar'        => false,
                'sondeUse'          => false,
                'quest'             => $quest,
                'questguests'       => $questguests,
                'graphs'            => $graphs,
                'type'              => $type,
                'access'            => $access,
            ]);

            $render=str_replace("/ninesurvey/","https://ninegate.ac-arno.fr/ninesurvey/",$render);
            $this->knpSnappy->generateFromHtml($render,$fileloc);
            return $this->file($fileloc);                            
        }
        elseif($type=="csv") {
            $rootdir = $this->appKernel->getProjectDir()."/uploads/quest/$id";
            $filename="Enquete-".str_pad($id,5,"0",STR_PAD_LEFT).".csv";
            $fs = new Filesystem();
            $fs->mkdir($rootdir);
            $csvh = fopen($rootdir."/".$filename, 'w');
            $d = ';'; // this is the default but i like to be explicit
            $e = '"'; // this is the default but i like to be explicit

            $data=["id","Login","Nom","Prénom","Email","Téléphone"];
            fputcsv($csvh, $data, $d, $e);
            fclose($csvh);        
            $response = new BinaryFileResponse($rootdir."/".$filename);
            $response->setContentDisposition(ResponseHeaderBag::DISPOSITION_ATTACHMENT);
            return $response;            
        }
        else {
            return $this->render('Quest/result.html.twig',[
                'useheader'         => true,
                'usesidebar'        => false,
                'quest'             => $quest,
                'questguests'       => $questguests,
                'graphs'            => $graphs,
                'access'            => $access,
            ]);      
        }
    }

    public function resultbyguestkey($key,Request $request)
    {
        $em = $this->getDoctrine()->getManager();

        // Recherche de la clé d'invitation
        $questguest = $em->getRepository("App:Questguest")->findOneBy(["key"=>$key]);

        if(!$questguest) {
            return $this->render('Response/nokey.html.twig',[
                'useheader'         => true,
                'usesidebar'        => false,
            ]);
        }            
        //return new Response();
        return $this->result($questguest->getQuest()->getId(),$request,"byguestkey");
    } 
    

    public function resultbyuserkey($key,Request $request)
    {
        $em = $this->getDoctrine()->getManager();

        // Recherche de l'utilisateur dans le sondage
        $questguest = $em->getRepository("App:Questguest")->findOneBy(["quest"=>$key,"user"=>$this->getUser()]);
        if(!$questguest) {
            return $this->render('Response/nokey.html.twig',[
                'useheader'         => true,
                'usesidebar'        => false,
            ]);
        }  

        //return new Response();
        return $this->result($questguest->getQuest()->getId(),$request,"byuserkey");
    }     
}
