<?php

namespace App\Entity;

use App\Repository\GuestRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass=App\Repository\QuestguestRepository::class)
 */
class Questguest
{
    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(name="email", type="string", length=255)
     */
    private $email;

    /**
     * @ORM\Column(name="display_name", type="string", length=50)
     */
    private $displayName;

    /**
     * @ORM\Column(name="keyaccess", type="string", length=255)
     */
    private $key;

    /**
     * @ORM\Column(name="tonotifyguest", type="boolean")
     */
    private $tonotifyguest;    

    /**
     * @ORM\Column(name="tonotifyowner", type="boolean")
     */
    private $tonotifyowner;        

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\Quest", inversedBy="questguests")
     */
    private $quest;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\User", inversedBy="questguests")
     */
    private $user;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\Questvote", mappedBy="questguest", cascade={"persist"}, orphanRemoval=true)
     */
    private $questvotes;

    /**
     * Calculate
     * jsonvotes = formatage des votes du guest en une chaine json
     */
    private $jsonquestvotes;
    public function setJsonquestvotes(string $jsonquestvotes): self
    {
        $this->jsonquestvotes = $jsonquestvotes;

        return $this;
    }

    public function getJsonquestvotes(): ?string
    {
        return $this->jsonquestvotes;
    }

    public function __construct()
    {
        $this->questvotes = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getEmail(): ?string
    {
        return $this->email;
    }

    public function setEmail(string $email): self
    {
        $this->email = $email;

        return $this;
    }

    public function getDisplayName(): ?string
    {
        return $this->displayName;
    }

    public function setDisplayName(string $displayName): self
    {
        $this->displayName = $displayName;

        return $this;
    }

    public function getKey(): ?string
    {
        return $this->key;
    }

    public function setKey(string $key): self
    {
        $this->key = $key;

        return $this;
    }

    public function getTonotifyguest(): ?bool
    {
        return $this->tonotifyguest;
    }

    public function setTonotifyguest(bool $tonotifyguest): self
    {
        $this->tonotifyguest = $tonotifyguest;

        return $this;
    }

    public function getTonotifyowner(): ?bool
    {
        return $this->tonotifyowner;
    }

    public function setTonotifyowner(bool $tonotifyowner): self
    {
        $this->tonotifyowner = $tonotifyowner;

        return $this;
    }

    public function getQuest(): ?Quest
    {
        return $this->quest;
    }

    public function setQuest(?Quest $quest): self
    {
        $this->quest = $quest;

        return $this;
    }

    public function getUser(): ?User
    {
        return $this->user;
    }

    public function setUser(?User $user): self
    {
        $this->user = $user;

        return $this;
    }

    /**
     * @return Collection|Questvote[]
     */
    public function getQuestvotes(): Collection
    {
        return $this->questvotes;
    }

    public function addQuestvote(Questvote $questvote): self
    {
        if (!$this->questvotes->contains($questvote)) {
            $this->questvotes[] = $questvote;
            $questvote->setQuestguest($this);
        }

        return $this;
    }

    public function removeQuestvote(Questvote $questvote): self
    {
        if ($this->questvotes->removeElement($questvote)) {
            // set the owning side to null (unless already changed)
            if ($questvote->getQuestguest() === $this) {
                $questvote->setQuestguest(null);
            }
        }

        return $this;
    }

    
}
