SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0;
SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0;
SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='TRADITIONAL,ALLOW_INVALID_DATES';

CREATE SCHEMA IF NOT EXISTS `opensondage` DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci ;
USE `opensondage` ;

-- -----------------------------------------------------
-- Table `opensondage`.`sondages`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `opensondage`.`sondages` (
  `id` INT NOT NULL AUTO_INCREMENT,
  `token` VARCHAR(255) NOT NULL,
  `titre` VARCHAR(150) NULL,
  `commentaire` TEXT NULL,
  `mail_admin` VARCHAR(255) NOT NULL,
  `nom_admin` VARCHAR(255) NOT NULL,
  `notif_mail` INT NULL DEFAULT 0,
  `created` DATETIME NULL,
  `modified` DATETIME NULL,
  `date_end` DATETIME NULL,
  `type` VARCHAR(45) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE INDEX `id_sondage_UNIQUE` (`token` ASC))
ENGINE = MyISAM;


-- -----------------------------------------------------
-- Table `opensondage`.`destinataires`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `opensondage`.`destinataires` (
  `id` INT NOT NULL AUTO_INCREMENT,
  `sondage_id` VARCHAR(255) NOT NULL,
  `mail` VARCHAR(255) NOT NULL,
  `answered` INT NULL DEFAULT 0,
  `date_answered` DATETIME NULL,
  PRIMARY KEY (`id`, `sondage_id`),
  INDEX `fk_destinataires_sondage_idx` (`sondage_id` ASC))
ENGINE = MyISAM
COMMENT = 'Regroupe tous les destinataires des differents sondages.';


-- -----------------------------------------------------
-- Table `opensondage`.`sujets`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `opensondage`.`sujets` (
  `id` INT NOT NULL AUTO_INCREMENT,
  `sondage_id` VARCHAR(255) NOT NULL,
  `value` TEXT NOT NULL,
  PRIMARY KEY (`id`, `sondage_id`),
  INDEX `fk_table1_sondage1_idx` (`sondage_id` ASC))
ENGINE = MyISAM
COMMENT = 'Regroupe les possibilites disponible pour le sondage';


-- -----------------------------------------------------
-- Table `opensondage`.`reponses`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `opensondage`.`reponses` (
  `id` INT NOT NULL AUTO_INCREMENT,
  `sondage_id` VARCHAR(255) NOT NULL,
  `destinataires_id` INT NOT NULL,
  `value` VARCHAR(100) NULL,
  `name` VARCHAR(150) NULL,
  `resp` int(11),
  PRIMARY KEY (`id`, `sondage_id`, `destinataires_id`),
  INDEX `fk_reponses_destinataires1_idx` (`destinataires_id` ASC),
  INDEX `fk_reponses_sondage1_idx` (`sondage_id` ASC))
ENGINE = MyISAM;


SET SQL_MODE=@OLD_SQL_MODE;
SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS;
SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS;
