<?php
// include client class
include_once(dirname(__FILE__).'/eoleclient.php');
// include client class
include_once(dirname(__FILE__).'/CAS.php');

class EolephpCAS extends phpCAS
{
    /*
     * FONCTIONS EOLE
     */
    public static function EoleLogoutRequests($check_client=true, $allowed_clients=false){
            /*
             * Fonction gérant les requêtes de logout centralisées provenant du serveur sso
             * @check_client : should the cas server be checked
             * @allowed_clients : array of trusted clients
             */
            if ( !is_object(self::$_PHPCAS_CLIENT) ) {
                phpCAS::error('this method should not be called before '.__CLASS__.'::client() or '.__CLASS__.'::proxy()');
            }
            return(self::$_PHPCAS_CLIENT->EoleLogoutRequests($check_client, $allowed_clients));
    }
    /*
     * FONCTIONS ECRASEES
     */

    public static function client($server_version,
        $server_hostname,
        $server_port,
        $server_uri,
        $start_session = true)
    {
        /*
         * Fonction d'initialisation du client,
         * écrasée pour appeler utiliser le client eolecasclient au lieu du client classique
         */
        phpCAS::traceBegin();
        if ( is_object(self::$_PHPCAS_CLIENT) ) {
            phpCAS::error(self::$_PHPCAS_INIT_CALL['method'].'() has already been called (at '.self::$_PHPCAS_INIT_CALL['file'].':'.self::$_PHPCAS_INIT_CALL['line'].')');
        }
        if ( gettype($server_version) != 'string' ) {
            phpCAS::error('type mismatched for parameter $server_version (should be `string\')');
        }
        if ( gettype($server_hostname) != 'string' ) {
            phpCAS::error('type mismatched for parameter $server_hostname (should be `string\')');
        }
        if ( gettype($server_port) != 'integer' ) {
            phpCAS::error('type mismatched for parameter $server_port (should be `integer\')');
        }
        if ( gettype($server_uri) != 'string' ) {
            phpCAS::error('type mismatched for parameter $server_uri (should be `string\')');
        }
        // store where the initializer is called from
        $dbg = debug_backtrace();
        self::$_PHPCAS_INIT_CALL = array('done' => TRUE,
            'file' => $dbg[0]['file'],
            'line' => $dbg[0]['line'],
            'method' => __CLASS__.'::'.__FUNCTION__);
        // initialize the object $PHPCAS_CLIENT
        self::$_PHPCAS_CLIENT = new EoleCASClient($server_version,FALSE/*proxy*/,$server_hostname,$server_port,$server_uri,$start_session);
        phpCAS::traceEnd();
    }

    public static function proxy($server_version,
        $server_hostname,
        $server_port,
        $server_uri,
        $start_session = true)
    {
        /*
         * Fonction d'initialisation du proxy,
         * écrasée pour appeler utiliser le client eolecasclient au lieu du client classique
         */
        phpCAS::traceBegin();
        if ( is_object(self::$_PHPCAS_CLIENT) ) {
            phpCAS::error(self::$_PHPCAS_INIT_CALL['method'].'() has already been called (at '.self::$_PHPCAS_INIT_CALL['file'].':'.self::$_PHPCAS_INIT_CALL['line'].')');
        }
        if ( gettype($server_version) != 'string' ) {
            phpCAS::error('type mismatched for parameter $server_version (should be `string\')');
        }
        if ( gettype($server_hostname) != 'string' ) {
            phpCAS::error('type mismatched for parameter $server_hostname (should be `string\')');
        }
        if ( gettype($server_port) != 'integer' ) {
            phpCAS::error('type mismatched for parameter $server_port (should be `integer\')');
        }
        if ( gettype($server_uri) != 'string' ) {
            phpCAS::error('type mismatched for parameter $server_uri (should be `string\')');
        }
        // store where the initializer is called from
        $dbg = debug_backtrace();
        self::$_PHPCAS_INIT_CALL = array('done' => TRUE,
            'file' => $dbg[0]['file'],
            'line' => $dbg[0]['line'],
            'method' => __CLASS__.'::'.__FUNCTION__);
        // initialize the object $_PHPCAS_CLIENT
        self::$_PHPCAS_CLIENT = new EoleCASClient($server_version,TRUE/*proxy*/,$server_hostname,$server_port,$server_uri,$start_session);
        phpCAS::traceEnd();
    }
    /**
     * HACK pour la gestion des propriétés utilisateurs aux modèles CAS
     *
     * Methode de renvoie des details utilisateurs
     ***/
    public static function getDetails()
    {
        /*
         * Renvoie les détails utilisateurs
         */
        if (!is_object(self::$_PHPCAS_CLIENT)) {
            phpCAS :: error('this method should not be called before ' . __CLASS__ . '::client() or ' . __CLASS__ . '::proxy()');
        }
        if (!self::$_PHPCAS_CLIENT->wasAuthenticationCalled()) {
            phpCAS :: error('this method should only be called after ' . __CLASS__ . '::forceAuthentication() or ' . __CLASS__ . '::isAuthenticated()');
        }
        if (!self::$_PHPCAS_CLIENT->wasAuthenticationCallSuccessful()) {
            phpCAS :: error('authentication was checked (by ' . self::$_PHPCAS_CLIENT->getAuthenticationCallerMethod() . '() at ' . self::$_PHPCAS_CLIENT->getAuthenticationCallerFile() . ':' . self::$_PHPCAS_CLIENT->getAuthenticationCallerLine() . ') but the method returned false');
        }
        return self::$_PHPCAS_CLIENT->getDetails();
    }
    public static function getCasXML()
    {
        /*
         * Renvoie le xml cas reçu depuis le serveur
         */
        if (!is_object(self::$_PHPCAS_CLIENT)) {
            phpCAS :: error('this method should not be called before ' . __CLASS__ . '::client() or ' . __CLASS__ . '::proxy()');
        }
        if (!self::$_PHPCAS_CLIENT->wasAuthenticationCalled()) {
            phpCAS :: error('this method should only be called after ' . __CLASS__ . '::forceAuthentication() or ' . __CLASS__ . '::isAuthenticated()');
        }
        if (!self::$_PHPCAS_CLIENT->wasAuthenticationCallSuccessful()) {
            phpCAS :: error('authentication was checked (by ' . self::$_PHPCAS_CLIENT->getAuthenticationCallerMethod() . '() at ' . self::$_PHPCAS_CLIENT->getAuthenticationCallerFile() . ':' . self::$_PHPCAS_CLIENT->getAuthenticationCallerLine() . ') but the method returned false');
        }
        return self::$_PHPCAS_CLIENT->getCasXML();
    }
    public static function hasPGT(){
        /*
         * Fonction hasPGT rajoutée pour confort
         */
        if (!is_object(self::$_PHPCAS_CLIENT)) {
            phpCAS :: error('this method should not be called before ' . __CLASS__ . '::client() or ' . __CLASS__ . '::proxy()');
        }
        if (!self::$_PHPCAS_CLIENT->wasAuthenticationCalled()) {
            phpCAS :: error('this method should only be called after ' . __CLASS__ . '::forceAuthentication() or ' . __CLASS__ . '::isAuthenticated()');
        }
        if (!self::$_PHPCAS_CLIENT->wasAuthenticationCallSuccessful()) {
            phpCAS :: error('authentication was checked (by ' . self::$_PHPCAS_CLIENT->getAuthenticationCallerMethod() . '() at ' . self::$_PHPCAS_CLIENT->getAuthenticationCallerFile() . ':' . self::$_PHPCAS_CLIENT->getAuthenticationCallerLine() . ') but the method returned false');
        }
        return self::$_PHPCAS_CLIENT->hasPGT();
    }
    public static function validatePT(&$validate_url,&$text_response,&$tree_response) {
        if (!is_object(self::$_PHPCAS_CLIENT)) {
            phpCAS :: error('this method should not be called before ' . __CLASS__ . '::client() or ' . __CLASS__ . '::proxy()');
        }
        return (self::$_PHPCAS_CLIENT->validateCAS20($validate_url,$text_response,$tree_response));
    }

}
?>
