<?php
/**
 * Piwik - free/libre analytics platform
 *
 * @link http://piwik.org
 * @license http://www.gnu.org/licenses/gpl-3.0.html GPL v3 or later
 *
 */
namespace Piwik\Plugins\ProfiledVisits;

use Piwik\API\Request;
use Piwik\Archive;
use Piwik\Container\StaticContainer;
use Piwik\DataTable;
use Piwik\Date;
use Piwik\Metrics;
use Piwik\Piwik;
use Piwik\Plugins\Actions\Actions\ActionSiteSearch;

use Piwik\ArchiveProcessor;
use Piwik\Tracker\Cache;
use Piwik\Tracker;

use Piwik\Period;
use Piwik\Period\Range;
use Piwik\DataTable\Row;
use Piwik\Site;
use Piwik\Config;
use Piwik\Db;

/**
 * API for plugin ProfiledVisits
 *
 * @method static \Piwik\Plugins\ProfiledVisits\API getInstance()
 */
class API extends \Piwik\Plugin\API
{

    /**
     * Method to get stats by users profiles
     * 
     * @param int    $idSite
     * @param string $period
     * @param string $date
     * @param bool|string $segment
     * @return DataTable
     */
    public function getUsersprofiles($idSite, $period, $date, $segment = false)
    {
        $table = new DataTable();

        $period = Period\Factory::makePeriodFromQueryParams(Site::getTimezoneFor($idSite), $period, $date);
        $dateStart = $period->getDateStart()->toString('Y-m-d'); // eg. "2009-04-01"
        $dateEnd = $period->getDateEnd()->toString('Y-m-d'); // eg. "2009-04-30"

        $profils = array(
                    'National_1'=>'Élève',
                    'National_2'=>'Responsable',
                    'National_3'=>'Enseignant',
                    'National_4'=>'Personnel de direction',
                    'National_5'=>'Personnel vie scolaire',
                    'National_6'=>'Personnel administratif',
                    'National_7'=>'Autre',
                    ''          =>'Visiteur');


        $cQuery  = "SELECT custom_var_v3, COUNT(DISTINCT(piwik_log_visit.idvisit)) as nb_visits
                    FROM piwik_log_visit
                    
                    WHERE piwik_log_visit.idsite = ?
                    AND piwik_log_visit.visit_first_action_time > ?
                    AND piwik_log_visit.visit_last_action_time < ?
                    GROUP BY piwik_log_visit.custom_var_v3";
        
        $rows=Db::FetchAll($cQuery, array($idSite, $dateStart." 00:00:00", $dateEnd." 23:59:59"));
        foreach($rows as $row) {
            $label=(array_key_exists($row["custom_var_v3"], $profils)?$profils[$row["custom_var_v3"]]:$row["custom_var_v3"]);
            $v = new Row(array(Row::COLUMNS => array('label'=> $label, 'nb_visits'=>$row["nb_visits"])));
            $table->addRow($v);
        }

        /*
        foreach($profils as $pr=>$lib)
        {
            $queryP = "SELECT COUNT(*) as nb_visits FROM piwik_log_visit
                       WHERE idsite = ?
                       AND visit_first_action_time >= ?
                       AND visit_last_action_time <= ?
                       AND custom_var_v3 = ?";

            $hitsP = Db::fetchAll($queryP, array($idSite,$dateStart." 00:00:00", $dateEnd." 23:59:59", $pr));
            $hp = $hitsP[0]['nb_visits'];
            $v = new Row(array(Row::COLUMNS => array('label'=> $lib, 'nb_visits'=>$hp),));
            $table->addRow($v);
        }
        */
        //$table->filter('ExcludeLowPopulation', array('nb_visits', 1));
        return $table;
    }

    /**
     * Method to get stats of used applications in global
     * 
     * @param int    $idSite
     * @param string $period
     * @param string $date
     * @param bool|string $segment
     * @return DataTable
     */
    public function getApplicationsutilisees($idSite, $period, $date, $segment = false)
    {
        return $this->getApps($idSite, $period, $date, false,false);
    }


    /**
     * Method to get stats of used applications by students
     *
     * @param int    $idSite
     * @param string $period
     * @param string $date
     * @param bool|string $segment
     * @return DataTable
     */
    public function getApplicationsEleves($idSite, $period, $date, $segment = false)
    {
        return $this->getApps($idSite, $period, $date, false, 'National_1');
    }


    /**
     * Method to get stats of used applications by teachers
     *
     * @param int    $idSite
     * @param string $period
     * @param string $date
     * @param bool|string $segment
     * @return DataTable
     */
    public function getApplicationsEnseignants($idSite, $period, $date, $segment = false)
    {
        return $this->getApps($idSite, $period, $date, false, 'National_3');
    }


    private function getApps($idSite, $period, $date, $segment = false, $profile = false)
    {
        $table = new DataTable();

        // Sur quelle période ?
        $period = Period\Factory::makePeriodFromQueryParams(Site::getTimezoneFor($idSite), $period, $date);
        $dateStart = $period->getDateStart()->toString('Y-m-d'); // eg. "2009-04-01"
        $dateEnd = $period->getDateEnd()->toString('Y-m-d'); // eg. "2009-04-30"

        // Construction de la Query
        $cQuery  = "SELECT piwik_log_link_visit_action.custom_var_v1, COUNT(DISTINCT(piwik_log_link_visit_action.idvisit)) as nb_visits
                    FROM piwik_log_link_visit_action, piwik_log_visit 
                    
                    WHERE piwik_log_visit.idvisit=piwik_log_link_visit_action.idvisit
                    AND piwik_log_visit.idsite = ?
                    AND piwik_log_visit.visit_first_action_time > ?
                    AND piwik_log_visit.visit_last_action_time < ?";

        if ($profile AND in_array($profile, array('National_1','National_3'))) {
            $cQuery.= " AND piwik_log_visit.custom_var_v3 = ?";
            $cQuery.= " GROUP BY piwik_log_link_visit_action.custom_var_v1";
            $rows=Db::FetchAll($cQuery, array($idSite, $dateStart." 00:00:00", $dateEnd." 23:59:59",$profile));
        }
        else {
            $cQuery.= " GROUP BY piwik_log_link_visit_action.custom_var_v1";
            $rows=Db::FetchAll($cQuery, array($idSite, $dateStart." 00:00:00", $dateEnd." 23:59:59"));
        }
        
        foreach($rows as $row) {
            $v = new Row(array(Row::COLUMNS => array('label'=> $row["custom_var_v1"], 'nb_visits'=>$row["nb_visits"])));
            $table->addRow($v);

        }
        
        return $table;
    }
}
