<?php
namespace Piwik\Plugins\LoginCas;

use Piwik\Container\StaticContainer;
use Piwik\Plugin\Manager;
use Piwik\Plugins\LoginCas\Auth as AuthCas;

class LoginCas extends \Piwik\Plugin
{

    public function registerEvents()
    {
        $hooks = array(
            'Request.initAuthenticationObject'       => 'initAuthenticationObject',
        );
        return $hooks;
    }

    public function activate()
    {
        if (Manager::getInstance()->isPluginActivated("Login") == true) {
            Manager::getInstance()->deactivatePlugin("Login");
        }
    }

    public function deactivate()
    {
        if (Manager::getInstance()->isPluginActivated("Login") == false) {
            Manager::getInstance()->activatePlugin("Login");
        }
    }

    function initAuthenticationObject($activateCookieAuth = false)
    {
        $auth = new AuthCas();
        StaticContainer::getContainer()->set('Piwik\Auth', $auth);
    }
}
