<?php

declare(ticks=1);

include(__DIR__ . '/../include/config.php');
include(__DIR__ . '/../include/function.php');
include(__DIR__ . '/../include/dnma.php');
include(__DIR__ . '/../include/piwik.php');

$queueDir = __DIR__ . '/../queue';
$pollInterval = 5; // secondes

echo "[Watcher] Démarrage du watcher (PID: " . getmypid() . ")\n";

// Activation des signaux asynchrones
pcntl_async_signals(true);

// Gestion propre du signal SIGTERM
pcntl_signal(SIGTERM, function () {
    echo "\n[Watcher] Signal SIGTERM reçu, arrêt propre.\n";
    exit(0);
});

while (true) {
    $files = glob($queueDir . '/*.json');

    foreach ($files as $file) {
        $data = json_decode(file_get_contents($file), true);

        if (!$data) {
            echo "[Watcher] ⚠️ Fichier corrompu ignoré: $file\n";
            unlink($file);
            continue;
        }
        echo "===================================================================================================\n";
        

        switch ($data["type"]) {
            case "dnma":
                echo "[Watcher] ▶ DNMA Traitement\n";
                execDnma($data);
                break;

            case "acad":
                echo "[Watcher] ▶ ACAD Traitement\n";
                execPiwik($sondeacaIdurl, $sondeacaIdsite, $data);
                break;

            case "local":
                echo "[Watcher] ▶ LOCAL Traitement\n";
                execPiwik($weburl.'/piwik', 1, $data);
                break;

            default:
                echo "[Watcher] ⚠️ Type inconnu: " . $data["type"] . "\n";
        }
        
        // Supprimer le fichier après traitement
        unlink($file);
    }

    sleep($pollInterval); // Permet le traitement du signal SIGTERM
}
