# -*- coding: UTF-8 -*-
import os.path as osp
from configparser import ConfigParser

CONFIG_FILE = '/var/lib/eole/config/amon.cfg'

if not osp.isfile(CONFIG_FILE):
    print("Fichier de configuration non existant")
    exit(0)

cfg = ConfigParser(allow_no_value=True)
cfg.read(CONFIG_FILE)
VIRTDISABLED = not cfg.getboolean('eole', 'mode_conteneur_actif')
INTERFACE_GW = cfg.get('eole', 'interface_gw')
DANS_NUM_OPT_FILTERS = cfg.getint('proxy', 'dans_num_opt_filters')
CONTAINER_PATH_PROXY = cfg.get('eole', 'container_path_proxy')
CONTAINER_IP_PROXY = cfg.get('eole', 'container_ip_proxy')
NOMBRE_INTERFACES = cfg.getint('eole', 'nombre_interfaces')
NUM_DANSGUARDIAN_INSTANCE = cfg.getint('proxy', 'num_dansguardian_instance')
ACTIVER_SQUID_AUTH = cfg.getboolean('proxy', 'activer_squid_auth')
ACTIVER_SQUID2 = cfg.getboolean('proxy', 'activer_squid2')
TIMEZONE = cfg.get('eole', 'time_zone')
IP_ETH = []
NETWORK_ETH = []
NETMASK_ETH = []
DANSGUARDIAN_ETH = []
NOM_MACHINE_ETH = []
NOM_CARTE_ETH = {}
VLAN_ETH = []
ALIAS_ETH = []
ACTIVER_PROXY_ETH = []
SQUID_AUTH_ETH = []
for num in range(NOMBRE_INTERFACES):
    num = str(num)
    IP_ETH.append(cfg.get('eole', 'ip_eth' + num))
    NETWORK_ETH.append(cfg.get('eole', 'network_eth' + num))
    NETMASK_ETH.append(cfg.get('eole', 'netmask_eth' + num))
    NOM_MACHINE_ETH.append(cfg.get('eole', 'nom_machine_eth' + num))
    NOM_CARTE_ETH['eth'+num] = cfg.get('eole', 'nom_zone_eth' + num)
    vlan_ip_eth = cfg.get('eole', 'vlan_ip_eth' + num)
    if vlan_ip_eth is None:
        VLAN_ETH.append([])
    else:
        VLAN_ETH.append(vlan_ip_eth.split())
    alias_ip_eth = cfg.get('eole', 'alias_ip_eth' + num)
    if alias_ip_eth is None:
        ALIAS_ETH.append([])
    else:
        ALIAS_ETH.append(alias_ip_eth.split())
    DANSGUARDIAN_ETH.append(cfg.get('proxy', 'dansguardian_eth' + num))
    ACTIVER_PROXY_ETH.append(cfg.get('proxy', 'activer_proxy_eth' + num))
    SQUID_AUTH_ETH.append(cfg.get('proxy', 'squid_auth_eth' + num))

# liste des ports liés à la navigation interdite
web_ports = ['3128']
if ACTIVER_SQUID2:
    web_ports.append(cfg.get('proxy', 'proxy2_port'))
WEB_PORTS = ','.join(web_ports)
