#-*-coding:utf-8-*-
""" script de migration pour les groupes de machine """
from amon.era.config import f_poste_name as f_poste_name_new
from amon.era import postes as postes_module
from amon import backend
from os.path import join, isfile

# pour avoir du log
debug = False

SAVED_FILES_PATH = "/usr/share/ead2/backend/tmp/sauvegarde_migrations/era"

f_poste_name_old = {'web':join(SAVED_FILES_PATH, 'horaires_ip.txt'),
                    'all':join(SAVED_FILES_PATH, "poste.txt"),
                    'destination':join(SAVED_FILES_PATH, "destination.txt"),
                    }

f_regles_old = join(SAVED_FILES_PATH, "regles.csv")

poste_keys_old = {'web':('poste',  'hdeb', 'hfin', 'jdeb', 'jfin'),
                  'all':('poste',),
                  'destination':('poste',)
                  }

parse_all = lambda a:{'poste':a.strip()}

poste_inverse_syntax_old = {'all':parse_all,
                            'web':postes_module.parse_web, # ce parser gère l'absence d'interface
                            'destination':parse_all}

def load_postes_old(mode):
    """ load les interdictions version 2.0
        @mode: web, all, ou destination
    """
    f_name = f_poste_name_old[mode]
    if isfile(f_name):
        return [poste_inverse_syntax_old[mode](line) for line in open(f_name).read().splitlines() if line.strip()]
    else:
        return []

def add_interface_to_postes(postes, zones=(0,1)):
    """
        ajoute les interfaces aux dicos de la listes des postes
        on recupere le couple iface, zone pour chaque poste et les place dans le dico correspondant
    """
    # recuperation des zones
    all = backend.get_filter_zones()

    # initialisation du dico de retour
    zones_postes = {}
    for zone in zones:
        zones_postes[zone] = []

    # placement poste par poste
    for poste in postes:
        ip = poste['poste']
        for zone in zones:
            for iface in all[zone]:
                if backend.detect_interface(iface['adresse_ip'], ip):
                    if debug:
                        print("++++ Le poste %s est associé à l'interface %s sur la zone %s"%(ip,
                                                                                        iface['nom'],
                                                                                        zone))
                    poste['interface'] = iface['nom']
                    zones_postes[zone].append(poste)

        if 'interface' not in poste:# poste non placé, à renvoyer vers un fichier texte?
            #FIXME: sauvegarder les postes non récupérés
            pass
    # print "~~~~~~~~~"
    # print zones_postes
    return zones_postes

def migration_postes(zones=(0,1)):
    """ migre les fichiers de postes interdits """
    # gestion des interdictions webs
    for mode in ('all', 'web', 'destination'):
        if debug:
            print("++++ Migration des fichiers d'interdictions de type %s"%mode)

        oldies = load_postes_old(mode)
        if mode == "destination":
            zones_postes = dict([(zone, oldies) for zone in zones])
        else:
            zones_postes = add_interface_to_postes(oldies, zones)
        for zone, value in zones_postes.items():
            postes_module.save_forbidden_poste(zone, mode, value)

def migration_regles(zones=(0,1)):
    """ migre les fichiers de regles optionnelles """
    # FIXME: à faire
    pass

def migration_era(auth='oui'):
    if auth == 'oui':
        zones = (0,1)
    else:
        zones = (0,)
    if debug:
        print("====> Migration des fichiers de configuration liés à era (postes et règles optionnelles")
    migration_postes(zones)
    migration_regles(zones)
