#*-*coding:utf-8*-*
""" outil de gestion des fichiers de règles du pare-feu """

from amon.backend import get_other_interfaces, get_interfaces
from os.path import isfile

f_name_tmpl = "/var/lib/eole/config/regles.csv"
regles_tmpl = "%(desc)s,%(val)s,%(occ)s,%(eth)s"


def load(zone=None, libelle=False):
    """
        renvoie la liste des règles optionnelles era pour la zone zone
    """
    f_name = f_name_tmpl
    if isfile(f_name):
        rules = []
        with open(f_name, 'r') as f_stream:
            lines = f_stream.read().splitlines()
        if zone != None:
            # règles de la zone 'zone'
            for line in lines:
                eth = line.split(',')[3]
                if eth in get_interfaces(zone):
                    rule = {'desc':line.split(',')[0],
                                  'val':line.split(',')[1],
                                  'occ':line.split(',')[2],
                                  'eth':line.split(',')[3]}
                    if libelle:
                        rule['libelle'] = line.split(',')[0]
                    rules.append(rule)
            return rules
        else:
            # règles des interfaces sans zone (bastion ,extérieur...)
            for line in lines:
                eth = line.split(',')[3]
                if eth not in get_other_interfaces(zone):
                    rule = {'desc':line.split(',')[0],
                                  'val':line.split(',')[1],
                                  'occ':line.split(',')[2],
                                  'eth':line.split(',')[3]}
                    if libelle:
                        rule['libelle'] = line.split(',')[0]
                    rules.append(rule)
            return rules
    return []

def get_all_rules():
    """ renvoie l'ensemble des règles optionnelles
    """
    with open(f_name_tmpl, 'r') as f_name_tmpl_stream:
        all_rules = [{'desc':line.split(',')[0],
                      'val':line.split(',')[1],
                      'occ':line.split(',')[2],
                      'eth':line.split(',')[3]} for line in f_name_tmpl_stream.read().splitlines()]
        return all_rules


def save(result):
    """
        sauvegarde la configuration des règles optionnelles
    """
    all_rules = get_all_rules()
    for rule in all_rules:
        for new_rule in result:
            if rule['desc'] == new_rule['desc']:
                rule['val'] = new_rule['val']

    lines = []
    for val in all_rules:
        lines.append(regles_tmpl%val)
    f_name = f_name_tmpl
    if lines:
        with open(f_name, 'w') as f_stream:
            f_stream.write('\n'.join(lines))
    return True
