#-*-coding:utf-8-*-
""" migration des fichiers de configuration dansguardian"""
from os.path import isfile, join, isdir
from amon.backend import command_statusoutput
from amon.guardian import dans_tools
from amon.guardian.config import dans_status, DANS_LOCAL_SUBDIR, DANS_LOCAL_DIR, filtergroupslist as filtergroupslist_new

SAVED_FILES_PATH = "/usr/share/ead2/backend/tmp/sauvegarde_migrations/dansguardian"

# pour avoir un debug
debug = False

# migration des:
#               filtres optionnels
#               option de filtrage
#               wihtelist
#               blacklist
#               greysitelist
#               types mime
#               extensions
#               utilisateurs (seulement si l'authentification est activée)

# anciens fichiers (vont changer lors de la sauvegarde de ceux-ci avant migration cf pre-upgrade
filter_mode_old = join(SAVED_FILES_PATH, 'filtres-users')

sitelist_mode_olds = {
                      'blacklist':join(SAVED_FILES_PATH, 'domains'),
                      'whitelist':join(SAVED_FILES_PATH, 'white'),
                      'extensions':join(SAVED_FILES_PATH, 'extensions'),
                      'mime':join(SAVED_FILES_PATH, 'types_mime'),
                      }
sitelist_mode_news = {
                     'blacklist':join(DANS_LOCAL_SUBDIR, 'domains'),
                     'whitelist':join(DANS_LOCAL_SUBDIR, 'whites'),
                     'extensions':join(DANS_LOCAL_SUBDIR, 'extensions'),
                     'mime':join(DANS_LOCAL_SUBDIR, 'types_mime'),
                     }

whitesitelist_old = join(SAVED_FILES_PATH, 'greysitelist')
whitesitelist_new = join(DANS_LOCAL_DIR, 'f4', 'site_liste_blanche')

filtergroupslist_old = join(SAVED_FILES_PATH, 'filtergroupslist')

dans_status_old = join(SAVED_FILES_PATH, 'filtrage-contenu')
dans_status_new = dans_status

def copy_file(orig, dest):
    """ copie un fichier vers un autre ne l'écrasant """
    # nettoyage du fichier (pas de ligne vide)
    if isfile(orig):
        lines = open(orig).read().splitlines()
        lines = [line.strip() for line in lines if line.strip()]
        f_ = open(orig, 'w')
        f_.write('\n'.join(lines))
        f_.close()
        a,b = command_statusoutput("cp -rf %s %s"%(orig, dest))
        if a:
            print("----> Échec de copie de %s vers %s : \n %s"%(orig, dest, b))

def save_dans_status(status, zone):
    status_f = open(dans_status_new%zone, 'w')
    status_f.write(status)
    status_f.close()

# filtres generaux : 1,5,6,7
# filtres spéciaux : 2,3,4
main_filters = (1,5,6,7)
def migration_dansguardian(auth='oui'):
    if auth == 'oui':
        zones = (0,1)
    else:
        zones = (0,)
    # pour zone in zones:                              ([0] ou [0,1] selon si auth ou pas)
    for zone in zones:
        if debug:
            print("====> Migration des fichiers de configuration de la zone %s"%zone)

    #       copier les sitelists dans les reps des zones pour les filtres generaux
        for key, f_name in sitelist_mode_news.items():
            for filter in main_filters:
                dest_dir_name = DANS_LOCAL_SUBDIR % (zone, filter)
                if isdir(dest_dir_name):
                    if debug:
                        print("++++ Migration de la liste : %s de la zone %s"%(key, zone))
                    dest = f_name%(zone, filter)
                    orig = sitelist_mode_olds[key]
                    copy_file(orig, dest)

    #       copier les sites de la whitelist dans le rep du filtre 4
            if debug:
                print("++++ Migration de la whitesitelist de la zone %s"%zone)
            dest = whitesitelist_new%zone
            orig = whitesitelist_old
            copy_file(orig, dest)

    #       copier les filtergroupslist dans le /common / de la zone
            if debug:
                print("++++ Migration des filtergroupslist de la zone %s"%zone)
            dest = filtergroupslist_new%zone
            orig = filtergroupslist_old
            copy_file(orig, dest)

    #       mise en place de option de filtrage
            f_name = filter_mode_old
            if isfile(f_name):
                if debug:
                    print("++++ Migration de l'activation de filtres optionnelles de la zone %s"%zone)
                old_active_filters = open(f_name).read().splitlines()
                new_active_filters = dans_tools.load_category_list(keyword='filtres_opt', zone=zone)
                for filter in new_active_filters.keys():
                    if filter in old_active_filters:
                        new_active_filters[filter] = [1,1,1,1]
                    else:
                        new_active_filters[filter] = [0,0,0,0]
                dans_tools.save_category_list(new_active_filters, keyword='filtres_opt', zone=zone)

    #       mise en place du statut dansguardian
            if isfile(dans_status_old):
                if debug:
                    print("++++ Migration du statut dansguardian pour la zone %s"%zone)
                status = open(dans_status_old).read().splitlines()[0]
                #print("Le statut sauvegardé "+ status)
                if status != '1':
                    save_dans_status(status, zone)
                    dans_tools.set_filtrage(zone, status)
