# -*- coding: utf-8 -*-
"""script de conversion du pickle pour les horaires

FIXME :

- verifier la transformation des horaires
- dupliquer le fichier en deux fichiers (il y a deux fichiers differents)

"""

import pickle
import os

PICKLE_FILE = '/usr/share/ead2/backend/tmp/ipset_schedules.pickle'
NEW_PICKLE_FILE = '/usr/share/ead2/backend/tmp/ipset_schedules0.pickle', '/usr/share/ead2/backend/tmp/ipset_schedules1.pickle'

# Traduction des jours
JOUR = dict(lundi='Mon', mardi='Tue', mercredi='Wed', jeudi='Thu',
            vendredi='Fri', samedi='Sat', dimanche='Sun')

def invert_schedules(schedules):
    """ inverse les plages horaires
    schedules : dictionnaire des jours (et pas des groupes)
    """
    def compare_schedules(a,b):
        """ compare deux plages horaires (pour un tri) """
        a = a['hdeb']
        b = b['hdeb']
        if int(a.split(':')[0])>int(b.split(':')[0]):
            return 1
        elif int(a.split(':')[0]) == int(b.split(':')[0]):
            return 0
        else:
            return -1

    formatted_schedules = []

    for jour in schedules:
        # tri des horaires
        horaires = schedules.get(jour, [])
        horaires.sort(compare_schedules)
        #
        deb = '0:00'
        for horaire in horaires:
            # si le debut de plage n'est pas égal à la fin (pour le début de journée de 0:00 à 0:00)
            if horaire['hdeb'] != deb:
                formatted_schedules.append({'jour':jour, 'hdeb':deb, 'hfin': horaire['hdeb']})
            deb = horaire['hfin']
        # si le début de la nouvelle plage ne correspond pas à la fin de la journée
        if deb not in ['0:00', '23:59', '24:00']:
            formatted_schedules.append({'jour':jour, 'hdeb':deb, 'hfin':'23:59'})

    # retour au formattage initial
    sched = {}
    for item in formatted_schedules:
        sched.setdefault(item['jour'], []).append( dict(hdeb=item['hdeb'], hfin=item['hfin']) )
    return sched

def parse_schedules(groups):
    """  traite tous les groupes un par un et transforme les horaires
    schedules : dictionnaires des groupes
    """
    for gname, sched in groups.items():
        groups[gname] = invert_schedules(sched)
    return groups

def load_pickle(pickle_file=PICKLE_FILE):
    "charge le dictionnaire depuis un fichier pickle"
    fh = open(pickle_file, 'r')
    unpic = pickle.load(fh)
    fh.close()
    return unpic

def dump_pickle(dump_obj, pickle_file=PICKLE_FILE):
    "enregistre un objet dans un fichier au format pickle"
    fh = open(pickle_file, 'w')
    pickle.dump(dump_obj, fh)
    fh.close()

def test_format():
    """
    exemple de format de dico
    test de pickle
    """
    picfile = "test_format.pic"
    dico = {"gr_name":
    {'jour':[{'hdeb':'4:44',
              'hfin':'18:32'}
            ],
            }}
    dump_pickle(dico, picfile)
    assert dico == load_pickle(picfile)
    os.remove(picfile)

def test_transformation():
    """ tests de transformation des horaires
    """
    dico = {'mercredi':[ {'hdeb':'4:44',
              'hfin':'18:32'},

              {'hdeb':'19:27',
              'hfin':'20:52'},
            ],
            }
    result = {'mercredi': [{'hfin': '4:44', 'hdeb': '0:00'},
                        {'hfin': '19:27', 'hdeb': '18:32'},
                        {'hfin': '23:59', 'hdeb': '20:52'}],
              'dimanche': [{'hfin': '23:59', 'hdeb': '0:00'}],
              'vendredi': [{'hfin': '23:59', 'hdeb': '0:00'}],
              'mardi': [{'hfin': '23:59', 'hdeb': '0:00'}],
              'lundi': [{'hfin': '23:59', 'hdeb': '0:00'}],
              'jeudi': [{'hfin': '23:59', 'hdeb': '0:00'}],
              'samedi': [{'hfin': '23:59', 'hdeb': '0:00'}]}
    assert result == invert_schedules(dico)


def main():
    """
    - recupère un dico avec un ancien format horaire depuis un fichier pickle
    - transforme le dico suivant les inversions d'horaires
    - enregistre un dico modifié
    """
    # ancien format horaire
    schedules = load_pickle()
    # transformation des horaires
    inv_sched = parse_schedules(schedules)
    # FIXME : dump dans plusieurs fichiers
    dump_pickle(inv_sched)

if __name__ == '__main__':
    main()

