# -*- coding: utf-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# Test du module de gestion des groupe de machine
#
###########################################################################
""" teste group_manager.py """
from . import autopath
from amon.ipset import group_manager as g

def test_group_create():
    """ teste la création de groupe """
    name ='groupe_test'
    ip_from = '10.121.11.1'
    ip_to = '10.121.11.10'
    g.create_group(0, name, ip_from, ip_to, 'eth1')
    assert g.get_all_groups(0) == [{'name':name, 'ip_from':ip_from, 'ip_to':ip_to, 'active':'0', 'time':'0', 'interface':'eth1'}]
    assert g.get_group(0, name) == {'name':name, 'ip_from':ip_from, 'ip_to':ip_to, 'active':'0', 'time':'0', 'interface':'eth1'}

def test_group_delete():
    """ teste la suppression de groupe """
    name ='groupe_test'
    if not g.is_group(0, name):
        ip_from = '10.121.11.1'
        ip_to = '10.121.11.10'
        g.create_group(0, name, ip_from, ip_to, 'eth1')
    g.del_only_group(0, name)
    assert g.get_all_groups(0) == []

def test_active_group():
    """ teste l'activation/desactivation d'un groupe et de ses horaires"""
    name ='groupe_test'
    if not g.is_group(0, name):
        ip_from = '10.121.11.1'
        ip_to = '10.121.11.10'
        g.create_group(0, name, ip_from, ip_to, 'eth1')
    g.active(0, name)
    assert g.get_all_groups(0) == [{'name':name, 'ip_from':ip_from, 'ip_to':ip_to, 'active':'1', 'time':'0', 'interface':'eth1'}]
    g.unactive(0, name)
    assert g.get_all_groups(0) == [{'name':name, 'ip_from':ip_from, 'ip_to':ip_to, 'active':'0', 'time':'0', 'interface':'eth1'}]
    g.active_time(0, name)
    assert g.get_all_groups(0) == [{'name':name, 'ip_from':ip_from, 'ip_to':ip_to, 'active':'0', 'time':'1', 'interface':'eth1'}]
    g.unactive_time(0, name)
    assert g.get_all_groups(0) == [{'name':name, 'ip_from':ip_from, 'ip_to':ip_to, 'active':'0', 'time':'0', 'interface':'eth1'}]

def teardown_module(module):
    pass
