# -*- coding: utf-8 -*-
"""Simple API fro creolelint reports"""
import sys
from functools import cmp_to_key
from creole.lint.warning import Warn
from creole.lint import warnsymb

def ansi_print(text=None, fhandle=None, newline=True, flush=False):
    """normalized (ansi) print >> file handle function"""
    #sys.stdout.write(self.getvalue())
    if fhandle is None:
        fhandle = sys.stderr
    if text != None:
        #text = text.strip()
        if newline:
            text += '\n'
        fhandle.write(text)
    if flush:
        fhandle.flush()
#    if fhandle:
#        fhandle.close()

class AnsiWriter(object):
    """Définit une interface d'écriture de warnings
    """
    def __init__(self, write_level, output=sys.stdout):
        self.write_level = write_level
        self.output = output

    def process(self, linter):
        """
            parse a result from an item.check() dictionnary
            which is made of {name: TmplVar}
        """
        ident=1
        itemname = linter.name
        warnno = linter.warnno
        warncomment = linter.warncomment
        display = linter.display
        name, level = warnsymb.errorcode[warnno]
        if level > getattr(warnsymb, self.write_level):
            print("\nLint {0} désactivé (niveau {1})".format(itemname, warnsymb.errorlevel[level]))
            return ''
        level = warnsymb.errorlevel[level]
        if not display:
            ansi_print('')
            ansi_print('%s (%s:%s:%s)'%(warncomment, itemname, name, level), self.output)
        checks = linter.check()
        warn = Warn(self.write_level, itemname, warnno, warncomment, checks)
        dico_loc = warn.to_dict()
        if dico_loc != '' and dico_loc != {}:
            ansi_print('')
            ansi_print('%s (%s:%s:%s)'%(warncomment, itemname, name, level), self.output)
            def compare(x,y):
                return (x > y) - (x < y)
            for vfile in dico_loc.keys():
                if vfile != 'dictionnaire':
                    ansi_print('%s\-- fichier %s' % (' '*ident, vfile), self.output, newline=False)
                vlines = dico_loc[vfile]
                vlines.sort(key=cmp_to_key(compare))
                oldline=0
                for vline, var in vlines:
                    if hasattr(var, 'name'):
                        vname = '%%%%%s'%str(var.name)
                    else:
                        vname = str(var)
                    if vline != None:
                        if vline != oldline:
                            ansi_print('', self.output)
                            ansi_print('%s|-- ligne %s' % (' '*(ident+1), vline), self.output, newline=False)
                            pass
                        oldline=vline
                    if vfile != 'dictionnaire':
                        ansi_print(" %s" %vname, self.output, newline=False)
                    else:
                        ansi_print("%s\-- %s" %(' '*ident, vname), self.output)
                if vfile != 'dictionnaire':
                    ansi_print('', self.output)

