#! /usr/bin/python3
# -*- coding: UTF-8 -*-
"""
script de generation d'un certificat ssl
prend un nom de fichier facultatif en argument (destination du certificat)

usage::

    soit
    %prog (-fc) [nom_certif]
    soit
    %prog (-f)

     si [nom_certif] non renseigne, regenere tous les certificats par defaut ainsi que la ca locale.
     Sinon, ne genere que [nom_certif]

    -f :force la regeneration du (ou des) certificat(s) s'il(s) existe(nt)
    -c : dans le cas de la generation d'un seul certificat, on copie la clef

"""
import sys, os
from optparse import OptionParser

from creole import cert
from pyeole.encode import normalize

def parse_command_line():
    parser = OptionParser(__doc__)
    parser.add_option("-c",
                  action="store_true", dest="copy", default=False,
                  help="copie de la clef")

    parser.add_option("-f",
                  action="store_true", dest="regen", default=False,
                  help="force la regeneration de la clef")

    options, args = parser.parse_args()
    if len(args) > 1:
        parser.error("Il faut au maximum un certificat")
    return options, args

options, args = parse_command_line()

regen = options.regen
copy = options.copy

if len(args) == 1:
    certfile = args[0]
else:
    certfile = None

try:
    cert.rehash_if_needed()
    if certfile != None:
        certfile = os.path.abspath(certfile)
        dest_dir = os.path.dirname(certfile)
        if not os.path.isdir(dest_dir):
            print("Répertoire de destination inexistant (%s)" % dest_dir)
            sys.exit(1)
        print("Generation du certificat machine")
        cert.gen_certif(certfile, regen=regen, copy_key=copy)
    else:
        # génération de tous les certificats (CA, eole, scribe...)
        cert.gen_certs(regen=regen)
    sys.exit(0)
except Exception as err:
    print("Erreur : ")
    print('{0}'.format(normalize(err)))
    sys.exit(1)
