from pytest import raises
from os import makedirs
from os.path import isfile, join, isdir
from shutil import rmtree

from creole import config, loader
from creole.error import CreoleDictConsistencyError


dtdfile = 'data/creole.dtd'
if isfile(dtdfile):
    relative = True
else:
    relative = False
    dtdfile = '/usr/share/creole/creole.dtd'
    if not isfile(dtdfile):
        raise Exception('unable to find dtdfile')

destfile = '/tmp/test.xml'
if relative:
    dico_dirs = 'tests/flattener_dicos'
else:
    dico_dirs = '/usr/share/creole/tests/flattener_dicos'


def test_extra_no_action():
    test_dir = join(dico_dirs, '60extra_mandatory')
    dirs = [test_dir]
    subfolder = join(test_dir, 'subfolder')
    if isdir(subfolder):
        dirs.append(subfolder)
    extra = list()
    subfolder = join(test_dir, 'extra_dirs')
    load_extra = False
    if isdir(subfolder):
        load_extra = True
        loader.eoleextradico = subfolder
    loader.eoledirs = dirs
    cfg = loader.creole_loader(load_values=False, load_extra=True)
    assert len(list(cfg.cfgimpl_get_values().mandatory_warnings())) == 1
    cfg = loader.creole_loader(load_values=False, load_extra=True, mandatory_permissive=False)
    assert len(list(cfg.cfgimpl_get_values().mandatory_warnings())) == 1
    loader.eoleextradico = config.eoleextradico
    loader.eoledirs = config.eoledirs


def test_extra_action():
    test_dir = join(dico_dirs, '60familyaction_mandatory')
    dirs = [test_dir]
    subfolder = join(test_dir, 'subfolder')
    if isdir(subfolder):
        dirs.append(subfolder)
    extra = list()
    subfolder = join(test_dir, 'extra_dirs')
    load_extra = False
    if isdir(subfolder):
        load_extra = True
        loader.eoleextradico = subfolder
    loader.eoledirs = dirs
    cfg = loader.creole_loader(load_values=False, load_extra=True)
    assert len(list(cfg.cfgimpl_get_values().mandatory_warnings())) == 0
    cfg = loader.creole_loader(load_values=False, load_extra=True, mandatory_permissive=False)
    assert len(list(cfg.cfgimpl_get_values().mandatory_warnings())) == 1
    loader.eoleextradico = config.eoleextradico
    loader.eoledirs = config.eoledirs


def test_check_variable():
    test_dir = join(dico_dirs, '10check_option')
    dirs = [test_dir]
    subfolder = join(test_dir, 'subfolder')
    if isdir(subfolder):
        dirs.append(subfolder)
    extra = list()
    subfolder = join(test_dir, 'extra_dirs')
    load_extra = False
    if isdir(subfolder):
        load_extra = True
    else:
        subfolder = ''
    loader.eoleextradico = subfolder
    loader.eoledirs = dirs
    #
    cfg = loader.creole_loader(load_values=False, load_extra=True, rw=True)
    with raises(ValueError):
        cfg.creole.general.int = 150
    cfg.creole.general.int = 50
    #
    loader.eoleextradico = config.eoleextradico
    loader.eoledirs = config.eoledirs


def test_valid_enum_number():
    test_dir = join(dico_dirs, '10valid_enum_number')
    dirs = [test_dir]
    subfolder = join(test_dir, 'subfolder')
    if isdir(subfolder):
        dirs.append(subfolder)
    loader.eoledirs = dirs
    #
    cfg = loader.creole_loader(load_values=False, load_extra=False, rw=True)
    assert cfg.creole.enumfam.enumvar == 1
    #
    loader.eoleextradico = config.eoleextradico
    loader.eoledirs = config.eoledirs


def test_valid_enum_numberdefault():
    test_dir = join(dico_dirs, '10valid_enum_numberdefault')
    dirs = [test_dir]
    subfolder = join(test_dir, 'subfolder')
    if isdir(subfolder):
        dirs.append(subfolder)
    loader.eoledirs = dirs
    #
    cfg = loader.creole_loader(load_values=False, load_extra=False, rw=True)
    assert cfg.creole.enumfam.enumvar == 3
    #
    loader.eoleextradico = config.eoleextradico
    loader.eoledirs = config.eoledirs


def test_no_vars():
    """
    No dict available
    """
    if isdir('/tmp/emptydir'):
        rmtree('/tmp/emptydir')
    makedirs('/tmp/emptydir')
    with raises(CreoleDictConsistencyError):
        loader.creole_loader(force_dirs='/tmp/emptydir')
