#-*- coding:utf-8 -*-
import sys
from os import mkdir
from os.path import isdir, join
from shutil import rmtree
from creole import eosfunc
from creole.client import CreoleClient

if sys.version_info[0] >= 3:
    unicode = str

def test_is_ip():
    """
    Tests sur la fonction is_ip
    """
    assert eosfunc.is_ip('1.1.1.1')
    assert eosfunc.is_ip('0.0.0.0')
    assert not eosfunc.is_ip('eole.ac-test.fr')

def test_calc_classe():
    """
    Tests sur la fonction calc_classe
    """
    classe = eosfunc.calc_classe('255.255.255.0')
    # la fonction doit retourner de l'unicode (#8356)
    assert type(classe) == unicode
    assert classe == u'24'

def test_concat():
    """
    Tests sur la fonction concat
    """
    assert eosfunc.concat(u'a', u'b') == u'ab'
    assert eosfunc.concat(u'a', attr=u'b') == u'ab'
    assert eosfunc.concat(attr1=u'a', attr2='b') == u'ab'
    # argument à None (#7701)
    assert eosfunc.concat(u'a', None, u'b') is None
    # argument nommé à None (#7138)
    assert eosfunc.concat(attr1=None, attr2='b') is None
    # mélange des deux
    assert eosfunc.concat(u'a', attr=None) is None
    assert eosfunc.concat(None, attr=u'b') is None

def test_concat_path():
    """
    Tests sur la fonction de concaténation de chemins
    """
    assert eosfunc.concat_path(u'/home', u'test') == u'/home/test'
    assert eosfunc.concat_path(u'/home', u'/test') == u'/home/test'
    assert eosfunc.concat_path(u'home', u'test') == u'/home/test'
    assert eosfunc.concat_path(u'home', u'/test') == u'/home/test'
    assert eosfunc.concat_path(u'/', u'test') == u'/test'
    assert eosfunc.concat_path(u'/', u'/test') == u'/test'
    assert eosfunc.concat_path(u'', u'test') == u'/test'
    assert eosfunc.concat_path(u'', u'/test') == u'/test'

def test_list_files():
    """
    Tests sur la fonction listant des fichiers dans un répertoire
    """
    files = ['abc', 'abc.txt', 'abc.xml', 'bcd.txt']
    tmp_dir = '/tmp/test_list_files'
    if isdir(tmp_dir):
        rmtree(tmp_dir)
    mkdir(tmp_dir)
    for fname in files:
        fh = open(join(tmp_dir, fname), 'w')
        fh.write('')
        fh.close()

    assert eosfunc.list_files(tmp_dir) == files
    assert eosfunc.list_files(tmp_dir, wildcards='*.txt') == ['abc.txt', 'bcd.txt']
    assert eosfunc.list_files(tmp_dir, wildcards='*.txt', stripext=True) == ['abc', 'bcd']
    assert eosfunc.list_files(tmp_dir, wildcards='*.txt', basename=False) == [join(tmp_dir, 'abc.txt'), join(tmp_dir, 'bcd.txt')]
    assert eosfunc.list_files(tmp_dir, exception='abc') == ['bcd.txt']
    assert eosfunc.list_files(tmp_dir, exception='abc', substring=False) == ['abc.txt', 'abc.xml', 'bcd.txt']
    assert eosfunc.list_files(tmp_dir, exception=['d.txt', '.xml']) == ['abc', 'abc.txt']
    assert eosfunc.list_files(tmp_dir, exception='tmp') == files
    assert eosfunc.list_files(tmp_dir, exception='bc') == []
    assert eosfunc.list_files(tmp_dir, exception='bc', default=['def']) == ['def']

def test_gw():
    client = CreoleClient()
    adresse_ip_gw = client.get('creole.interface_0.adresse_ip_gw')
    if adresse_ip_gw is not None:
        assert eosfunc.auto_defaultroute()[0][0] == adresse_ip_gw
    else:
        assert eosfunc.auto_defaultroute()[0][0] == '192.168.0.1'
    assert eosfunc.auto_defaultroute()[0][1] == client.get('creole.interface_0.nom_zone_eth0')

def test_calc_multi_domains():
    """
    Tests sur la fonction de concaténation de domaines
    """
    assert eosfunc.calc_multi_domains() == []
    assert eosfunc.calc_multi_domains(None) == []
    assert eosfunc.calc_multi_domains('1.1.1.1') == []
    assert eosfunc.calc_multi_domains('domaine') == ['domaine']
    assert eosfunc.calc_multi_domains(['domaine', '1.1.1.1', None]) == ['domaine']
    multi = eosfunc.calc_multi_domains('domaine1', 'domaine2', ['domaine3', 'domaine1', '1.1.1.1'], 'domaine4')
    multi.sort()
    assert multi == ['domaine1', 'domaine2', 'domaine3', 'domaine4']
