#-*-coding:utf-8*-*
from os import system
from os import popen
from os.path import join, isfile
from creole.eosfunc import calc_classe
from pyeole.process import system_code, system_out

crt_srv = 'testsrv'
crt_user = 'Debian-exim'
crt_path = '/tmp/testcrt'

MASKS = {'128.0.0.0': '1',
         '192.0.0.0': '2',
         '224.0.0.0': '3',
         '240.0.0.0': '4',
         '248.0.0.0': '5',
         '252.0.0.0': '6',
         '254.0.0.0': '7',
         '255.0.0.0': '8',
         '255.128.0.0': '9',
         '255.192.0.0': '10',
         '255.224.0.0': '11',
         '255.240.0.0': '12',
         '255.248.0.0': '13',
         '255.252.0.0': '14',
         '255.254.0.0': '15',
         '255.255.0.0': '16',
         '255.255.128.0': '17',
         '255.255.192.0': '18',
         '255.255.224.0': '19',
         '255.255.240.0': '20',
         '255.255.248.0': '21',
         '255.255.252.0': '22',
         '255.255.254.0': '23',
         '255.255.255.0': '24',
         '255.255.255.128': '25',
         '255.255.255.192': '26',
         '255.255.255.224': '27',
         '255.255.255.240': '28',
         '255.255.255.248': '29',
         '255.255.255.252': '30',
         '255.255.255.254': '31',
         '255.255.255.255': '32'}


def test_InstallSSLFiles():
    """
    Valide la copie des certificats pour un service
    """
    if not isfile('/etc/eole/.instance'):
        print("La fonction 'InstallSSLFiles' est pas fonctionnelle sur un serveur non instancié")
        return

    installcmd = """. /usr/lib/eole/utils.sh
InstallSSLFiles {0} {1} {1} {2} mail""".format(crt_srv, crt_user, crt_path)
    assert system(installcmd) == 0
    #-rw------- 1 Debian-exim Debian-exim 1679 avril 30 14:07 /tmp/testcrt/private/testsrv.key
    res = system_out(['ls', '-al', join(crt_path, 'private', '{}.key'.format(crt_srv))], container='mail')[1].split()
    assert res[0] == '-rw-------'
    assert res[2] == 'Debian-exim'
    assert res[3] == 'Debian-exim'
    #-rw-r--r-- 1 Debian-exim Debian-exim 1464 avril 30 14:07 /tmp/testcrt/certs/testsrv.crt
    res = system_out(['ls', '-al', join(crt_path, 'certs', '{}.crt'.format(crt_srv))], container='mail')[1].split()
    assert res[0] == '-rw-r--r--'
    assert res[2] == 'Debian-exim'
    assert res[3] == 'Debian-exim'
    assert system_code(['rm', '-rf', crt_path], container='mail') == 0


def test_mask2cdr():
    """
    Fonctions de transformation
    du format NetMask au format CIDR
    """
    cmd = """. /usr/lib/eole/utils.sh
mask2cdr {}"""
    for mask, cidr in MASKS.items():
        assert calc_classe(mask) == cidr
        assert popen(cmd.format(mask)).read().rstrip() == cidr

