# -*- coding: utf-8 -*-
"""
Erreurs Creole
"""

class VirtError(Exception):
    """incohérence concernant les conteneurs"""
    pass

#class ValueEoleError(Exception):
#    """Cette valeur n'existe pas"""
#    pass
#
class NoneError(Exception):
    """Valeur vide"""
    pass

class OutOfRange(Exception):
    pass

class TypeEoleError(Exception):
    """Erreur de type"""
    pass

class ConfigError(Exception):
    pass

class NetworkConfigError(Exception):
    """ Network configuration error
    """
    pass

class FileNotFound(ConfigError):
    pass

class TemplateError(ConfigError):
    pass

class TemplateDisabled(TemplateError):
    """Template is disabled.
    """
    pass

class DependencyError(ConfigError):
    pass

#class ConstraintError(ConfigError):
#    pass
#


class LockError(Exception):
    """ Add lock error
    """
    pass


class UnlockError(Exception):
    """ Remove lock error
    """
    pass


class UserExit(Exception):
    """ User exit(0) signal
    """
    pass


class UserExitError(Exception):
    """ User exit(1) signal
    """
    pass


class CreoleOperationError(Exception):
    """Type error or value Error for Creole variable's type or values
    """


class SpaceObjShallNotBeUpdated(Exception):
    """Specific behavior in case of the presence or not
    of an object in the space object
    """


class CreoleDictConsistencyError(Exception):
    """It's not only that the Creole XML is valid against the Creole DTD
    it's that it is not consistent.
    """
