# -*- coding: utf-8 -*-
###########################################################################
# Eole NG - 2013
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################

from .config import structsdn, usersdn, autoritary_source, aaf_type, ConfigError
from .util import random_id, log

#from Cheetah.NameMapper import NotFound as CheetahNotFound

def gen_group_cn(entgroup, siren):
    """
    Génération de l'attribut `cn`.
    Le `cn` se construit de la manière suivante :
    le SIREN, suivi du nom du groupe, séparés par un underscore.

    :param entgroup: `"<id établissement>$<nom du groupe>"`
    :param siren: `{<id etablissement> : <SIREN>}`
    """
    (etab, groupname) = entgroup.split('$')
    if etab in siren:
        return siren[etab] + '_' + groupname
    else:
        raise ValueError("L'établissement {0} n'a pas de SIREN".format(etab))

def gen_group_owner(entgroup, uai):
    """
    Génération de l'attribut `owner`.
    L'attribut `owner` correspond au "dn" de l'établissement
    pour lequel est défini le groupe

    :param entgroup: `"<id établissement>$<nom du groupe>"`
    :param uai: `{<id etablissement> : <UAI>}`
    """
    etab = entgroup.split('$')[0]
    if etab in uai:
        uai_etab = uai[entgroup.split('$')[0]]
        return "ENTStructureUAI={0},{1}".format(uai_etab, structsdn)
    else:
        raise ValueError("L'établissement {0} n'a pas de UAI".format(etab))

def gen_user_cn(surname, givenname):
    """
    Génération de l'attribut `cn`.
    Le `cn` se construit de la manière suivante :
    Nom d'usage en majuscules suivi du prénom usuel

    :param surname: nom d'usage
    :param givenname: prénom usuel
    """
    # FIXME: make a function + "lettres entrelacées"
    # FIXME: caractères accentués sur prénom uniquement
    surname = surname.replace('_', ' ').replace("'", ' ')
    if givenname is not None:
        givenname = givenname.replace('_', ' ').replace("'", ' ')
        return surname.upper() + ' ' + givenname.title()
    return surname.upper()

def gen_user_displayname(surname, givenname):
    """
    Génération de l'attribut `displayName`.
    Le `displayName` se construit de la manière suivante :
    Nom et prénom accentués

    :param surname: nom d'usage
    :param givenname: prénom usuel
    """
    # FIXME: faire des traitements ?
    if givenname is not None:
        return surname.upper() + ' ' + givenname.title()
    return surname.upper()

class LdifTranslator(object):

    def __init__(self):
        # FIXME : hiddeux on est obligé d'initialiser la clé -> a refactorer
        self.eleve = {
                }
        self.transform_eleve = {
                "ENTEleveClasses": self.calc_structure_dn,
                "ENTEleveGroupes": self.calc_structure_dn,
                "ENTPersonStructRattach": self.calc_structure_dn,
                "ENTPersonJointure": self.calc_autoritary_jointure,
                "userPassword": self.calc_user_password,
                          }

    #    # FIXME groupe pour les eleves (est-ce a mettre ici???)
    #    groupe = {'ENTEleveMEF':'mef_id',
    #                      'ENTEleveLibelleMEF':'mef',
    #                      "ENTEleveNivFormation":'niveau',
    #                      "ENTEleveFiliere":'filiere',
    #                      "ENTEleveClasses":'classe',
    #                      "ENTEleveGroupes":'groupes',
    #             }

        self.responsable = {
                }
        self.transform_responsable = {
                "ENTAuxPersRelEleveEleve": self.calc_eleves_dn,
                "ENTPersonJointure": self.calc_autoritary_jointure,
                "userPassword": self.calc_user_password,
                }

        self.enseignant = {
                }
        self.transform_enseignant = {
                "ENTPersonStructRattach": self.calc_structure_dn,
                "ENTAuxEnsMatiereEnseignEtab": self.calc_structure_dn,
                "ENTAuxEnsClasses": self.calc_structure_dn,
                "ENTAuxEnsGroupes": self.calc_structure_dn,
                "ENTPersonJointure": self.calc_autoritary_jointure,
                "userPassword": self.calc_user_password,
                               }

        self.administratif = {
                }
        self.transform_administratif = {
                "ENTPersonFonctions": self.escape_commas,
                "ENTPersonStructRattach": self.calc_structure_dn,
                #"ENTAuxEnsMatiereEnseignEtab": self.calc_structure_dn,
                #"ENTAuxEnsClasses": self.calc_structure_dn,
                #"ENTAuxEnsGroupes": self.calc_structure_dn,
                "ENTPersonJointure": self.calc_autoritary_jointure,
                "userPassword": self.calc_user_password,
                               }

        self.etablissement = {
                'ENTStructureSIREN': 'ou',
                # on copie ENTStructureJointure car il est modifié ensuite
                'ENTStructureJointure': 'ENTStructureJointure_ori',
                }
        self.transform_etablissement = {
                'ENTStructureJointure': self.calc_autoritary_jointure,
                'ENTEtablissementStructRattachFctl': self.calc_structure_dn,
                }

        # on copie "description" car il est modifié ensuite
        self.classe = {
                'description':'description_ori',
                }
        self.transform_classe = {
                'description': self.calc_classe_desc,
                'member': self.calc_eleves_dn,
                }

        # on copie "description" car il est modifié ensuite
        self.groupe = {
                'description':'description_ori',
                }
        self.transform_groupe = {
                'description': self.calc_group_desc,
                'member': self.calc_eleves_dn,
                }

    def transform_values(self, key, value, tablename):
        transform = "transform_" + tablename
        if key in getattr(self, transform):
            fctname = getattr(self, transform)[key]
            return fctname(value)
        return value

    def escape_commas(self, value):
        if value is not None:
            value = value.replace(',', r'\,')
        return value

    def calc_user_password(self, value):
        if isinstance(value, bytes):
            return value.decode('utf-8')

    def calc_structure_dn(self, value):
        """
        Calcul du DN d'établissement
        """
        if value is None:
            attr = value
        elif '$' in value:
            # cas de groupes ou classes => multi-valuée possible
            # dn d'un établissement suivi des classes/groupes associés
            # séparateur "$"
            etabs = {}
            for group in value.strip().split('\n'):
                if '$' not in group:
                    log.error("format de groupe invalide : {0} dans {1}".format(group,
                                                                    value))
                    continue
                struct, grp = group.strip().split('$')
                grp = grp.replace(',', r'\,')
                if grp.strip() == '':
                    log.error("groupe vide dans : {0}".format(value))
                    continue
                if struct in etabs:
                    if grp not in etabs[struct]:
                        etabs[struct].append(grp)
                else:
                    etabs[struct] = [grp]
            values = []
            for struct, groups in etabs.items():
                # FIXME: it must be ENTStructureUAI=<UAI> instead of cn=s<ENTPersonJointure>
                values.append(u"cn=s{0},{1}${2}".format(struct, structsdn, '$'.join(groups)))
            attr = '\n'.join(values)
        else:
            # FIXME: it must be ENTStructureUAI=<UAI> instead of cn=s<ENTPersonJointure>
            attr = "cn=s{0},{1}".format(value, structsdn)
        return attr

    def calc_autoritary_jointure(self, value):
        """
        Les attributs clés de jointure sont construits comme suit :
        - Identifiant de la source autoritaire (ENT ou AC-<ACAD> ou <autre>)
        - Suivi du caractère "$"
        - Suivi de la clé de jointure fournie par la source autoritaire pour désigner l'objet
        """
        # pour l'instant alimentation uniquement par AAF => AC-<ACAD>
        return autoritary_source+'$'+value

    def calc_eleves_dn(self, value):
        """
        Transformation d'une liste d'uid d'élèves
        en une liste de dn d'élèves
        """
        if value is None:
            log.error("Fonction calc_eleves_dn appelée avec value=None !")
            attr = value
        else:
            if aaf_type =="openldap":
                pre = "uid="
            elif aaf_type == "samba4":
                pre = "CN="
            else:
                raise ConfigError("wrong or unknown aaf_type configuration value: {}".format(aaf_type))
            post = ",{0}".format(usersdn)
            result = []
            for uid in value.strip().split('\n'):
                result.append(pre+uid+post)
            attr = "\n".join(result)
        return attr

    def calc_group_desc(self, entgroup, group_type='Groupe'):
        """
        Calcul de l'attribut description pour un Groupe

        :param entgroup: `"<id établissement>$<nom du groupe>"`
        :param group_type: type du groupe ("Groupe", "Classe", ...)
        """
        return "{0} {1}".format(group_type, entgroup.split('$')[1])

    def calc_classe_desc(self, entclasse):
        """
        Calcul de l'attribut description pour une Classe
        :param entclasse: `"<id établissement>$<nom de la classe>"`
        """
        return self.calc_group_desc(entclasse, 'Classe de')


#    # FIXME: old version XXX
#    def translate(self, tablename, update=False):
#        translated_rows = []
#        mapping = getattr(self, tablename)
#        if not update:
#            res = self.fetch_table(tablename)
#        else:
#            res = self.fetch_table_updated(tablename)
#        for row in res:
#            new_row = {}
#            for key, value in row.items():
#                if key in mapping:
#                    mapi = mapping[key]
#                    new_row[mapi] = self.transform_values(mapi, value, tablename)
#                new_row[key] = self.transform_values(key, value, tablename)
#            translated_rows.append(new_row)
#        return translated_rows
#    def fetch_table(self, tablename):
#        rows = db.fetchall(tablename)
#        return rows
#
#    def fetch_table_updated(self, tablename):
#        rows = db.fetchall(tablename, "WHERE FieldActionType = 'UPDATE'")
#        return rows

    def translate_one(self, tablename, row):
        """
        Récupération et transforation d'une entrée MySQL
        :param tablename: nom de la table MySQL
        :param row: résultat du "fetch" d'une entrée
        """
        new_row = {}
        mapping = getattr(self, tablename)
        for key, value in row.items():
            if key in mapping:
                mapi = mapping[key]
                new_row[mapi] = self.transform_values(mapi, value, tablename)
            new_row[key] = self.transform_values(key, value, tablename)
        return new_row
