#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Mise à jour du mot de passe LDAP
# Equipe Eole eole@ac-dijon.fr

import sys
from glob import glob
from os.path import join
from pyeole.process import system_code
from creole.client import CreoleClient
from pyeole.service import manage_services
from pyeole.ssha import ssha_encode
from configparser import ConfigParser

dico = CreoleClient()

no_restart = False
# on demande le nouveau mot de passe
# si il n'est pas passé comme paramètre
if len(sys.argv) > 1:
    new_pass = sys.argv[1]
    if len(sys.argv) > 2:
        no_restart = True
else:
    new_pass = ""
    while len(new_pass) < 5:
        if new_pass != "":
            print("le mot de passe est trop court (5 caractères au moins)")
        new_pass = input("\nNouveau mot de passe pour l'admin LDAP ? ")

# récupération du mot de passe chiffré
crypt_pwd = ssha_encode(new_pass).decode()

container_mode = dico.get_creole('mode_conteneur_actif', 'non') == 'oui'

# recupération de la liste des fichiers à modifier
modifs = {}
password_files = glob("/usr/share/eole/annuaire/password_files/*.ini")
for fic in password_files:
    cfg = ConfigParser()
    cfg.read(fic)
    for section in cfg.sections():
        container = cfg[section].get('container', 'root').replace("'", "")
        group = CreoleClient().get_creole("container_name_"+container)

        # Work on container group
        cfg[section]['container'] = group
        if section not in modifs:
            modifs[section] = {}
            for key in cfg[section]:
                if key != 'string':
                    modifs[section][key] = cfg[section][key].replace("'", "").replace('"', '')
                else:
                    # keep double-quotes + string can be multi (#31568)
                    modifs[section][key] = cfg[section][key].replace("'", "").split(',')
            modifs[section]['container'] = [cfg[section]['container'].replace("'", "")]

        elif container_mode:
            # hack pour les fichier multi-conteneurs
            if group not in modifs[section]['container']:
                modifs[section]['container'].append(group)


samba = False
# parcours du dictionnaire des fichiers
for name, option in modifs.items():

    # lecture des options
    chaines_recherche = option['string']
    container_list = option.get('container', ['root'])
    short_path = join(option['path'], name)
    if not isinstance(chaines_recherche, list):
        chaines_recherche = [chaines_recherche]

    smb = dico.get_creole('smb_netbios_name', False)
    if smb:
        samba = True

    for container in container_list:
        prefix = dico.get_creole('container_path_{0}'.format(container))
        file_path = prefix+short_path

        print("\nMise à jour du fichier %s..." % str(file_path))
        for chaine_recherche in chaines_recherche:

            # lecture du fichier de conf
            conf_file = open(file_path)
            buffer_in = conf_file.readlines()
            conf_file.close()

            buffer_out = ""
            # on parcourt le fichier
            for line in buffer_in:
                # si la ligne actuelle contient la chaine recherchée
                if line.startswith(chaine_recherche):
                    print("définition du mot de passe trouvée : %s" % line.strip())
                    # on ajoute les possibles tabulations ou espaces en début de ligne
                    buffer_out += line[0:line.index(chaine_recherche)]
                    buffer_out += chaine_recherche
                    if name == 'slapd.conf':
                        buffer_out += crypt_pwd
                    else:
                        buffer_out += new_pass
                    if chaine_recherche.endswith('"'):
                        # si le mot de passe est entre guillemets, on ajoute le guillemet fermant
                        buffer_out += '"'
                    if name.endswith('.pl') or name.endswith('.pm') or name.endswith('.php'):
                        buffer_out += ';'
                    elif name == 'lsc.xml':
                        #FIXME: hack for lsc.xml (eole-ad)
                        buffer_out += '</password>'
                    buffer_out += "\n"
                else:
                    # sinon, on recopie la ligne d'origine
                    buffer_out += line

            # sauvegarde du fichier de conf
            conf_file = open(file_path, "w")
            conf_file.write(buffer_out)
            conf_file.close()

        rights = option.get('rights')
        if rights:
            cmd = ['chown', rights, short_path]
            system_code(cmd, container=container)
        mode = option.get('mode')
        if mode:
            system_code(['chmod', mode, file_path])

# mise à jour du mot de passe LDAP pour samba
if samba:
    print("\nMise à jour de Samba ..")
    cmd = ["smbpasswd", '-c', '/etc/smbldap-tools/smb.conf', '-w', new_pass]
    ret = system_code(cmd, container='fichier')
    if ret != 0:
        raise Exception('Erreur à la mise à jour Samba : %s' % str(ret[1:]))

if not no_restart:
    print("\nredémarrage des services, veuillez patienter ...")
    # visiblement il vaut mieux le faire à chaque fois surtout pour ldap !
    manage_services('restart', 'slapd', container='annuaire')
    #if samba:
    #    service_code('smbd', 'restart', 'fichier')
    if dico.get_creole('activer_courier', 'non') != 'non':
        manage_services('restart', 'courier-authdaemon', container='mail')
