#!/bin/sh
LC_ALL=fr_FR.UTF-8
export LC_ALL

function RunAs()
{
        user=${1}
        cmd=${2}
        su - ${user} -c "${cmd}"
        return ${?}
}

logPath=$(CreoleGet geoexport_path)
logPath2="$logPath/logs"

pgpassRoot="/root/.pgpass"
pgpassPostgres="/var/lib/postgresql/.pgpass"
logPath=$(CreoleGet geoexport_path)
logDir="$logPath/logs"
log="$logPath/logs/exports.log"
date=$(/bin/date)
listeBases="/var/lib/postgresql/listeBases"

echo "Debut des exports du $date" > $log

#test de l'existence du repertoire de sortie
if [ ! -d $logPath2 ]; then
     mkdir -p $logPath2
    chown postgres $logPath2
fi

if [ ! -e "$pgpassRoot" ] && [ ! -e "$pgpassPostgres" ]; then
	echo "aucun pgpass" >> $log
	echo "fin des exports du $date" >> $log
	exit 1
fi

if [ "$pgpassRoot" -nt "$pgpassPostgres" ]; then
    rm -f $pgpassPostgres
#le pgpass de root est le plus recent
	cp "$pgpassRoot" "$pgpassPostgres"
    chown postgres:postgres $pgpassPostgres
fi

chown -R postgres $logDir

#Generation de la liste des tables à exporter
RunAs postgres "/var/lib/postgresql/genListeExport.sh"

#suppression des anciens fichiers exportes
if [ -d "$logPath" ];then
    rm -f $logPath/*.shp
    rm -f $logPath/*.dbf
    rm -f $logPath/*.prj
    rm -f $logPath/*.shx
else
    echo "pas de chemin pour stocker les exports" >> $log
    exit 1
fi

#exports
/var/lib/postgresql/exporTables.sh >> $log

rm -f /var/lib/postgresql/exporTables.sh


