#!/bin/bash

function getRevProxDomains()
{
    local names=($(CreoleGet revprox_domainname))
    local wildcards=($(CreoleGet revprox_domain_wildcard))
    local cert=($(CreoleGet revprox_le_cert 2> /dev/null))
    local toRet=""
    local i=0
    local i_cert=0

    for name in ${names[@]}
    do
        wildcard="${wildcards[${i}]}"
        if [[ ${wildcard} == "non" ]]
        then
            rep="${cert[${i_cert}]}"
            if [[ ${rep} == 'oui' ]]
            then
                toRet="${toRet} ${name}"
            fi
            ((i_cert+=1))
        fi
        ((i+=1))
    done

    echo ${toRet}
    return 0
}

# NOTE: Toute modification à cette fonction doit être reportée sur le template zstat.cfg
function getExtraDomains()
{
    DOMAINS=""
    for domain in $(CreoleGet le_extra_names)
    do
        DOMAINS="${DOMAINS} ${domain}"
    done

    if [[ "$(CreoleGet activer_revprox non )" == "oui" ]] && [[ "$(CreoleGet revprox_activate_http)" == "oui" ]]
    then
        DOMAINS="${DOMAINS} $(getRevProxDomains)"
    fi

    # Removing duplicate entries in domain list
    DOMAINS=$(awk '{ while(++i<=NF) printf (!a[$i]++) ? $i FS : ""; i=split("",a); print ""  }'  <<< ${DOMAINS})
    echo $DOMAINS
}
