# -*- coding: utf-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# Gestion du proxy pour EoleRegister
#
# Ce logiciel permet de déterminer la configuration matérielle d'une machine
# afin d'alimenter une base de données de matériel compatible.
#
###########################################################################

import xmlrpclib, httplib
from creole.client import CreoleClient

def get_proxy():
    """
    Proxy utilisé par le serveur
    """
    client = CreoleClient()
    if client.get_creole('activer_proxy_client') == 'oui':
        proxy = "{0}:{1}".format(client.get_creole('proxy_client_adresse'),
                                 client.get_creole('proxy_client_port'))
    else:
        proxy = ''
    return proxy

class ProxiedTransport(xmlrpclib.Transport):
    """
    Définition d'un transport personnalisé
    pour permettre l'utilisation d'un proxy
    """
    def set_proxy(self, proxy):
        self.proxy = proxy
    def make_connection(self, host):
        self.realhost = host
        http = httplib.HTTP(self.proxy)
        return http
    def send_request(self, connection, handler, request_body):
        connection.putrequest("POST", 'http://%s%s' % (self.realhost, handler))
    def send_host(self, connection, host):
        connection.putheader('Host', self.realhost)

def my_proxy(eoleproxy):
    proxy = ProxiedTransport()
    proxy.set_proxy(eoleproxy)
    return proxy

