#!/usr/bin/env python
# -*- coding: utf-8 -*- 
###########################################################################
# 
# Eole NG - 2007  
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
# 
# Eole-register
# 
# Ce logiciel permet de déterminer la configuration matérielle d'une machine
# afin d'alimenter une base de données de matériel compatible.
# 
###########################################################################
import autopath
from lshwobjects import *

def test_initializelshw():
    """dct : dictionnaire récupéré par xml-rpc
    "ce dictionnaire est généré par un Computer().todict()
    """
    dct = {'product': 'SCENIC P / SCENICO P',
           'multimedia': {'product': "AC'97 Sound Controller",
           'vendor': 'Silicon Integrated Systems [SiS]'},
           'vendor': 'FUJITSU SIEMENS',
           'disks': [{'product': 'WDC WD800BB-55JKA0',
           'vendor': 'Western Digital'}],
           'networks': [{'product': 'NC100 Network Everywhere \
            Fast Ethernet 10/100', 'vendor': 'ADMtek'}],
           'id': 'bf7937e2e3df3e676d39af10b348e893',
           'version': 'amon-2.0', 'memory': {'size': '1073741824'},
           'date': '07-05-07', 'processor': {'width': '32',
           'product': 'Intel(R) Celeron(R) CPU 2.66GHz',
           'vendor': 'Intel Corp.'},
           'diskcards': [{'vendor': 'Silicon Integrated Systems [SiS]',
           'product': '5513 [IDE]', 'driver': 'SIS_IDE'}]}
    c = Computer()
    c.fromdict(dct)
    assert c.product == 'SCENIC P / SCENICO P'
    assert c.vendor == 'FUJITSU SIEMENS'

def test_disk():
    """teste le disk
    """
    dct = {'disks': [{'product': 'WDC WD800BB-55JKA0', 'vendor':
           'Western Digital'}]}
    result = [Disk().fromdict(d) for d in dct['disks']]   
    assert result[0].product == 'WDC WD800BB-55JKA0'
    assert result[0].vendor == 'Western Digital'

def test_multimedia():
    """teste le multimedia
    """
    dct = {'multimedia': {'product': "AC'97 Sound Controller",
           'vendor': 'Silicon Integrated Systems [SiS]'}}
    m = Multimedia()
    m.fromdict(dct['multimedia'])
    assert m.product == "AC'97 Sound Controller"
    assert m.vendor == "Silicon Integrated Systems [SiS]"

def test_network():
    """teste les cartes réseaux
    """
    dct = {'networks': [{'product':
           'NC100 Network Everywhere Fast Ethernet 10/100',
           'vendor': 'ADMtek'}]}
    result = [Network().fromdict(n) for n in dct['networks']]
    assert result[0].product == "NC100 Network Everywhere Fast Ethernet 10/100"
    assert result[0].vendor == "ADMtek"

def test_memory():
    """teste la mémoire
    """
    dct = {'memory': {'size': '1073741824'}}
    m = Memory()
    m.fromdict(dct['memory'])
    assert m.size == "1073741824"

def test_processor():
    """teste le processeur
    """
    dct = {'processor': {'width': '32',
           'product': 'Intel(R) Celeron(R) CPU 2.66GHz',
           'vendor': 'Intel Corp.'}}
    p = Processor()
    p.fromdict(dct['processor'])
    assert p.product == "Intel(R) Celeron(R) CPU 2.66GHz"
    assert p.vendor == "Intel Corp."
    assert p.width == "32"

def test_diskcard():
    """teste les cartes controleur
    """
    dct = {'diskcards': [{'vendor': 'Silicon Integrated Systems [SiS]',
           'product': '5513 [IDE]', 'driver': 'SIS_IDE'}]}
    result = [Diskcard().fromdict(c) for c in dct['diskcards']]     
    assert result[0].product == "5513 [IDE]"
    assert result[0].vendor == "Silicon Integrated Systems [SiS]"
    assert result[0].driver == "SIS_IDE"
