#!/usr/bin/env python3

import socketserver
import subprocess

from xmlrpc.server import (
    SimpleXMLRPCDispatcher,
    SimpleXMLRPCRequestHandler,
)


class UnixStreamXMLRPCRequestHandler(
    SimpleXMLRPCRequestHandler
):
    disable_nagle_algorithm = False

    def address_string(self):
        return self.client_address


class UnixStreamXMLRPCServer(
    socketserver.UnixStreamServer, SimpleXMLRPCDispatcher
):
    def __init__(
        self,
        addr,
        log_requests=True,
        allow_none=True,
        encoding=None,
        bind_and_activate=True,
        use_builtin_types=True,
    ):
        self.logRequests = log_requests
        SimpleXMLRPCDispatcher.__init__(
            self, allow_none, encoding, use_builtin_types
        )
        socketserver.UnixStreamServer.__init__(
            self,
            addr,
            UnixStreamXMLRPCRequestHandler,
            bind_and_activate,
        )


# Server Demo

server = UnixStreamXMLRPCServer("/run/eole-sso/socket")

with server:
    server.register_introspection_functions()

    # Register a function under a different name
    def change_password(username, password, from_url):
        cmd = "/usr/sbin/changepasswordeole.pl {} '{}'".format(username, password)
        try:
            ret = subprocess.check_output(cmd, stderr=subprocess.STDOUT, shell=True)
        except subprocess.CalledProcessError as e:
            return 'failure'
        return 'success'

    server.register_function(change_password)

    # Run the server's main loop
    server.serve_forever()
