# -*- coding: UTF-8 -*-
###########################################################################
#
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# libssoclient.py
#
# fonctions clientes pour la librairie sso Eole
#
###########################################################################

from urllib import urlopen

AUTH_SERVER = 'localhost'
AUTH_PORT = '8090'


def verify_cookie(session_id, auth_server):
    return auth_server.verify_session_id(session_id)

def get_session_id(request):
    # warning, cookie name can be changed in server configuration
    cookie = request.getCookie("EoleSSOServer")
    return cookie # If cookie is None, return None

def get_user(session_id):
    # récupération des infos de session auprès du serveur d'authentification
    fp = urlopen('http://%s:%s/userinfo?session_id=%s' % (AUTH_SERVER, AUTH_PORT, session_id))
    response = fp.read()
    return response

