# -*- coding: utf-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# config.py
#
# fichier de configuration pour la librairie SSO Eole
#
###########################################################################

import locale
import os
import sys
import socket
import stat
from json import load


SSO_PATH = os.path.dirname(__file__)

# REGLAGES DE LOCALE
# encoding = locale.getpreferredencoding() -> ne fonctionne pas toujours si le service est démarré au boot
encoding = 'UTF-8'
LC_ALL = 'fr_FR.UTF-8'

EOLE_CONFDIR = '/etc/eolesso/'
# lecture de la configuration creole du serveur
# Les valeurs trouvées sont prioritaires sur les valeurs
# définies manuellement dans ce fichier
with open('{}sso.conf'.format(EOLE_CONFDIR), 'r') as fh:
    dico = load(fh)
# passage des valeurs unicode en str
if sys.version_info[0] < 3:
    for var_name, val in dico.items():
        if isinstance(val, unicode):
            dico[var_name] = val.encode(encoding)
        elif isinstance(val, list):
            # variables multi-valuées
            for index, item in enumerate(val):
                if isinstance(item, unicode):
                    val[index] = item.encode(encoding)

SERVER_IP_ADDR = dico['adresse_ip_eth0']
AUTH_SERVER_ADDR = dico['eolesso_adresse']
LDAP_SERVER = dico['eolesso_ldap']
LDAP_PORT = dico['eolesso_port_ldap']
LDAP_BASE = dico['eolesso_base_ldap']
LDAP_READER = dico['eolesso_ldap_reader']
LDAP_MATCH_ATTRIBUTE = dico['eolesso_ldap_match_attribute']
LDAP_LABEL = dico['eolesso_ldap_label']
LDAP_INFOS = dico['eolesso_ldap_infos']
LDAP_LOGIN_OTP = dico['eolesso_ldap_login_otp']
LDAP_USE_TLS = [use_tls == 'oui' for use_tls in dico['eolesso_ldap_use_tls']]
LDAP_READER_PASSFILE = dico['eolesso_ldap_reader_passfile']
# description du compte local (association de compte OpenID Connect
LOCAL_ACCOUNT_LABEL = dico['eolesso_local_account_label']
# identifiant rne du serveur si disponible
ETABLISSEMENT = dico['libelle_etab']
# port de la page web d'authentification
EOLESSO_PORT = dico['eolesso_port']
# version du protocole CAS (1 ou 2)
CAS_VERSION = 2
# URL du serveur parent si déclaré
if dico['eolesso_adresse_parent']:
    PARENT_URL = 'https://%s:%s' % (dico['eolesso_adresse_parent'],
                                    dico['eolesso_port_parent'] or '8443')
else:
    PARENT_URL = None
# Nom d'entité du serveur pour le protocole SAMLv2 (calculé automatiquement si chaine vide)
ACADEMIE = dico['nom_academie']
RNE = dico['numero_etab']
IDP_IDENTITY = dico['eolesso_entity_name'] or "urn:fi:%s:et-%s:1.0" % (ACADEMIE, RNE or AUTH_SERVER_ADDR)
# CERTIFICAT DU SERVEUR
CERTFILE = dico['eolesso_cert']
KEYFILE = dico['eolesso_key']
# certificat de l'autorité de certification (pour validation des clients en mode proxy)
# si valeur vide : utilisation de ca.crt dans le même répertoire que CERTFILE
if os.path.isfile(dico['eolesso_ca_location']):
    CA_LOCATION = dico['eolesso_ca_location']
else:
    CA_LOCATION = ""
# CSS de la page de login (fichier utilisé : /usr/share/sso/interface/<nom_css>.css)
# Autre possibilité : héritage automatique ajouter theme.css
# dans /usr/share/sso/interface/theme/style/
DEFAULT_CSS = dico['eolesso_css']
RESPONSIVE = dico['eolesso_responsive'] == 'oui'
# Gestion des proxys http pour l'envoi de certaines requêtes
# (mode CAS : déconnexion / envoi de PGT)
if dico['activer_proxy_client'] == 'oui':
    PROXY_SERVER = dico['proxy_client_adresse']
    PROXY_PORT = dico['proxy_client_port']
else:
    PROXY_SERVER = ""
    PROXY_PORT = ""

# Gestion de l'avertissement internet explorer
if dico['activer_envole'] == 'oui':
    ACTIVER_ENVOLE = True
    ACTIVER_ENVOLE_INFOS = dico['activer_envole_infos'] == 'oui'
else:
    ACTIVER_ENVOLE = False
    ACTIVER_ENVOLE_INFOS = False
if dico.get('web_url', ''):
    POSH_URL = dico['web_url']

# Cookie
COOKIE_NAME = dico['eolesso_cookie_name']
COOKIE_DOMAIN = dico.get('eolesso_cookie_domain')

#CONSTANTES
############

# DUREE de validité d'une assertion SAML
STATEMENT_TIMEOUT = 600
# décalage autorisé pour la vérification des dates des messages SAML
TIME_ADJUST = int(dico['sso_saml_time_adjust'])

# définition du délai de timeout par défaut des connexions (en secondes)
SOCK_TIMEOUT = 5.0
# durée de vie d'un login ticket : 2 heures
SESSION_TIMER = int(dico['eolesso_session_timeout'])
# durée de vie d'un ticket d'application : 5 minutes (utilisable une seule fois)
APP_TIMER = 300
# durée de vie d'un nombre magique permettant la communication entre un frontend et un backend
# ce timeout est reinitialise a chaque fois qu'une action est lancée
MAGIC_NUMBER_TIMEOUT =  60 * 5
# durée de vie des sessions expirées. Quand une session expire, on la garde dans un cache pour savoir
# si quand une session est non valide, si elle avait expirée ou si elle n'a jamais existée
EXPIRED_SESSION_TIMEOUT = 60 * 60 * 2
# Taille du backlog
BACKLOG = dico['eolesso_backlog']
# active ou non l'envoi de requêtes de logout pour les clients CAS
SEND_CAS_LOGOUT = dico['cas_send_logout'] == 'oui'
# active ou non la vérfication des urls d'application
# (si True, on ne répond pas à une application non référencée dans app_filters)
VERIFY_APP = dico['cas_verify_service'] == 'oui'
# indique si un formulaire doit être affiché lors de l'envoi d'une demande de fédération
DISPLAY_FEDERATION = dico['federation_transparente'] == 'oui'
# Taille du pool de thread
THREAD_POOL_SIZE = dico['eolesso_thread_pool_size']
# attributs utilisateurs à ne pas conserver
IGNORED_ATTRS = ['userPassword', 'sambaLMPassword', 'sambaNTPassword']
# correspondance par défaut pour les attributs de détermination
# de la branche de recherche
SEARCH_BASE_ATTRS = {'rne':'ou','RNE':'ou','UAI':'ou','ENTPersonStructRattach':'ou'}
# contexte minimum accepté en mode fournisseur de service SAML
DEFAULT_MIN_CONTEXT = "urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport"
# gestion de l'authentification SecurID en mode IDP sur ce serveur
# Cette option nécessite l'installation de l'agent PAM linux fourni par RSA
# http://www.rsa.com/node.aspx?id=1177 (dernière version testée : 7.0)
USE_SECURID = dico['eolesso_pam_securid'] == 'oui'
# définition d'un fournisseur d'identité distant pour SecurID
# (laisser vide si USE_SECURID est activé)
# FIXME : cette option n'est pas encore fonctionelle. laisser à blanc
# Pour l'instant on ne peut s'authentifier en OTP que sur le serveur SSO
# ayant accès au serveur RSA (via PAM)
SECURID_PROVIDER = ""
# Détection des mot de passe OTP (taille longueur minimum/maximum/expression régulière)
OTPPASS_MINSIZE = int(dico['eolesso_otppass_minsize'])
OTPPASS_MAXSIZE = int(dico['eolesso_otppass_maxsize'])
OTPPASS_REGX = dico['eolesso_otppass_regx']
# délai maximum (secondes) laissé à l'utilisateur lorsqu'il doit saisir un 2ème passcode
OTP_TIMEOUT = 300
# indique si on doit rediriger sur une mire externe en cas de
# désynchronysation de la clé OTP
REDIRECT_DESYNC = True
REDIRECT_DESYNC = dico['eolesso_otp_desync'] == 'oui'
OTP_PORTAL = dico['eolesso_otp_portal']
METRICS = dico['eolesso_metrics'] == 'oui'
# configuration du mode cluster
if dico.get('eolesso_activer_cluster', 'non') == 'oui':
    CLUSTER = True
    if dico.get('eolesso_cluster_server', 'non') == 'oui':
        # Serveur Redis atteignable directement
        REDIS_HOST = dico.get('eolesso_redis_host')
        REDIS_PORT = dico.get('eolesso_redis_port')
    else:
        # Accès à un serveur Redis distant via un tunnel SSL (service stunnel local)
        REDIS_HOST = "127.0.0.1"
        REDIS_PORT = dico.get('eolesso_stunnel_port')
else:
    CLUSTER = False
    REDIS_HOST = "127.0.0.1"
    REDIS_PORT = 6379

# active ou non les log de debug (fonctions utilisant @trace)
DEBUG_LOG = False

# Gestion des adresses ip secondaires dans le cas des conteneurs
ALTERNATE_IPS = {}
for container in ['web','mail','fichier']:
    # pour tous les conteneurs autorisés à utiliser le mode proxy, on utilise
    # l'adresse du conteneur maître comme adresse alternative (pour validation des certificats)
    varname = 'container_ip_{0}'.format(container)
    if varname in dico:
        ALTERNATE_IPS[dico[varname]] = SERVER_IP_ADDR

# configuration du serveur AD
if dico.get('ad_domain', ''):
    AD_DOMAIN = dico['ad_domain']
    AD_SERVER = dico['ad_server']
else:
    AD_DOMAIN = None

# Authentification OpenID
OPENID_PROVIDERS = {}
if dico.get('activer_openid', 'non') == 'oui':
    prov_listinfos = [dict() for i in range(len(dico['openid_providers']))]
    # vérification des droits sur le fichier des id/clé OpenID
    OPENID_CONFFILE = os.path.join(EOLE_CONFDIR, 'eolesso_openid.conf')
    if os.path.isfile(OPENID_CONFFILE):
        file_perms = stat.S_IRUSR|stat.S_IWUSR #(rw-------)
        os.chmod(OPENID_CONFFILE, file_perms)
    for prop in ['openid_providers_label', 'openid_providers_issuer',
                 'openid_providers_about_url', 'openid_providers_about_label',
                 'openid_providers_auth_endp', 'openid_providers_reg_endp', 'openid_providers_token_endp',
                 'openid_providers_userinfo_endp', 'openid_providers_jwks_uri',
                 'openid_providers_logout_endp']:
        for index, val in enumerate(dico[prop]):
            prov_listinfos[index][prop.replace('openid_providers_', '')] = val
    for index, prov_id in enumerate(dico['openid_providers']):
        OPENID_PROVIDERS[prov_id] = prov_listinfos[index]
else:
    OPENID_CONFFILE = ""

# VALEURS CALCULEES
####################
# URL de la page web d'authentification
AUTH_FORM_URL = 'https://%s:%s' % (AUTH_SERVER_ADDR, EOLESSO_PORT)
# URL du serveur d'authentification
AUTH_SERVER='https://%s:%s/xmlrpc' % (AUTH_SERVER_ADDR, EOLESSO_PORT)
# REPERTOIRES DES DONNEES
##########################

# répertoire des filtres d'application
FILTER_DIR = os.path.join(SSO_PATH, 'app_filters')
# répertoire des fichiers metadata pour les entités SAML
METADATA_DIR = os.path.join(SSO_PATH, 'metadata')
# répertoire des définitions de jeux d'attributs
ATTR_SET_DIR = os.path.join(SSO_PATH, 'attribute_sets')
# répertoire des correspondances d'utilisateurs
SECURID_USER_DIR = os.path.join(SSO_PATH, 'securid_users')
OPENID_USER_DIR = os.path.join(SSO_PATH, 'openid_users')
# répertoire des fichiers d'information pour les homonymes
HOMONYMES_DIR = os.path.join(SSO_PATH, 'interface', 'info_homonymes')
